/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.OpenPgpV5Fingerprint;
import org.pgpainless.key.OpenPgpV6Fingerprint;
import org.pgpainless.key._64DigitFingerprint;

public abstract class OpenPgpFingerprint
implements CharSequence,
Comparable<OpenPgpFingerprint> {
    protected static final Charset utf8 = Charset.forName("UTF-8");
    protected final String fingerprint;

    public static OpenPgpFingerprint of(PGPPublicKey key) {
        if (key.getVersion() == 4) {
            return new OpenPgpV4Fingerprint(key);
        }
        if (key.getVersion() == 5) {
            return new OpenPgpV5Fingerprint(key);
        }
        if (key.getVersion() == 6) {
            return new OpenPgpV6Fingerprint(key);
        }
        throw new IllegalArgumentException("OpenPGP keys of version " + key.getVersion() + " are not supported.");
    }

    public static OpenPgpFingerprint of(PGPKeyRing ring) {
        return OpenPgpFingerprint.of(ring.getPublicKey());
    }

    @Deprecated
    public static OpenPgpFingerprint parse(String fingerprint) {
        String fp = fingerprint.replace(" ", "").trim().toUpperCase();
        if (fp.matches("^[0-9A-F]{40}$")) {
            return new OpenPgpV4Fingerprint(fp);
        }
        if (fp.matches("^[0-9A-F]{64}$")) {
            return new _64DigitFingerprint(fp);
        }
        throw new IllegalArgumentException("Fingerprint does not appear to match any known fingerprint patterns.");
    }

    @Deprecated
    public static OpenPgpFingerprint parseFromBinary(byte[] binaryFingerprint) {
        String hex = Hex.toHexString((byte[])binaryFingerprint).toUpperCase();
        return OpenPgpFingerprint.parse(hex);
    }

    public OpenPgpFingerprint(String fingerprint) {
        String fp = fingerprint.replace(" ", "").trim().toUpperCase();
        if (!this.isValid(fp)) {
            throw new IllegalArgumentException(String.format("Fingerprint '%s' does not appear to be a valid OpenPGP V%d fingerprint.", fingerprint, this.getVersion()));
        }
        this.fingerprint = fp;
    }

    public OpenPgpFingerprint(@Nonnull byte[] bytes) {
        this(new String(bytes, utf8));
    }

    public OpenPgpFingerprint(PGPPublicKey key) {
        this(Hex.encode((byte[])key.getFingerprint()));
        if (key.getVersion() != this.getVersion()) {
            throw new IllegalArgumentException(String.format("Key is not a v%d OpenPgp key.", this.getVersion()));
        }
    }

    public OpenPgpFingerprint(@Nonnull PGPPublicKeyRing ring) {
        this(ring.getPublicKey());
    }

    public OpenPgpFingerprint(@Nonnull PGPSecretKeyRing ring) {
        this(ring.getPublicKey());
    }

    public OpenPgpFingerprint(@Nonnull PGPKeyRing ring) {
        this(ring.getPublicKey());
    }

    public abstract int getVersion();

    protected abstract boolean isValid(@Nonnull String var1);

    public abstract long getKeyId();

    @Override
    public int length() {
        return this.fingerprint.length();
    }

    @Override
    public char charAt(int i) {
        return this.fingerprint.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.fingerprint.subSequence(i, i1);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.fingerprint;
    }

    public abstract String prettyPrint();
}

