/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.gnupg.GnuPGDummyKeyUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.exception.MissingDecryptionMethodException;

public class TryDecryptWithUnavailableGnuDummyKeyTest {
    @Test
    public void testAttemptToDecryptWithRemovedPrivateKeysThrows() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Hardy Hardware <hardy@hard.ware>");
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.get().addRecipient(certificate)));
        ByteArrayInputStream plaintextIn = new ByteArrayInputStream("Hello, World!\n".getBytes());
        Streams.pipeAll((InputStream)plaintextIn, (OutputStream)encryptionStream);
        encryptionStream.close();
        PGPSecretKeyRing removedKeys = GnuPGDummyKeyUtil.modify((PGPSecretKeyRing)secretKeys).removePrivateKeys(GnuPGDummyKeyUtil.KeyFilter.any());
        ByteArrayInputStream ciphertextIn = new ByteArrayInputStream(ciphertextOut.toByteArray());
        Assertions.assertThrows(MissingDecryptionMethodException.class, () -> PGPainless.decryptAndOrVerify().onInputStream((InputStream)ciphertextIn).withOptions(ConsumerOptions.get().addDecryptionKey(removedKeys)));
    }
}

