/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;

public class VerifyWithMissingPublicKeyCallbackTest {
    @Test
    public void testMissingPublicKeyCallback() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing signingSecKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice");
        final PGPPublicKey signingKey = (PGPPublicKey)new KeyRingInfo((PGPKeyRing)signingSecKeys).getSigningSubkeys().get(0);
        final PGPPublicKeyRing signingPubKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)signingSecKeys);
        PGPPublicKeyRing unrelatedKeys = TestKeys.getJulietPublicKeyRing();
        String msg = "Arguing that you don't care about the right to privacy because you have nothing to hideis no different than saying you don't care about free speech because you have nothing to say.";
        ByteArrayOutputStream signOut = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signOut).withOptions(ProducerOptions.sign((SigningOptions)new SigningOptions().addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), signingSecKeys, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)), (OutputStream)signingStream);
        signingStream.close();
        DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(signOut.toByteArray())).withOptions(new ConsumerOptions().addVerificationCert(unrelatedKeys).setMissingCertificateCallback(new MissingPublicKeyCallback(){

            public PGPPublicKeyRing onMissingPublicKeyEncountered(@Nonnull Long keyId) {
                Assertions.assertEquals((long)signingKey.getKeyID(), (long)keyId, (String)"Signing key-ID mismatch.");
                return signingPubKeys;
            }
        }));
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verificationStream, (OutputStream)plainOut);
        verificationStream.close();
        Assertions.assertArrayEquals((byte[])msg.getBytes(StandardCharsets.UTF_8), (byte[])plainOut.toByteArray());
        OpenPgpMetadata metadata = verificationStream.getResult();
        Assertions.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(signingPubKeys));
    }
}

