/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.MultiMap;

public class MultiSigningSubkeyTest {
    private static PGPSecretKeyRing signingKey;
    private static PGPPublicKeyRing signingCert;
    private static SubkeyIdentifier primaryKey;
    private static SubkeyIdentifier signingKey1;
    private static SubkeyIdentifier signingKey2;
    private static SecretKeyRingProtector protector;

    @BeforeAll
    public static void generateKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        signingKey = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}))).addUserId("Alice <alice@pgpainless.org>").build();
        signingCert = PGPainless.extractCertificate((PGPSecretKeyRing)signingKey);
        ListIterator signingSubkeys = PGPainless.inspectKeyRing((PGPKeyRing)signingKey).getSigningSubkeys().listIterator();
        primaryKey = new SubkeyIdentifier((PGPKeyRing)signingKey, ((PGPPublicKey)signingSubkeys.next()).getKeyID());
        signingKey1 = new SubkeyIdentifier((PGPKeyRing)signingKey, ((PGPPublicKey)signingSubkeys.next()).getKeyID());
        signingKey2 = new SubkeyIdentifier((PGPKeyRing)signingKey, ((PGPPublicKey)signingSubkeys.next()).getKeyID());
        protector = SecretKeyRingProtector.unprotectedKeys();
    }

    @Test
    public void detachedSignWithAllSubkeys() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(protector, signingKey, DocumentSignatureType.BINARY_DOCUMENT)));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)signingStream);
        signingStream.close();
        MultiMap sigs = signingStream.getResult().getDetachedSignatures();
        Assertions.assertTrue((boolean)sigs.containsKey((Object)primaryKey));
        Assertions.assertTrue((boolean)sigs.containsKey((Object)signingKey1));
        Assertions.assertTrue((boolean)sigs.containsKey((Object)signingKey2));
    }

    @Test
    public void detachedSignWithSingleSubkey() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(protector, signingKey, signingKey1.getKeyId())));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)signingStream);
        signingStream.close();
        MultiMap sigs = signingStream.getResult().getDetachedSignatures();
        Assertions.assertEquals((int)1, (int)sigs.flatten().size());
        Assertions.assertTrue((boolean)sigs.containsKey((Object)signingKey1));
    }

    @Test
    public void inlineSignWithAllSubkeys() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addInlineSignature(protector, signingKey, DocumentSignatureType.BINARY_DOCUMENT)));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)signingStream);
        signingStream.close();
        ByteArrayInputStream signedIn = new ByteArrayInputStream(out.toByteArray());
        DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)signedIn).withOptions(ConsumerOptions.get().addVerificationCert(signingCert));
        Streams.drain((InputStream)verificationStream);
        verificationStream.close();
        List sigs = verificationStream.getMetadata().getVerifiedSignatures();
        List sigKeys = sigs.stream().map(SignatureVerification::getSigningKey).collect(Collectors.toList());
        Assertions.assertTrue((boolean)sigKeys.contains(primaryKey));
        Assertions.assertTrue((boolean)sigKeys.contains(signingKey1));
        Assertions.assertTrue((boolean)sigKeys.contains(signingKey2));
    }

    @Test
    public void inlineSignWithSingleSubkey() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addInlineSignature(protector, signingKey, signingKey1.getKeyId())));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)signingStream);
        signingStream.close();
        ByteArrayInputStream signedIn = new ByteArrayInputStream(out.toByteArray());
        DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)signedIn).withOptions(ConsumerOptions.get().addVerificationCert(signingCert));
        Streams.drain((InputStream)verificationStream);
        verificationStream.close();
        List sigs = verificationStream.getMetadata().getVerifiedSignatures();
        Assertions.assertEquals((int)1, (int)sigs.size());
        Assertions.assertEquals((Object)signingKey1, (Object)((SignatureVerification)sigs.get(0)).getSigningKey());
    }
}

