/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.Passphrase;

public class GenerateKeys {
    @Test
    public void generateModernEcKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        String userId = "gbaker@pgpainless.org";
        String password = "ra1nb0w";
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)userId, password);
        PGPPublicKeyRing publicKey = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        String asciiArmoredPublicKey = PGPainless.asciiArmor((PGPKeyRing)publicKey);
        Assertions.assertTrue((boolean)asciiArmoredPublicKey.startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----"));
        KeyRingInfo keyInfo = new KeyRingInfo((PGPKeyRing)secretKey);
        Assertions.assertEquals((int)3, (int)keyInfo.getSecretKeys().size());
        Assertions.assertEquals((Object)userId, (Object)keyInfo.getPrimaryUserId());
        Assertions.assertEquals((int)PublicKeyAlgorithm.EDDSA.getAlgorithmId(), (int)keyInfo.getPublicKey().getAlgorithm());
        Assertions.assertEquals((int)PublicKeyAlgorithm.EDDSA.getAlgorithmId(), (int)((PGPPublicKey)keyInfo.getSigningSubkeys().get(0)).getAlgorithm());
        Assertions.assertEquals((int)PublicKeyAlgorithm.ECDH.getAlgorithmId(), (int)((PGPPublicKey)keyInfo.getEncryptionSubkeys(EncryptionPurpose.ANY).get(0)).getAlgorithm());
    }

    @Test
    public void generateSimpleRSAKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String userId = "mpage@pgpainless.org";
        String password = "b1angl3s";
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().simpleRsaKeyRing((CharSequence)userId, RsaLength._4096, password);
        KeyRingInfo keyInfo = new KeyRingInfo((PGPKeyRing)secretKey);
        Assertions.assertEquals((int)1, (int)keyInfo.getSecretKeys().size());
        Assertions.assertEquals((Object)userId, (Object)keyInfo.getPrimaryUserId());
        Assertions.assertEquals((int)PublicKeyAlgorithm.RSA_GENERAL.getAlgorithmId(), (int)keyInfo.getPublicKey().getAlgorithm());
    }

    @Test
    public void generateSimpleECKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String userId = "mhelms@pgpainless.org";
        String password = "tr4ns";
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)userId, password);
        KeyRingInfo keyInfo = new KeyRingInfo((PGPKeyRing)secretKey);
        Assertions.assertEquals((int)2, (int)keyInfo.getSecretKeys().size());
        Assertions.assertEquals((Object)userId, (Object)keyInfo.getPrimaryUserId());
    }

    @Test
    public void generateCustomOpenPGPKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        UserId userId = UserId.newBuilder().withName("Morgan Carpenter").withEmail("mcarpenter@pgpainless.org").withComment("Pride!").build();
        String additionalUserId = "mcarpenter@christopher.street";
        Passphrase passphrase = Passphrase.fromPassword((String)"1nters3x");
        PGPSecretKeyRing secretKey = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._BRAINPOOLP256R1), (KeyFlag)KeyFlag.ENCRYPT_STORAGE, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).overridePreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128}).overridePreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256}).overridePreferredCompressionAlgorithms(new CompressionAlgorithm[]{CompressionAlgorithm.ZIP, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZLIB}).build()).addSubkey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)EllipticCurve._BRAINPOOLP384R1), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).addUserId(userId)).addUserId(additionalUserId).setPassphrase(passphrase).build();
        KeyRingInfo keyInfo = new KeyRingInfo((PGPKeyRing)secretKey);
        Assertions.assertEquals((int)3, (int)keyInfo.getSecretKeys().size());
        Assertions.assertEquals((Object)"Morgan Carpenter (Pride!) <mcarpenter@pgpainless.org>", (Object)keyInfo.getPrimaryUserId());
        Assertions.assertTrue((boolean)keyInfo.isUserIdValid((CharSequence)additionalUserId));
    }
}

