/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.NotationRegistry;

public class ManagePolicy {
    @BeforeEach
    @AfterEach
    public void resetPolicy() {
        PGPainless.getPolicy().setSignatureHashAlgorithmPolicy(Policy.HashAlgorithmPolicy.static2022SignatureHashAlgorithmPolicy());
        PGPainless.getPolicy().setRevocationSignatureHashAlgorithmPolicy(Policy.HashAlgorithmPolicy.static2022RevocationSignatureHashAlgorithmPolicy());
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
        PGPainless.getPolicy().setSymmetricKeyDecryptionAlgorithmPolicy(Policy.SymmetricKeyAlgorithmPolicy.symmetricKeyDecryptionPolicy2022());
        PGPainless.getPolicy().setSymmetricKeyEncryptionAlgorithmPolicy(Policy.SymmetricKeyAlgorithmPolicy.symmetricKeyEncryptionPolicy2022());
        PGPainless.getPolicy().setCompressionAlgorithmPolicy(Policy.CompressionAlgorithmPolicy.anyCompressionAlgorithmPolicy());
        PGPainless.getPolicy().getNotationRegistry().clear();
    }

    @Test
    public void setCustomSignatureHashPolicy() {
        Policy policy = PGPainless.getPolicy();
        Policy.HashAlgorithmPolicy sigHashAlgoPolicy = policy.getSignatureHashAlgorithmPolicy();
        Assertions.assertTrue((boolean)sigHashAlgoPolicy.isAcceptable(HashAlgorithm.SHA512));
        Assertions.assertFalse((boolean)sigHashAlgoPolicy.isAcceptable(HashAlgorithm.SHA1));
        Policy.HashAlgorithmPolicy customPolicy = new Policy.HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224, HashAlgorithm.SHA1));
        policy.setSignatureHashAlgorithmPolicy(customPolicy);
        sigHashAlgoPolicy = policy.getSignatureHashAlgorithmPolicy();
        Assertions.assertTrue((boolean)sigHashAlgoPolicy.isAcceptable(HashAlgorithm.SHA512));
        Assertions.assertTrue((boolean)sigHashAlgoPolicy.isAcceptable(HashAlgorithm.SHA1));
    }

    @Test
    public void setCustomPublicKeyAlgorithmPolicy() {
        Policy policy = PGPainless.getPolicy();
        Policy.PublicKeyAlgorithmPolicy pkAlgorithmPolicy = policy.getPublicKeyAlgorithmPolicy();
        Assertions.assertTrue((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 4096));
        Assertions.assertTrue((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 2048));
        Assertions.assertFalse((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 1024));
        Assertions.assertTrue((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.ECDSA, 256));
        Policy.PublicKeyAlgorithmPolicy customPolicy = new Policy.PublicKeyAlgorithmPolicy((Map)new HashMap<PublicKeyAlgorithm, Integer>(){
            {
                this.put(PublicKeyAlgorithm.RSA_GENERAL, 3000);
            }
        });
        policy.setPublicKeyAlgorithmPolicy(customPolicy);
        pkAlgorithmPolicy = policy.getPublicKeyAlgorithmPolicy();
        Assertions.assertTrue((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 4096));
        Assertions.assertFalse((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 2048));
        Assertions.assertFalse((boolean)pkAlgorithmPolicy.isAcceptable(PublicKeyAlgorithm.ECDSA, 256));
    }

    @Test
    public void manageKnownNotations() {
        Policy policy = PGPainless.getPolicy();
        NotationRegistry notationRegistry = policy.getNotationRegistry();
        Assertions.assertFalse((boolean)notationRegistry.isKnownNotation("unknown@pgpainless.org"));
        notationRegistry.addKnownNotation("unknown@pgpainless.org");
        Assertions.assertTrue((boolean)notationRegistry.isKnownNotation("unknown@pgpainless.org"));
    }
}

