/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.DateUtil;

public class TestMergeCertificate {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 9F3E C7B3 3FCF 807E 516D  5DA1 C102 B0FC 9A1C 69E9\nComment: Revik Okemi <rev@oke.mi>\n\nlFgEYxXwbRYJKwYBBAHaRw8BAQdAtAWpi1+uUUpe37nSQqybiLpcAoa5KhlpLZmk\nIkqLXn8AAP4s+6jp7OInR4PqasuH0YefMEfPu9ZY5ZHjq3HFoaqEpxTxtBhSZXZp\nayBPa2VtaSA8cmV2QG9rZS5taT6IjwQTFgoAQQUCYxXwbQkQwQKw/JocaekWIQSf\nPsezP8+AflFtXaHBArD8mhxp6QKeAQKbAQUWAgMBAAQLCQgHBRUKCQgLApkBAAAi\nSAEApd8RdhvF33eiUgXlMBU3/ob1/NdMIbVJCBUXj7URYzUBAKxH+BwesiSagsXO\nKbQEOjzu1R7Nd2Hmf+gue9AVQQ0BnF0EYxXwbRIKKwYBBAGXVQEFAQEHQPLc0OH8\n8v+govDgUQs7gnM5NK3H+haFCsq/ILMBb48YAwEIBwAA/2CXgEXUIi4s38GaVbDK\nts7nj3CWwEOAqtLsO8+QcXmoEyuIdQQYFgoAHQUCYxXwbQKeAQKbDAUWAgMBAAQL\nCQgHBRUKCQgLAAoJEMECsPyaHGnpO7AA/2zF7j5cgxCZ+Ws+ENj6Uzgq47kqsRxa\nIi4kPjW1HmCtAP4rie2Z0ra/1alG/wu2bUtxHgEkeTBsHP8pOM5Xz4JVDZxYBGMV\n8G0WCSsGAQQB2kcPAQEHQHofxjdBzpFaLsiyEDRaotbB5/New7vdtAHV7t5rv1BU\nAAD/fnI4ilbhsRYaGSGX5ma7VfkgWiK7UQi04YpJVV3HOEYO/ojVBBgWCgB9BQJj\nFfBtAp4BApsCBRYCAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCYxXwbQAKCRCUM1S1\nVUVbouF5AQDQUJIkFikWriyhSMWEUS52l0i3SlllmPCJuDc1dy389AD9FXCU5+W0\nGT2N1hRb8eIf+0aDiVLCdV3folVbuPaNvgcACgkQwQKw/Jocaem+GwD+NJD8EIdP\nNf4Q3IvT9YFXEbilk+mKw3IdV68DsQxEtQoBAPkugEJxuI2XNEdl6sigtGF94q3u\nIzX9xT12kqD4GtgO\n=slQ4\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String SOFT_REVOCATION = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHsEIBYKAC0FAmMV8kcJEMECsPyaHGnpFiEEnz7Hsz/PgH5RbV2hwQKw/JocaekC\nhwACHQMAAMTqAP9XbUer/yjcAUOpbggqC35zrhzXi4/zc6QuuM9NSLnePwD/YZCn\nNoE+7B24C/SZVr7d4U0ryB2gNWJdvfMfQnGLaQA=\n=d2pq\n-----END PGP SIGNATURE-----";
    private static final Date SOFT_REVOCATION_DATE = DateUtil.parseUTCDate((String)"2022-09-05 12:57:43 UTC");
    private static final String HARD_REVOCATION = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHsEIBYKAC0FAmMV8pUJEMECsPyaHGnpFiEEnz7Hsz/PgH5RbV2hwQKw/JocaekC\nhwACHQIAAFaCAQCZPxqJHe87GqLjaDuMdTPdI1dT8kuHvBC4LfhMP2VobQEAiCgQ\nWMqWZTfJmbhubnUhEnTu/+qPFiHChgDnaJmoMAk=\n=pl4A\n-----END PGP SIGNATURE-----";

    @Test
    public void testRevocationStateWithDifferentRevocationsMerged() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)certificate);
        Assertions.assertTrue((boolean)info.getRevocationState().isNotRevoked());
        PGPSignature softRevocation = (PGPSignature)SignatureUtils.readSignatures((String)SOFT_REVOCATION).get(0);
        PGPPublicKeyRing softRevoked = (PGPPublicKeyRing)KeyRingUtils.injectCertification((PGPKeyRing)certificate, (PGPSignature)softRevocation);
        info = PGPainless.inspectKeyRing((PGPKeyRing)softRevoked, (Date)softRevoked.getPublicKey().getCreationTime());
        Assertions.assertTrue((boolean)info.getRevocationState().isNotRevoked(), (String)"Expect: Cert is not revoked at creation time, although we already added soft revocation");
        info = KeyRingInfo.evaluateForSignature((PGPKeyRing)softRevoked, (PGPSignature)softRevocation);
        Assertions.assertTrue((boolean)info.getRevocationState().isSoftRevocation(), (String)"Expect: Cert is now revoked, since now is after soft revocation creation");
        JUtils.assertDateEquals(SOFT_REVOCATION_DATE, info.getRevocationDate());
        PGPSignature hardRevocation = (PGPSignature)SignatureUtils.readSignatures((String)HARD_REVOCATION).get(0);
        PGPPublicKeyRing hardRevoked = (PGPPublicKeyRing)KeyRingUtils.injectCertification((PGPKeyRing)certificate, (PGPSignature)hardRevocation);
        info = PGPainless.inspectKeyRing((PGPKeyRing)hardRevoked);
        Assertions.assertTrue((boolean)info.getRevocationState().isHardRevocation());
        info = PGPainless.inspectKeyRing((PGPKeyRing)hardRevoked, (Date)hardRevoked.getPublicKey().getCreationTime());
        Assertions.assertTrue((boolean)info.getRevocationState().isHardRevocation(), (String)"Expect: Key is hard revoked, no matter reference time");
        PGPPublicKeyRing merged = PGPainless.mergeCertificate((PGPPublicKeyRing)certificate, (PGPPublicKeyRing)softRevoked);
        info = PGPainless.inspectKeyRing((PGPKeyRing)merged);
        Assertions.assertTrue((boolean)info.getRevocationState().isSoftRevocation());
        merged = PGPainless.mergeCertificate((PGPPublicKeyRing)merged, (PGPPublicKeyRing)hardRevoked);
        info = PGPainless.inspectKeyRing((PGPKeyRing)merged);
        Assertions.assertTrue((boolean)info.getRevocationState().isHardRevocation());
    }
}

