/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class PrimaryUserIdTest {
    @Test
    public void testGetPrimaryUserId() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"alice@wonderland.lit");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"mad_alice@wonderland.lit", SecretKeyRingProtector.unprotectedKeys()).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)"alice@wonderland.lit", (Object)info.getPrimaryUserId());
    }
}

