/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class AddSubkeyWithModifiedBindingSignatureSubpackets {
    public static final long MILLIS_IN_SEC = 1000L;

    @Test
    public void bindEncryptionSubkeyAndModifyBindingSignatureHashedSubpackets() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        KeyRingInfo before = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        PGPKeyPair secretSubkey = KeyRingBuilder.generateKeyPair((KeySpec)KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]).build());
        final long secondsUntilExpiration = 1000L;
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addSubKey(secretSubkey, new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setKeyExpirationTime(true, secondsUntilExpiration);
                hashedSubpackets.addNotationData(false, "test@test.test", "test");
            }
        }, SecretKeyRingProtector.unprotectedKeys(), protector, KeyFlag.SIGN_DATA, new KeyFlag[0]).done();
        KeyRingInfo after = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        List signingKeys = after.getSigningSubkeys();
        signingKeys.removeAll(before.getSigningSubkeys());
        Assertions.assertFalse((boolean)signingKeys.isEmpty());
        PGPPublicKey newKey = (PGPPublicKey)signingKeys.get(0);
        Date newExpirationDate = after.getSubkeyExpirationDate((OpenPgpFingerprint)new OpenPgpV4Fingerprint(newKey));
        Assertions.assertNotNull((Object)newExpirationDate);
        Date now = new Date();
        JUtils.assertEquals(now.getTime() + 1000L * secondsUntilExpiration, newExpirationDate.getTime(), 2000L);
        Assertions.assertTrue((boolean)newKey.getSignatures().hasNext());
        PGPSignature binding = (PGPSignature)newKey.getSignatures().next();
        List notations = SignatureSubpacketsUtil.getHashedNotationData((PGPSignature)binding);
        Assertions.assertEquals((int)1, (int)notations.size());
        Assertions.assertEquals((Object)"test@test.test", (Object)((NotationData)notations.get(0)).getNotationName());
    }
}

