/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.builder.DirectKeySelfSignatureBuilder;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class ThirdPartyDirectKeySignatureBuilderTest {
    @Test
    public void testDirectKeySignatureBuilding() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        DirectKeySelfSignatureBuilder dsb = new DirectKeySelfSignatureBuilder(secretKeys.getSecretKey(), SecretKeyRingProtector.unprotectedKeys());
        Date now = new Date();
        final Date t1 = new Date(now.getTime() + 3600000L);
        dsb.applyCallback(new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setSignatureCreationTime(t1);
                hashedSubpackets.setKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER});
                hashedSubpackets.setPreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.SHA512});
                hashedSubpackets.setPreferredCompressionAlgorithms(new CompressionAlgorithm[]{CompressionAlgorithm.ZIP});
                hashedSubpackets.setPreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256});
                hashedSubpackets.setFeatures(new Feature[]{Feature.MODIFICATION_DETECTION});
            }
        });
        PGPSignature directKeySig = dsb.build(secretKeys.getPublicKey());
        Assertions.assertNotNull((Object)directKeySig);
        secretKeys = (PGPSecretKeyRing)KeyRingUtils.injectCertification((PGPKeyRing)secretKeys, (PGPPublicKey)secretKeys.getPublicKey(), (PGPSignature)directKeySig);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t1);
        PGPSignature signature = info.getLatestDirectKeySelfSignature();
        Assertions.assertNotNull((Object)signature);
        Assertions.assertEquals((Object)directKeySig, (Object)signature);
        Assertions.assertEquals((Object)SignatureType.DIRECT_KEY, (Object)SignatureType.valueOf((int)signature.getSignatureType()));
        Assertions.assertEquals(Collections.singletonList(KeyFlag.CERTIFY_OTHER), (Object)SignatureSubpacketsUtil.parseKeyFlags((PGPSignature)signature));
        Assertions.assertEquals(Collections.singleton(HashAlgorithm.SHA512), (Object)SignatureSubpacketsUtil.parsePreferredHashAlgorithms((PGPSignature)signature));
        Assertions.assertEquals(Collections.singleton(CompressionAlgorithm.ZIP), (Object)SignatureSubpacketsUtil.parsePreferredCompressionAlgorithms((PGPSignature)signature));
        Assertions.assertEquals(Collections.singleton(SymmetricKeyAlgorithm.AES_256), (Object)SignatureSubpacketsUtil.parsePreferredSymmetricKeyAlgorithms((PGPSignature)signature));
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)signature.getKeyID());
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])signature.getHashedSubPackets().getIssuerFingerprint().getFingerprint());
    }
}

