/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.MultiMap;

public class MultiMapTest {
    @Test
    public void isEmptyAfterCreation() {
        MultiMap map = new MultiMap();
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertNull((Object)map.get((Object)"alice"));
        Assertions.assertFalse((boolean)map.containsKey((Object)"alice"));
        Assertions.assertFalse((boolean)map.containsValue((Object)"wonderland"));
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void addOneElement_works() {
        MultiMap multiMap = new MultiMap();
        multiMap.put((Object)"alice", (Object)"wonderland");
        Assertions.assertFalse((boolean)multiMap.isEmpty());
        Assertions.assertEquals((int)1, (int)multiMap.size());
        Assertions.assertTrue((boolean)multiMap.containsKey((Object)"alice"));
        Assertions.assertTrue((boolean)multiMap.containsValue((Object)"wonderland"));
        Assertions.assertNotNull((Object)multiMap.get((Object)"alice"));
        Assertions.assertTrue((boolean)multiMap.get((Object)"alice").contains("wonderland"));
    }

    @Test
    public void addTwoKeys_OneWithTwoValues_works() {
        MultiMap multiMap = new MultiMap();
        multiMap.put((Object)"alice", (Object)"wonderland");
        multiMap.put((Object)"mad", new HashSet<String>(Arrays.asList("hatter", "max")));
        Assertions.assertEquals((int)2, (int)multiMap.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("alice", "mad")), (Object)multiMap.keySet());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("hatter", "max")), (Object)multiMap.get((Object)"mad"));
        Assertions.assertEquals(new HashSet<Set>(Arrays.asList(Collections.singleton("wonderland"), new HashSet<String>(Arrays.asList("hatter", "max")))), new HashSet(multiMap.values()));
        Assertions.assertEquals(Collections.singleton("wonderland"), (Object)multiMap.get((Object)"alice"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("hatter", "max")), (Object)multiMap.get((Object)"mad"));
    }

    @Test
    public void emptyEqualsEmptyTest() {
        MultiMap emptyOne = new MultiMap();
        MultiMap emptyTwo = new MultiMap();
        Assertions.assertEquals((Object)emptyOne, (Object)emptyTwo);
    }

    @Test
    public void notEqualsNull() {
        MultiMap map = new MultiMap();
        Assertions.assertNotEquals((Object)map, null);
    }

    @Test
    public void selfEquals() {
        MultiMap map = new MultiMap();
        Assertions.assertEquals((Object)map, (Object)map);
    }

    @Test
    public void otherClassNotEquals() {
        MultiMap map = new MultiMap();
        Assertions.assertNotEquals((Object)map, (Object)"String");
    }

    @Test
    public void mapEqualsCopy() {
        MultiMap map = new MultiMap();
        map.put((Object)"foo", (Object)"bar");
        map.put((Object)"entries", new HashSet<String>(Arrays.asList("one", "two")));
        MultiMap copy = new MultiMap(map);
        Assertions.assertEquals((Object)map, (Object)copy);
    }

    @Test
    public void emptyAfterClear() {
        MultiMap map = new MultiMap();
        map.put((Object)"test", (Object)"foo");
        Assertions.assertFalse((boolean)map.isEmpty());
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void addTwoRemoveOneWorks() {
        MultiMap map = new MultiMap();
        map.put((Object)"alice", (Object)"wonderland");
        map.put((Object)"bob", (Object)"builder");
        map.removeAll((Object)"alice");
        Assertions.assertFalse((boolean)map.containsKey((Object)"alice"));
        Assertions.assertNull((Object)map.get((Object)"alice"));
        Assertions.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void addMultiValue() {
        MultiMap addOneByOne = new MultiMap();
        addOneByOne.put((Object)"foo", (Object)"bar");
        addOneByOne.put((Object)"foo", (Object)"baz");
        MultiMap addOnce = new MultiMap();
        addOnce.put((Object)"foo", new HashSet<String>(Arrays.asList("baz", "bar")));
        Assertions.assertEquals((Object)addOneByOne, (Object)addOnce);
    }

    @Test
    public void addMultiValueRemoveSingle() {
        MultiMap map = new MultiMap();
        map.put((Object)"foo", (Object)"bar");
        map.put((Object)"foo", (Object)"baz");
        map.remove((Object)"foo", (Object)"bar");
        Assertions.assertFalse((boolean)map.isEmpty());
        Assertions.assertTrue((boolean)map.containsKey((Object)"foo"));
        Assertions.assertEquals(Collections.singleton("baz"), (Object)map.get((Object)"foo"));
    }

    @Test
    public void addMultiValueRemoveAll() {
        MultiMap map = new MultiMap();
        map.put((Object)"foo", (Object)"bar");
        map.put((Object)"foo", (Object)"baz");
        map.put((Object)"bingo", (Object)"bango");
        map.removeAll((Object)"foo");
        Assertions.assertFalse((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey((Object)"foo"));
        Assertions.assertTrue((boolean)map.containsKey((Object)"bingo"));
    }

    @Test
    public void putAll() {
        MultiMap map = new MultiMap();
        map.put((Object)"A", (Object)"1");
        map.put((Object)"A", (Object)"2");
        map.put((Object)"B", (Object)"1");
        MultiMap other = new MultiMap();
        other.put((Object)"A", (Object)"1");
        other.put((Object)"B", (Object)"2");
        other.put((Object)"C", (Object)"3");
        map.putAll(other);
        Assertions.assertTrue((boolean)map.get((Object)"A").contains("1"));
        Assertions.assertTrue((boolean)map.get((Object)"A").contains("2"));
        Assertions.assertTrue((boolean)map.get((Object)"B").contains("1"));
        Assertions.assertTrue((boolean)map.get((Object)"B").contains("2"));
        Assertions.assertTrue((boolean)map.get((Object)"C").contains("3"));
    }

    @Test
    public void flattenEmptyMap() {
        MultiMap empty = new MultiMap();
        Assertions.assertEquals(Collections.emptySet(), (Object)empty.flatten());
    }

    @Test
    public void flattenMap() {
        MultiMap map = new MultiMap();
        map.put((Object)"A", (Object)"1");
        map.put((Object)"A", (Object)"2");
        map.put((Object)"B", (Object)"1");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("1");
        expected.add("2");
        Assertions.assertEquals(expected, (Object)map.flatten());
    }
}

