/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.exception.KeyException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

public final class SigningOptions {
    private final Map<SubkeyIdentifier, SigningMethod> signingMethods = new HashMap<SubkeyIdentifier, SigningMethod>();
    private HashAlgorithm hashAlgorithmOverride;

    @Nonnull
    public static SigningOptions get() {
        return new SigningOptions();
    }

    @Nonnull
    public SigningOptions addSignature(@Nonnull SecretKeyRingProtector signingKeyProtector, @Nonnull PGPSecretKeyRing signingKey) throws PGPException {
        return this.addInlineSignature(signingKeyProtector, signingKey, DocumentSignatureType.BINARY_DOCUMENT);
    }

    @Nonnull
    public SigningOptions addInlineSignatures(@Nonnull SecretKeyRingProtector secrectKeyDecryptor, @Nonnull Iterable<PGPSecretKeyRing> signingKeys, @Nonnull DocumentSignatureType signatureType) throws KeyException, PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addInlineSignature(secrectKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    @Nonnull
    public SigningOptions addInlineSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nonnull DocumentSignatureType signatureType) throws KeyException, PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    @Nonnull
    public SigningOptions addInlineSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nullable CharSequence userId, @Nonnull DocumentSignatureType signatureType) throws KeyException, PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, userId, signatureType, null);
    }

    @Nonnull
    public SigningOptions addInlineSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nullable CharSequence userId, @Nonnull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo((PGPKeyRing)secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), userId.toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            if (signingSecKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), signingPubKey.getKeyID());
            }
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = userId != null ? keyRingInfo.getPreferredHashAlgorithms(userId) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketsCallback, hashAlgorithm, signatureType, false);
        }
        return this;
    }

    @Nonnull
    public SigningOptions addInlineSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, long keyId) throws PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, keyId, DocumentSignatureType.BINARY_DOCUMENT, null);
    }

    @Nonnull
    public SigningOptions addInlineSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, long keyId, @Nonnull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws PGPException {
        KeyRingInfo keyRingInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            if (signingPubKey.getKeyID() != keyId) continue;
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            if (signingSecKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), signingPubKey.getKeyID());
            }
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketsCallback, hashAlgorithm, signatureType, false);
            return this;
        }
        throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), keyId);
    }

    @Nonnull
    public SigningOptions addDetachedSignatures(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull Iterable<PGPSecretKeyRing> signingKeys, @Nonnull DocumentSignatureType signatureType) throws PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addDetachedSignature(secretKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, signingKey, DocumentSignatureType.BINARY_DOCUMENT);
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nonnull DocumentSignatureType signatureType) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nullable CharSequence userId, @Nonnull DocumentSignatureType signatureType) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, userId, signatureType, null);
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, @Nullable CharSequence userId, @Nonnull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) throws PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo((PGPKeyRing)secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), userId.toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            if (signingSecKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), signingPubKey.getKeyID());
            }
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = userId != null ? keyRingInfo.getPreferredHashAlgorithms(userId) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketCallback, hashAlgorithm, signatureType, true);
        }
        return this;
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, long keyId) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, keyId, DocumentSignatureType.BINARY_DOCUMENT, null);
    }

    @Nonnull
    public SigningOptions addDetachedSignature(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing secretKey, long keyId, @Nonnull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws PGPException {
        KeyRingInfo keyRingInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            if (signingPubKey.getKeyID() != keyId) continue;
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            if (signingSecKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), signingPubKey.getKeyID());
            }
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketsCallback, hashAlgorithm, signatureType, true);
            return this;
        }
        throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), keyId);
    }

    private void addSigningMethod(@Nonnull PGPSecretKeyRing secretKey, @Nonnull PGPPrivateKey signingSubkey, @Nullable BaseSignatureSubpackets.Callback subpacketCallback, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull DocumentSignatureType signatureType, boolean detached) throws PGPException {
        SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier((PGPKeyRing)secretKey, signingSubkey.getKeyID());
        PGPSecretKey signingSecretKey = secretKey.getSecretKey(signingSubkey.getKeyID());
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.requireFromId(signingSecretKey.getPublicKey().getAlgorithm());
        int bitStrength = signingSecretKey.getPublicKey().getBitStrength();
        if (!PGPainless.getPolicy().getPublicKeyAlgorithmPolicy().isAcceptable(publicKeyAlgorithm, bitStrength)) {
            throw new KeyException.UnacceptableSigningKeyException(new KeyException.PublicKeyAlgorithmPolicyException(OpenPgpFingerprint.of((PGPKeyRing)secretKey), signingSecretKey.getKeyID(), publicKeyAlgorithm, bitStrength));
        }
        PGPSignatureGenerator generator = this.createSignatureGenerator(signingSubkey, hashAlgorithm, signatureType);
        SignatureSubpackets hashedSubpackets = SignatureSubpackets.createHashedSubpackets(signingSecretKey.getPublicKey());
        SignatureSubpackets unhashedSubpackets = SignatureSubpackets.createEmptySubpackets();
        if (subpacketCallback != null) {
            subpacketCallback.modifyHashedSubpackets(hashedSubpackets);
            subpacketCallback.modifyUnhashedSubpackets(unhashedSubpackets);
        }
        generator.setHashedSubpackets(SignatureSubpacketsHelper.toVector(hashedSubpackets));
        generator.setUnhashedSubpackets(SignatureSubpacketsHelper.toVector(unhashedSubpackets));
        SigningMethod signingMethod = detached ? SigningMethod.detachedSignature(generator, hashAlgorithm) : SigningMethod.inlineSignature(generator, hashAlgorithm);
        this.signingMethods.put(signingKeyIdentifier, signingMethod);
    }

    @Nonnull
    private HashAlgorithm negotiateHashAlgorithm(@Nonnull Set<HashAlgorithm> preferences, @Nonnull Policy policy) {
        if (this.hashAlgorithmOverride != null) {
            return this.hashAlgorithmOverride;
        }
        return HashAlgorithmNegotiator.negotiateSignatureHashAlgorithm(policy).negotiateHashAlgorithm(preferences);
    }

    @Nonnull
    private PGPSignatureGenerator createSignatureGenerator(@Nonnull PGPPrivateKey privateKey, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull DocumentSignatureType signatureType) throws PGPException {
        int publicKeyAlgorithm = privateKey.getPublicKeyPacket().getAlgorithm();
        PGPContentSignerBuilder signerBuilder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKeyAlgorithm, hashAlgorithm.getAlgorithmId());
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signerBuilder);
        signatureGenerator.init(signatureType.getSignatureType().getCode(), privateKey);
        return signatureGenerator;
    }

    @Nonnull
    Map<SubkeyIdentifier, SigningMethod> getSigningMethods() {
        return Collections.unmodifiableMap(this.signingMethods);
    }

    @Nonnull
    public SigningOptions overrideHashAlgorithm(@Nonnull HashAlgorithm hashAlgorithmOverride) {
        this.hashAlgorithmOverride = hashAlgorithmOverride;
        return this;
    }

    @Nullable
    public HashAlgorithm getHashAlgorithmOverride() {
        return this.hashAlgorithmOverride;
    }

    public static final class SigningMethod {
        private final PGPSignatureGenerator signatureGenerator;
        private final boolean detached;
        private final HashAlgorithm hashAlgorithm;

        private SigningMethod(@Nonnull PGPSignatureGenerator signatureGenerator, boolean detached, @Nonnull HashAlgorithm hashAlgorithm) {
            this.signatureGenerator = signatureGenerator;
            this.detached = detached;
            this.hashAlgorithm = hashAlgorithm;
        }

        public static SigningMethod inlineSignature(@Nonnull PGPSignatureGenerator signatureGenerator, @Nonnull HashAlgorithm hashAlgorithm) {
            return new SigningMethod(signatureGenerator, false, hashAlgorithm);
        }

        public static SigningMethod detachedSignature(@Nonnull PGPSignatureGenerator signatureGenerator, @Nonnull HashAlgorithm hashAlgorithm) {
            return new SigningMethod(signatureGenerator, true, hashAlgorithm);
        }

        public boolean isDetached() {
            return this.detached;
        }

        public PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }

        public HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }
    }
}

