/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.KeyFlag;

public class KeyFlagTest {
    @Test
    public void testEmptyBitmaskHasNoFlags() {
        int bitmask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[0]);
        Assertions.assertEquals((int)0, (int)bitmask);
        for (KeyFlag flag : KeyFlag.values()) {
            Assertions.assertFalse((boolean)KeyFlag.hasKeyFlag((int)bitmask, (KeyFlag)flag));
        }
    }

    @Test
    public void testEmptyBitmaskToKeyFlags() {
        int emptyMask = 0;
        List flags = KeyFlag.fromBitmask((int)emptyMask);
        Assertions.assertTrue((boolean)flags.isEmpty());
    }

    @Test
    public void testSingleBitmaskToKeyFlags() {
        for (KeyFlag flag : KeyFlag.values()) {
            int singleMask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{flag});
            List singletonList = KeyFlag.fromBitmask((int)singleMask);
            Assertions.assertEquals((int)1, (int)singletonList.size());
            Assertions.assertEquals((Object)flag, singletonList.get(0));
        }
    }

    @Test
    public void testKeyFlagsToBitmaskToList() {
        int bitMask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        List flags = KeyFlag.fromBitmask((int)bitMask);
        Assertions.assertEquals((int)2, (int)flags.size());
        Assertions.assertTrue((boolean)flags.contains(KeyFlag.ENCRYPT_COMMS));
        Assertions.assertTrue((boolean)flags.contains(KeyFlag.ENCRYPT_STORAGE));
    }

    @Test
    public void testSingleKeyFlagToBitmask() {
        for (KeyFlag flag : KeyFlag.values()) {
            int bitmask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{flag});
            Assertions.assertEquals((int)flag.getFlag(), (int)bitmask);
        }
    }

    @Test
    public void testDuplicateFlagsDoNotChangeMask() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_COMMS});
        Assertions.assertEquals((int)KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE}), (int)mask);
    }

    @Test
    public void testMaskHasNot() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE});
        Assertions.assertFalse((boolean)KeyFlag.hasKeyFlag((int)mask, (KeyFlag)KeyFlag.ENCRYPT_COMMS));
    }

    @Test
    public void testMaskContainsNone() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        Assertions.assertFalse((boolean)KeyFlag.containsAny((int)mask, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}));
    }

    @Test
    public void testContainsAnyContainsAllExact() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS});
        Assertions.assertTrue((boolean)KeyFlag.containsAny((int)mask, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS}));
    }

    @Test
    public void testContainsAnyContainsAll() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.AUTHENTICATION});
        Assertions.assertTrue((boolean)KeyFlag.containsAny((int)mask, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.AUTHENTICATION}));
    }

    @Test
    public void testContainsAnyContainsSome() {
        int mask = KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.AUTHENTICATION});
        Assertions.assertTrue((boolean)KeyFlag.containsAny((int)mask, (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}));
    }
}

