/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.BcHashContextSigner;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class BcHashContextSignerTest {
    private static final String message = "Hello, World!\n";
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 62D5 CBED 8BD0 7D3F D167  240D 4364 E4C1 C4ED 8F59\nComment: Sigfried <sig@fri.ed>\n\nlFgEYlnOkRYJKwYBBAHaRw8BAQdA7Kxn/sPIXo44xnxLBL81G5ghGzMikFc5ib9/\nqgJpZSUAAQCZnJN2l/cfWWh4DijBAwFWoVJOCphKhsJEjKxOzWdqMA2DtBVTaWdm\ncmllZCA8c2lnQGZyaS5lZD6IjwQTFgoAQQUCYlnOkQkQQ2TkwcTtj1kWIQRi1cvt\ni9B9P9FnJA1DZOTBxO2PWQKeAQKbAQUWAgMBAAQLCQgHBRUKCQgLApkBAAAd/gEA\nkiPFDdMGjZV/7Do/3ox46iCH3N1I3BGmA2Jt8PsYwe0BAKe5ahLzCNAXjBQU4iSD\nA4FGipNaG2ZWgAMkdwVjMLEAnF0EYlnOkRIKKwYBBAGXVQEFAQEHQI3n0cWbBh+7\nzeuBjMWevsyxLUCExKSj5fxCh/0GuJgAAwEIBwAA/16V22vjZfAvtnUrVtUZQoYZ\nE8h87Jzj/XxXFy63I6qoER2IdQQYFgoAHQUCYlnOkQKeAQKbDAUWAgMBAAQLCQgH\nBRUKCQgLAAoJEENk5MHE7Y9ZzhsA+gPb2FNutetjrYUSY7BEsk+PPkCXF9W6JZmb\nW/zyRxgpAP9zNzpWrO7kKQ0PwMMd3R1F4Rg6GH+vjXsIbd6jT25UBJxYBGJZzpEW\nCSsGAQQB2kcPAQEHQPOZhITstSj3cPfsTiBEPhtCrc184fkAjl4s+gSB9ttRAAD/\nRVpdc9BhJ/ZXtqQaCBL65h7Uym7i+HExQphHOiuB3iwQOIjVBBgWCgB9BQJiWc6R\nAp4BApsCBRYCAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCYlnOkQAKCRDXXcvYX8Ym\ncrh9AP99WWietGWYs2//FYi0bEAWp6D0HmHP42rvC3qsqyMa8wD8D1Pi2atKwQTP\nJAxQFa06cUIw2POE3llaB0MKQXdTVgQACgkQQ2TkwcTtj1mF+gD+OHo68KeGFUi0\nVcVV/dx/6ES9GAIf1TI6jEsaU8TPBcMBAOHG+5MMVvyNiVKLA0JgJPF3JXOOEU+5\nqiHwlVoGncUM\n=431t\n-----END PGP PRIVATE KEY BLOCK-----";

    @Test
    public void signContextWithEdDSAKeys() throws PGPException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        this.signWithKeys(secretKeys);
    }

    @Test
    public void signContextWithRSAKeys() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleRsaKeyRing((CharSequence)"Sigfried", RsaLength._3072);
        this.signWithKeys(secretKeys);
    }

    @Test
    public void signContextWithEcKeys() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"Sigfried");
        this.signWithKeys(secretKeys);
    }

    private void signWithKeys(PGPSecretKeyRing secretKeys) throws PGPException, NoSuchAlgorithmException, IOException {
        for (HashAlgorithm hashAlgorithm : new HashAlgorithm[]{HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512}) {
            this.signFromContext(secretKeys, hashAlgorithm);
        }
    }

    private void signFromContext(PGPSecretKeyRing secretKeys, HashAlgorithm hashAlgorithm) throws PGPException, NoSuchAlgorithmException, IOException {
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream messageIn = new ByteArrayInputStream(messageBytes);
        PGPSignature signature = this.signMessage(messageBytes, hashAlgorithm, secretKeys);
        Assertions.assertEquals((int)hashAlgorithm.getAlgorithmId(), (int)signature.getHashAlgorithm());
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)messageIn).withOptions(new ConsumerOptions().addVerificationCert(certificate).addVerificationOfDetachedSignature(signature));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        MessageMetadata metadata = decryptionStream.getMetadata();
        Assertions.assertTrue((boolean)metadata.isVerifiedSigned());
    }

    private PGPSignature signMessage(byte[] message, HashAlgorithm hashAlgorithm, PGPSecretKeyRing secretKeys) throws NoSuchAlgorithmException, PGPException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName(), (Provider)new BouncyCastleProvider());
        messageDigest.update(message);
        return BcHashContextSigner.signHashContext((MessageDigest)messageDigest, (SignatureType)SignatureType.BINARY_DOCUMENT, (PGPSecretKeyRing)secretKeys, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
    }
}

