/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import org.bouncycastle.util.encoders.Hex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV5Fingerprint;
import org.pgpainless.key.OpenPgpV6Fingerprint;
import org.pgpainless.key._64DigitFingerprint;

public class _64DigitFingerprintTest {
    @Test
    public void testParse() {
        String prettyPrint = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        OpenPgpFingerprint parsed = OpenPgpFingerprint.parse((String)prettyPrint);
        Assertions.assertTrue((boolean)(parsed instanceof _64DigitFingerprint));
        Assertions.assertEquals((Object)prettyPrint, (Object)parsed.prettyPrint());
        Assertions.assertEquals((int)-1, (int)parsed.getVersion());
    }

    @Test
    public void testParseFromBinary() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        byte[] binary = Hex.decode((String)hex);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.parseFromBinary((byte[])binary);
        Assertions.assertTrue((boolean)(fingerprint instanceof _64DigitFingerprint));
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
        OpenPgpV5Fingerprint v5 = new OpenPgpV5Fingerprint(binary);
        Assertions.assertEquals((Object)fingerprint, (Object)v5);
        OpenPgpV6Fingerprint v6 = new OpenPgpV6Fingerprint(binary);
        Assertions.assertEquals((Object)fingerprint, (Object)v6);
    }

    @Test
    public void testParseFromBinary_leadingZeros() {
        String hex = "000000000000000001AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        byte[] binary = Hex.decode((String)hex);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.parseFromBinary((byte[])binary);
        Assertions.assertTrue((boolean)(fingerprint instanceof _64DigitFingerprint));
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void testParseFromBinary_trailingZeros() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA100000000000000000";
        byte[] binary = Hex.decode((String)hex);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.parseFromBinary((byte[])binary);
        Assertions.assertTrue((boolean)(fingerprint instanceof _64DigitFingerprint));
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void testParseFromBinary_wrongLength() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA012345";
        byte[] binary = Hex.decode((String)hex);
        Assertions.assertThrows(IllegalArgumentException.class, () -> OpenPgpFingerprint.parseFromBinary((byte[])binary));
    }

    @Test
    public void equalsTest() {
        String prettyPrint = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        OpenPgpFingerprint parsed = OpenPgpFingerprint.parse((String)prettyPrint);
        Assertions.assertNotEquals((Object)parsed, null);
        Assertions.assertNotEquals((Object)parsed, (Object)new Object());
        Assertions.assertEquals((Object)parsed, (Object)parsed.toString());
        OpenPgpV5Fingerprint v5 = new OpenPgpV5Fingerprint(prettyPrint);
        Assertions.assertEquals((int)parsed.hashCode(), (int)v5.hashCode());
        Assertions.assertEquals((int)0, (int)parsed.compareTo((Object)v5));
        OpenPgpV6Fingerprint v6 = new OpenPgpV6Fingerprint(prettyPrint);
        Assertions.assertEquals((int)parsed.hashCode(), (int)v6.hashCode());
        Assertions.assertEquals((int)0, (int)parsed.compareTo((Object)v6));
    }
}

