/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.TestAllImplementations;

public class OldSignatureSubpacketsArePreservedOnNewSigTest {
    private static final long millisInHour = 3600000L;

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void verifyOldSignatureSubpacketsArePreservedOnNewExpirationDateSig() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"Alice <alice@wonderland.lit>");
        PGPSignature oldSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getLatestUserIdCertification((CharSequence)"Alice <alice@wonderland.lit>");
        Assertions.assertNotNull((Object)oldSignature);
        PGPSignatureSubpacketVector oldPackets = oldSignature.getHashedSubPackets();
        long oldExpiration = oldPackets.getKeyExpirationTime();
        Date now = new Date();
        Date t1 = new Date(now.getTime() + 3600000L);
        Date expiration = new Date(now.getTime() + 432000000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t1).setExpirationDate(expiration, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        PGPSignature newSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t1).getLatestUserIdCertification((CharSequence)"Alice <alice@wonderland.lit>");
        Assertions.assertNotNull((Object)newSignature);
        PGPSignatureSubpacketVector newPackets = newSignature.getHashedSubPackets();
        Assertions.assertNotEquals((long)oldExpiration, (long)newPackets.getKeyExpirationTime());
        Assertions.assertArrayEquals((int[])oldPackets.getPreferredHashAlgorithms(), (int[])newPackets.getPreferredHashAlgorithms());
    }
}

