/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification.secretkeyring;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.userid.SelectUserId;

public interface SecretKeyRingEditorInterface {
    public SecretKeyRingEditorInterface addUserId(@Nonnull CharSequence var1, @Nonnull SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface addUserId(@Nonnull CharSequence var1, @Nullable SelfSignatureSubpackets.Callback var2, @Nonnull SecretKeyRingProtector var3) throws PGPException;

    public SecretKeyRingEditorInterface addPrimaryUserId(@Nonnull CharSequence var1, @Nonnull SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface removeUserId(SelectUserId var1, SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface removeUserId(CharSequence var1, SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface replaceUserId(CharSequence var1, CharSequence var2, SecretKeyRingProtector var3) throws PGPException;

    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec var1, @Nonnull Passphrase var2, @Nonnull SecretKeyRingProtector var3) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException;

    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec var1, @Nonnull Passphrase var2, @Nullable SelfSignatureSubpackets.Callback var3, @Nonnull SecretKeyRingProtector var4) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException;

    public SecretKeyRingEditorInterface addSubKey(@Nonnull PGPKeyPair var1, @Nullable SelfSignatureSubpackets.Callback var2, @Nonnull SecretKeyRingProtector var3, @Nonnull SecretKeyRingProtector var4, @Nonnull KeyFlag var5, KeyFlag ... var6) throws PGPException, IOException;

    default public SecretKeyRingEditorInterface revoke(@Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revoke(secretKeyRingProtector, (RevocationAttributes)null);
    }

    public SecretKeyRingEditorInterface revoke(@Nonnull SecretKeyRingProtector var1, @Nullable RevocationAttributes var2) throws PGPException;

    public SecretKeyRingEditorInterface revoke(@Nonnull SecretKeyRingProtector var1, @Nullable RevocationSignatureSubpackets.Callback var2) throws PGPException;

    default public SecretKeyRingEditorInterface revokeSubKey(@Nonnull OpenPgpFingerprint fingerprint, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeSubKey(fingerprint, secretKeyRingProtector, null);
    }

    default public SecretKeyRingEditorInterface revokeSubKey(OpenPgpFingerprint fingerprint, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeSubKey(fingerprint.getKeyId(), secretKeyRingProtector, revocationAttributes);
    }

    public SecretKeyRingEditorInterface revokeSubKey(long var1, SecretKeyRingProtector var3, RevocationAttributes var4) throws PGPException;

    default public SecretKeyRingEditorInterface revokeSubKey(long subKeyId, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeSubKey(subKeyId, secretKeyRingProtector, (RevocationSignatureSubpackets.Callback)null);
    }

    public SecretKeyRingEditorInterface revokeSubKey(long var1, @Nonnull SecretKeyRingProtector var3, @Nullable RevocationSignatureSubpackets.Callback var4) throws PGPException;

    default public SecretKeyRingEditorInterface revokeUserId(@Nonnull CharSequence userId, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeUserId(userId, secretKeyRingProtector, (RevocationAttributes)null);
    }

    public SecretKeyRingEditorInterface revokeUserId(@Nonnull CharSequence var1, @Nonnull SecretKeyRingProtector var2, @Nullable RevocationAttributes var3) throws PGPException;

    public SecretKeyRingEditorInterface revokeUserId(@Nonnull CharSequence var1, @Nonnull SecretKeyRingProtector var2, @Nullable RevocationSignatureSubpackets.Callback var3) throws PGPException;

    public SecretKeyRingEditorInterface revokeUserIds(@Nonnull SelectUserId var1, @Nonnull SecretKeyRingProtector var2, @Nullable RevocationAttributes var3) throws PGPException;

    public SecretKeyRingEditorInterface revokeUserIds(@Nonnull SelectUserId var1, @Nonnull SecretKeyRingProtector var2, @Nullable RevocationSignatureSubpackets.Callback var3) throws PGPException;

    public SecretKeyRingEditorInterface setExpirationDate(@Nullable Date var1, @Nonnull SecretKeyRingProtector var2) throws PGPException;

    public PGPPublicKeyRing createMinimalRevocationCertificate(@Nonnull SecretKeyRingProtector var1, @Nullable RevocationAttributes var2) throws PGPException;

    public PGPSignature createRevocation(@Nonnull SecretKeyRingProtector var1, @Nullable RevocationAttributes var2) throws PGPException;

    public PGPSignature createRevocation(long var1, @Nonnull SecretKeyRingProtector var3, @Nullable RevocationAttributes var4) throws PGPException;

    public PGPSignature createRevocation(long var1, @Nonnull SecretKeyRingProtector var3, @Nullable RevocationSignatureSubpackets.Callback var4) throws PGPException;

    default public PGPSignature createRevocation(OpenPgpFingerprint subkeyFingerprint, SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        return this.createRevocation(subkeyFingerprint.getKeyId(), secretKeyRingProtector, revocationAttributes);
    }

    default public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase) {
        return this.changePassphraseFromOldPassphrase(oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase var1, @Nonnull KeyRingProtectionSettings var2);

    default public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase) {
        return this.changeSubKeyPassphraseFromOldPassphrase(keyId, oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long var1, @Nullable Passphrase var2, @Nonnull KeyRingProtectionSettings var3);

    public PGPSecretKeyRing done();

    public static interface WithPassphrase {
        public SecretKeyRingEditorInterface toNewPassphrase(Passphrase var1) throws PGPException;

        public SecretKeyRingEditorInterface toNoPassphrase() throws PGPException;
    }

    public static interface WithKeyRingEncryptionSettings {
        public WithPassphrase withSecureDefaultSettings();

        public WithPassphrase withCustomSettings(KeyRingProtectionSettings var1);
    }
}

