/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;

public class RespectPreferredSymmetricAlgorithmDuringEncryptionTest {
    @Test
    public void algorithmPreferencesAreRespectedDependingOnEncryptionTarget() throws IOException, PGPException {
        String key = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: 7E13 2E9C EAE8 7E7B AD6C  5329 94CE B847 EEFB 044B\nComment: Bob Babbage <bob@openpgp.example>\n\nmDMEYeIhnhYJKwYBBAHaRw8BAQdAfs9SkOSEyAQmvwLwwUPCp3Qiw2t4rm+e7n8t\noVjAmle0IUJvYiBCYWJiYWdlIDxib2JAb3BlbnBncC5leGFtcGxlPoiPBBMWCgBB\nBQJh4iGeCZCUzrhH7vsESxahBH4TLpzq6H57rWxTKZTOuEfu+wRLAp4BApsBBZYC\nAwEABIsJCAcFlQoJCAsCmQEAAKK/AP4lCifuXpZIUR4PrenGBZFtoZpB5s1i/YrB\ncnCuodQX9wEAyENhlXNYopWdgBZ9g4E1Y0cJfpwCwWhx0DeATmrSzAO0H0JvYmJ5\nMTI4IDxib2JieUBhZXMxMjguZXhhbXBsZT6IigQTFgoAPAUCYeIhngmQlM64R+77\nBEsWoQR+Ey6c6uh+e61sUymUzrhH7vsESwKeAQKbAQWWAgMBAAKLBwWVCgkICwAA\ny0wBAIhAEpQgJRizHitPx3WUpIYbKq3R5jAO34NnlmTzNVj6AP9aWHPsW5r7HuQh\nxJz+8zdCOuAxKv6tvHthSWJ64VWDDrg4BGHiIZ4SCisGAQQBl1UBBQEBB0CEIv13\n/qTXR0wiUG5DVZCWh/KLKrF5TemUfYXA/kBTOAMBCAeIdQQYFgoAHQUCYeIhngKe\nAQKbDAWWAgMBAASLCQgHBZUKCQgLAAoJEJTOuEfu+wRLwC4A/0/VDPPDE6kT/8C3\n9d8ekZkQE38o2nC58E62AjM5O2x6AQDMd0gcoKIxPi9uRi3nVsNS233a3MxFEjpe\nqqgyBnqxBLgzBGHiIZ4WCSsGAQQB2kcPAQEHQP7IGdT9moutwtys4A/ndkWJVWn/\nzkoOn3cSad1bP8y8iNUEGBYKAH0FAmHiIZ4CngECmwIFlgIDAQAEiwkIBwWVCgkI\nC18gBBkWCgAGBQJh4iGeAAoJENcuZc0+RPVgrucBAI+IzpplBIpySOIyzHJdjeFt\nikwTBOY3OTriY2Z62Ec6AQDhVxO7LZuH3mTCklj4HelfMrhlqUlnYr7qCIjzI5BY\nBwAKCRCUzrhH7vsES4snAP4qzlEbaHpN7ZPomCOHD7J2+CHlyTtsRP45XWVCqNH1\njAEAmzz5Lu67k97AzArpoGHgYh492w5BfdApV8BCaTW4AgI=\n=XwJQ\n-----END PGP PUBLIC KEY BLOCK-----\n";
        PGPPublicKeyRing publicKeys = PGPainless.readKeyRing().publicKeyRing(key);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(publicKeys)));
        encryptionStream.close();
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)encryptionStream.getResult().getEncryptionAlgorithm());
        out = new ByteArrayOutputStream();
        encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(publicKeys, (CharSequence)"Bob Babbage <bob@openpgp.example>")));
        encryptionStream.close();
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)encryptionStream.getResult().getEncryptionAlgorithm());
        out = new ByteArrayOutputStream();
        encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(publicKeys, (CharSequence)"Bobby128 <bobby@aes128.example>")));
        encryptionStream.close();
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_128, (Object)encryptionStream.getResult().getEncryptionAlgorithm());
    }
}

