/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.Comparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.UserId;

public class UserIdTest {
    @Test
    public void testFormatOnlyName() {
        Assertions.assertEquals((Object)"Juliet Capulet", (Object)UserId.newBuilder().withName("Juliet Capulet").build().toString());
    }

    @Test
    public void testFormatNameAndComment() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play)", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").noEmail().build().toString());
    }

    @Test
    public void testFormatNameCommentAndMail() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play) <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void testFormatNameAndEmail() {
        Assertions.assertEquals((Object)"Juliet Capulet <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").noComment().withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void testNameAndEmail() {
        UserId userId = UserId.nameAndEmail((String)"Maurice Moss", (String)"moss.m@reynholm.co.uk");
        Assertions.assertEquals((Object)"Maurice Moss <moss.m@reynholm.co.uk>", (Object)userId.toString());
    }

    @Test
    void testBuilderWithName() {
        UserId userId = UserId.newBuilder().withName("John Smith").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithComment() {
        UserId userId = UserId.newBuilder().withComment("Sales Dept.").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithEmail() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderWithAll() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withEmail("john.smith@example.com").withComment("Sales Dept.").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoName() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noName().build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoComment() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noComment().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoEmail() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noEmail().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testEmailOnlyFormatting() {
        UserId userId = UserId.onlyEmail((String)"john.smith@example.com");
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEmptyNameAndValidEmailFormatting() {
        UserId userId = UserId.nameAndEmail((String)"", (String)"john.smith@example.com");
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEmptyNameAndEmptyCommentAndValidEmailFormatting() {
        UserId userId = UserId.newBuilder().withComment("").withName("").withEmail("john.smith@example.com").build();
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEqualsWithDifferentCaseEmails() {
        String name = "John Smith";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        String upperEmail = "john.smith@example.com".toUpperCase();
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail(upperEmail).build();
        Assertions.assertEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentNames() {
        String name1 = "John Smith";
        String name2 = "Don Duck";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("Don Duck").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentComments() {
        String name = "John Smith";
        String comment1 = "Sales Dept.";
        String comment2 = "Legal Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Legal Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }

    @Test
    public void testLength() {
        UserId id = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        Assertions.assertEquals((int)28, (int)id.length());
    }

    @Test
    public void testSubSequence() {
        UserId id = UserId.onlyEmail((String)"alice@pgpainless.org");
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.subSequence(1, id.length() - 1));
    }

    @Test
    public void asStringTest() {
        UserId id = UserId.newBuilder().withName("Alice").withComment("Work Email").withEmail("alice@pgpainless.org").build();
        Assertions.assertEquals((Object)id.toString(), (Object)id.asString());
    }

    @Test
    public void charAtTest() {
        UserId id = UserId.onlyEmail((String)"alice@pgpainless.org");
        Assertions.assertEquals((char)'<', (char)id.charAt(0));
        Assertions.assertEquals((char)'>', (char)id.charAt(id.length() - 1));
    }

    @Test
    public void defaultCompareTest() {
        UserId id1 = UserId.onlyEmail((String)"alice@pgpainless.org");
        UserId id2 = UserId.onlyEmail((String)"alice@gnupg.org");
        UserId id3 = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id3_ = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id4 = UserId.newBuilder().withName("Alice").build();
        UserId id5 = UserId.newBuilder().withName("Alice").withComment("Work Mail").withEmail("alice@pgpainless.org").build();
        Assertions.assertEquals((int)id3.hashCode(), (int)id3_.hashCode());
        Assertions.assertNotEquals((int)id2.hashCode(), (int)id3.hashCode());
        UserId.DefaultComparator c = new UserId.DefaultComparator();
        Assertions.assertEquals((int)0, (int)UserId.compare(null, null, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, null, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare(null, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id2, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id3, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id3, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id5, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id5, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id3_, (Comparator)c));
    }

    @Test
    public void defaultIgnoreCaseCompareTest() {
        UserId id1 = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id2 = UserId.nameAndEmail((String)"alice", (String)"alice@pgpainless.org");
        UserId id3 = UserId.nameAndEmail((String)"Alice", (String)"Alice@Pgpainless.Org");
        UserId id4 = UserId.newBuilder().withName("Alice").withComment("Work Email").withEmail("Alice@Pgpainless.Org").build();
        UserId id5 = UserId.newBuilder().withName("alice").withComment("work email").withEmail("alice@pgpainless.org").build();
        UserId id6 = UserId.nameAndEmail((String)"Bob", (String)"bob@pgpainless.org");
        UserId.DefaultIgnoreCaseComparator c = new UserId.DefaultIgnoreCaseComparator();
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id2, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare(null, null, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id1, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id4, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id5, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare(null, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, null, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id6, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id6, (UserId)id1, (Comparator)c));
    }

    @Test
    public void parseNameAndEmail() {
        UserId id = UserId.parse((String)"Alice <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice", (Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Alice <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseNameCommentAndEmail() {
        UserId id = UserId.parse((String)"Alice (work mail) <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice", (Object)id.getName());
        Assertions.assertEquals((Object)"work mail", (Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Alice (work mail) <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseLongNameAndEmail() {
        UserId id = UserId.parse((String)"Alice von Painleicester <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice von Painleicester", (Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Alice von Painleicester <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseLongNameCommentAndEmail() {
        UserId id = UserId.parse((String)"Alice von Painleicester (work email) <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice von Painleicester", (Object)id.getName());
        Assertions.assertEquals((Object)"work email", (Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Alice von Painleicester (work email) <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseQuotedNameAndEmail() {
        UserId id = UserId.parse((String)"\"Alice\" <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice", (Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"\"Alice\" <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseQuotedNameCommentAndEmail() {
        UserId id = UserId.parse((String)"\"Alice\" (work email) <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice", (Object)id.getName());
        Assertions.assertEquals((Object)"work email", (Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"\"Alice\" (work email) <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseLongQuotedNameAndEmail() {
        UserId id = UserId.parse((String)"\"Alice Mac Painlester\" <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice Mac Painlester", (Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"\"Alice Mac Painlester\" <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseLongQuotedNameCommentAndEmail() {
        UserId id = UserId.parse((String)"\"Alice Mac Painlester\" (work email) <alice@pgpainless.org>");
        Assertions.assertEquals((Object)"Alice Mac Painlester", (Object)id.getName());
        Assertions.assertEquals((Object)"work email", (Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"\"Alice Mac Painlester\" (work email) <alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseEmailOnly() {
        UserId id = UserId.parse((String)"alice@pgpainless.org");
        Assertions.assertNull((Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"<alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseBracketedEmailOnly() {
        UserId id = UserId.parse((String)"<alice@pgpainless.org>");
        Assertions.assertNull((Object)id.getName());
        Assertions.assertNull((Object)id.getComment());
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"<alice@pgpainless.org>", (Object)id.toString());
    }

    @Test
    public void parseLatinWithDiacritics() {
        UserId pele = UserId.parse((String)"Pel\u00e9@example.com");
        Assertions.assertEquals((Object)"Pel\u00e9@example.com", (Object)pele.getEmail());
        pele = UserId.parse((String)"Marquez Pel\u00e9 <Pel\u00e9@example.com>");
        Assertions.assertEquals((Object)"Pel\u00e9@example.com", (Object)pele.getEmail());
        Assertions.assertEquals((Object)"Marquez Pel\u00e9", (Object)pele.getName());
    }

    @Test
    public void parseGreekAlphabet() {
        UserId dokimi = UserId.parse((String)"\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae@\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae");
        Assertions.assertEquals((Object)"\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae@\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", (Object)dokimi.getEmail());
        dokimi = UserId.parse((String)"\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae <\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae@\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae>");
        Assertions.assertEquals((Object)"\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", (Object)dokimi.getName());
        Assertions.assertEquals((Object)"\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae@\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", (Object)dokimi.getEmail());
    }

    @Test
    public void parseTraditionalChinese() {
        UserId womai = UserId.parse((String)"\u6211\u8cb7@\u5c4b\u4f01.\u9999\u6e2f");
        Assertions.assertEquals((Object)"\u6211\u8cb7@\u5c4b\u4f01.\u9999\u6e2f", (Object)womai.getEmail());
        womai = UserId.parse((String)"\u6211\u8cb7 <\u6211\u8cb7@\u5c4b\u4f01.\u9999\u6e2f>");
        Assertions.assertEquals((Object)"\u6211\u8cb7@\u5c4b\u4f01.\u9999\u6e2f", (Object)womai.getEmail());
        Assertions.assertEquals((Object)"\u6211\u8cb7", (Object)womai.getName());
    }

    @Test
    public void parseJapanese() {
        UserId ninomiya = UserId.parse((String)"\u4e8c\u30ce\u5bae@\u9ed2\u5ddd.\u65e5\u672c");
        Assertions.assertEquals((Object)"\u4e8c\u30ce\u5bae@\u9ed2\u5ddd.\u65e5\u672c", (Object)ninomiya.getEmail());
        ninomiya = UserId.parse((String)"\u4e8c\u30ce\u5bae <\u4e8c\u30ce\u5bae@\u9ed2\u5ddd.\u65e5\u672c>");
        Assertions.assertEquals((Object)"\u4e8c\u30ce\u5bae@\u9ed2\u5ddd.\u65e5\u672c", (Object)ninomiya.getEmail());
        Assertions.assertEquals((Object)"\u4e8c\u30ce\u5bae", (Object)ninomiya.getName());
    }

    @Test
    public void parseCyrillic() {
        UserId medved = UserId.parse((String)"\u043c\u0435\u0434\u0432\u0435\u0434\u044c@\u0441-\u0431\u0430\u043b\u0430\u043b\u0430\u0439\u043a\u043e\u0439.\u0440\u0444");
        Assertions.assertEquals((Object)"\u043c\u0435\u0434\u0432\u0435\u0434\u044c@\u0441-\u0431\u0430\u043b\u0430\u043b\u0430\u0439\u043a\u043e\u0439.\u0440\u0444", (Object)medved.getEmail());
        medved = UserId.parse((String)"\u043c\u0435\u0434\u0432\u0435\u0434\u044c <\u043c\u0435\u0434\u0432\u0435\u0434\u044c@\u0441-\u0431\u0430\u043b\u0430\u043b\u0430\u0439\u043a\u043e\u0439.\u0440\u0444>");
        Assertions.assertEquals((Object)"\u043c\u0435\u0434\u0432\u0435\u0434\u044c@\u0441-\u0431\u0430\u043b\u0430\u043b\u0430\u0439\u043a\u043e\u0439.\u0440\u0444", (Object)medved.getEmail());
        Assertions.assertEquals((Object)"\u043c\u0435\u0434\u0432\u0435\u0434\u044c", (Object)medved.getName());
    }

    @Test
    public void parseDevanagari() {
        UserId samparka = UserId.parse((String)"\u0938\u0902\u092a\u0930\u094d\u0915@\u0921\u093e\u091f\u093e\u092e\u0947\u0932.\u092d\u093e\u0930\u0924");
        Assertions.assertEquals((Object)"\u0938\u0902\u092a\u0930\u094d\u0915@\u0921\u093e\u091f\u093e\u092e\u0947\u0932.\u092d\u093e\u0930\u0924", (Object)samparka.getEmail());
        samparka = UserId.parse((String)"\u0938\u0902\u092a\u0930\u094d\u0915 <\u0938\u0902\u092a\u0930\u094d\u0915@\u0921\u093e\u091f\u093e\u092e\u0947\u0932.\u092d\u093e\u0930\u0924>");
        Assertions.assertEquals((Object)"\u0938\u0902\u092a\u0930\u094d\u0915@\u0921\u093e\u091f\u093e\u092e\u0947\u0932.\u092d\u093e\u0930\u0924", (Object)samparka.getEmail());
        Assertions.assertEquals((Object)"\u0938\u0902\u092a\u0930\u094d\u0915", (Object)samparka.getName());
    }

    @Test
    public void parseMailWithPlus() {
        UserId id = UserId.parse((String)"disposable.style.email.with+symbol@example.com");
        Assertions.assertEquals((Object)"disposable.style.email.with+symbol@example.com", (Object)id.getEmail());
        id = UserId.parse((String)"Disposable Mail <disposable.style.email.with+symbol@example.com>");
        Assertions.assertEquals((Object)"disposable.style.email.with+symbol@example.com", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Disposable Mail", (Object)id.getName());
    }

    @Test
    public void parseMailWithHyphen() {
        UserId id = UserId.parse((String)"other.email-with-hyphen@example.com");
        Assertions.assertEquals((Object)"other.email-with-hyphen@example.com", (Object)id.getEmail());
        id = UserId.parse((String)"Other Email <other.email-with-hyphen@example.com>");
        Assertions.assertEquals((Object)"other.email-with-hyphen@example.com", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Other Email", (Object)id.getName());
    }

    @Test
    public void parseMailWithTagAndSorting() {
        UserId id = UserId.parse((String)"user.name+tag+sorting@example.com");
        Assertions.assertEquals((Object)"user.name+tag+sorting@example.com", (Object)id.getEmail());
        id = UserId.parse((String)"User Name <user.name+tag+sorting@example.com>");
        Assertions.assertEquals((Object)"user.name+tag+sorting@example.com", (Object)id.getEmail());
        Assertions.assertEquals((Object)"User Name", (Object)id.getName());
    }

    @Test
    public void parseMailWithSlash() {
        UserId id = UserId.parse((String)"test/test@test.com");
        Assertions.assertEquals((Object)"test/test@test.com", (Object)id.getEmail());
        id = UserId.parse((String)"Who uses Slashes <test/test@test.com>");
        Assertions.assertEquals((Object)"test/test@test.com", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Who uses Slashes", (Object)id.getName());
    }

    @Test
    public void parseDoubleDots() {
        UserId id = UserId.parse((String)"\"john..doe\"@example.org");
        Assertions.assertEquals((Object)"\"john..doe\"@example.org", (Object)id.getEmail());
        id = UserId.parse((String)"John Doe <\"john..doe\"@example.org>");
        Assertions.assertEquals((Object)"\"john..doe\"@example.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"John Doe", (Object)id.getName());
    }

    @Test
    public void parseBangifiedHostRoute() {
        UserId id = UserId.parse((String)"mailhost!username@example.org");
        Assertions.assertEquals((Object)"mailhost!username@example.org", (Object)id.getEmail());
        id = UserId.parse((String)"Bangified Host Route <mailhost!username@example.org>");
        Assertions.assertEquals((Object)"mailhost!username@example.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Bangified Host Route", (Object)id.getName());
    }

    @Test
    public void parsePercentRouted() {
        UserId id = UserId.parse((String)"user%example.com@example.org");
        Assertions.assertEquals((Object)"user%example.com@example.org", (Object)id.getEmail());
        id = UserId.parse((String)"User <user%example.com@example.org>");
        Assertions.assertEquals((Object)"user%example.com@example.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"User", (Object)id.getName());
    }

    @Test
    public void parseLocalPartEndingWithNonAlphanumericCharacter() {
        UserId id = UserId.parse((String)"user-@example.org");
        Assertions.assertEquals((Object)"user-@example.org", (Object)id.getEmail());
        id = UserId.parse((String)"User <user-@example.org>");
        Assertions.assertEquals((Object)"user-@example.org", (Object)id.getEmail());
        Assertions.assertEquals((Object)"User", (Object)id.getName());
    }

    @Test
    public void parseDomainIsIpAddress() {
        UserId id = UserId.parse((String)"postmaster@[123.123.123.123]");
        Assertions.assertEquals((Object)"postmaster@[123.123.123.123]", (Object)id.getEmail());
        id = UserId.parse((String)"Alice (work email) <postmaster@[123.123.123.123]>");
        Assertions.assertEquals((Object)"postmaster@[123.123.123.123]", (Object)id.getEmail());
        Assertions.assertEquals((Object)"Alice", (Object)id.getName());
        Assertions.assertEquals((Object)"work email", (Object)id.getComment());
    }
}

