/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class ChangeSecretKeyRingPassphraseTest {
    private final PGPSecretKeyRing keyRing = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"password@encryp.ted", "weakPassphrase");

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void changePassphraseOfWholeKeyRingTest() throws PGPException {
        PGPSecretKeyRing secretKeys;
        PGPSecretKeyRing changedPassphraseKeyRing = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changePassphraseFromOldPassphrase(Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"1337p455phr453")).done();
        Assertions.assertEquals((int)KeyRingProtectionSettings.secureDefaultSettings().getEncryptionAlgorithm().getAlgorithmId(), (int)changedPassphraseKeyRing.getSecretKey().getKeyEncryptionAlgorithm());
        Assertions.assertThrows(PGPException.class, () -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.emptyPassphrase()), (String)"Unlocking secret key ring with empty passphrase MUST fail.");
        Assertions.assertThrows(PGPException.class, () -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking secret key ring with old passphrase MUST fail.");
        Assertions.assertDoesNotThrow(() -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.fromPassword((String)"1337p455phr453")), (String)"Unlocking the secret key ring with the new passphrase MUST succeed.");
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void changePassphraseOfWholeKeyRingToEmptyPassphrase() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys;
        PGPSecretKeyRing changedPassphraseKeyRing = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changePassphraseFromOldPassphrase(Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNoPassphrase().done();
        Assertions.assertEquals((int)SymmetricKeyAlgorithm.NULL.getAlgorithmId(), (int)changedPassphraseKeyRing.getSecretKey().getKeyEncryptionAlgorithm());
        this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.emptyPassphrase());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void changePassphraseOfSingleSubkeyToNewPassphrase() throws PGPException {
        Iterator keys = this.keyRing.getSecretKeys();
        PGPSecretKey primaryKey = (PGPSecretKey)keys.next();
        PGPSecretKey subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.fromPassword((String)"weakPassphrase"));
        this.extractPrivateKey(subKey, Passphrase.fromPassword((String)"weakPassphrase"));
        PGPSecretKeyRing secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changeSubKeyPassphraseFromOldPassphrase(Long.valueOf(subKey.getPublicKey().getKeyID()), Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"subKeyPassphrase")).done();
        keys = secretKeys.getSecretKeys();
        primaryKey = (PGPSecretKey)keys.next();
        subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.fromPassword((String)"weakPassphrase"));
        this.extractPrivateKey(subKey, Passphrase.fromPassword((String)"subKeyPassphrase"));
        PGPSecretKey finalPrimaryKey = primaryKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalPrimaryKey, Passphrase.fromPassword((String)"subKeyPassphrase")), (String)"Unlocking the primary key with the subkey passphrase must fail.");
        PGPSecretKey finalSubKey = subKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalSubKey, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking the subkey with the primary key passphrase must fail.");
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void changePassphraseOfSingleSubkeyToEmptyPassphrase() throws PGPException {
        Iterator keys = this.keyRing.getSecretKeys();
        PGPSecretKey primaryKey = (PGPSecretKey)keys.next();
        PGPSecretKey subKey = (PGPSecretKey)keys.next();
        PGPSecretKeyRing secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changeSubKeyPassphraseFromOldPassphrase(Long.valueOf(subKey.getKeyID()), Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNoPassphrase().done();
        keys = secretKeys.getSecretKeys();
        primaryKey = (PGPSecretKey)keys.next();
        subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.fromPassword((String)"weakPassphrase"));
        this.extractPrivateKey(subKey, Passphrase.emptyPassphrase());
        PGPSecretKey finalPrimaryKey = primaryKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalPrimaryKey, Passphrase.emptyPassphrase()), (String)"Unlocking the unprotected primary key with the old passphrase must fail.");
        PGPSecretKey finalSubKey = subKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalSubKey, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking the still protected subkey with an empty passphrase must fail.");
    }

    private void extractPrivateKey(PGPSecretKey secretKey, Passphrase passphrase) throws PGPException {
        if (passphrase.isEmpty() && secretKey.getKeyEncryptionAlgorithm() != SymmetricKeyAlgorithm.NULL.getAlgorithmId()) {
            throw new PGPException("Cannot unlock encrypted private key with empty passphrase.");
        }
        if (!passphrase.isEmpty() && secretKey.getKeyEncryptionAlgorithm() == SymmetricKeyAlgorithm.NULL.getAlgorithmId()) {
            throw new PGPException("Cannot unlock unprotected private key with non-empty passphrase.");
        }
        PBESecretKeyDecryptor decryptor = passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(passphrase);
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (PBESecretKeyDecryptor)decryptor);
    }

    private void signDummyMessageWithKeysAndPassphrase(PGPSecretKeyRing keyRing, Passphrase passphrase) throws IOException, PGPException {
        String dummyMessage = "dummy";
        ByteArrayOutputStream dummy = new ByteArrayOutputStream();
        EncryptionStream stream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dummy).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addInlineSignature((SecretKeyRingProtector)PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)keyRing, (Passphrase)passphrase), keyRing, DocumentSignatureType.BINARY_DOCUMENT)));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(dummyMessage.getBytes()), (OutputStream)stream);
        stream.close();
    }
}

