/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.util.CollectionUtils;

public class RevocationCertificateTest {
    @Test
    public void createRevocationCertificateTest() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPSignature revocation = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createRevocation(SecretKeyRingProtector.unprotectedKeys(), RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withoutDescription());
        Assertions.assertNotNull((Object)revocation);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).isKeyValidlyBound(secretKeys.getPublicKey().getKeyID()));
        PGPSecretKeyRing revokedKey = KeyRingUtils.keysPlusSecretKey((PGPSecretKeyRing)secretKeys, (PGPSecretKey)KeyRingUtils.secretKeyPlusSignature((PGPSecretKey)secretKeys.getSecretKey(), (PGPSignature)revocation));
        Assertions.assertFalse((boolean)PGPainless.inspectKeyRing((PGPKeyRing)revokedKey).isKeyValidlyBound(secretKeys.getPublicKey().getKeyID()));
    }

    @Test
    public void createMinimalRevocationCertificateTest() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPublicKeyRing minimalRevocationCert = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createMinimalRevocationCertificate(SecretKeyRingProtector.unprotectedKeys(), RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withoutDescription());
        Assertions.assertEquals((int)1, (int)minimalRevocationCert.size());
        PGPPublicKey key = minimalRevocationCert.getPublicKey();
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)key.getKeyID());
        Assertions.assertEquals((int)1, (int)CollectionUtils.iteratorToList((Iterator)key.getSignatures()).size());
        Assertions.assertFalse((boolean)key.getUserIDs().hasNext());
        Assertions.assertFalse((boolean)key.getUserAttributes().hasNext());
        Assertions.assertNull((Object)key.getTrustData());
        PGPPublicKeyRing originalCert = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        PGPPublicKeyRing mergedCert = PGPainless.mergeCertificate((PGPPublicKeyRing)originalCert, (PGPPublicKeyRing)minimalRevocationCert);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)mergedCert).getRevocationState().isSoftRevocation());
    }

    @Test
    public void createMinimalRevocationCertificateForFreshKeyTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@example.org>");
        PGPPublicKeyRing minimalRevocationCert = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createMinimalRevocationCertificate(SecretKeyRingProtector.unprotectedKeys(), RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withoutDescription());
        Assertions.assertEquals((int)1, (int)minimalRevocationCert.size());
        PGPPublicKey key = minimalRevocationCert.getPublicKey();
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)key.getKeyID());
        Assertions.assertEquals((int)1, (int)CollectionUtils.iteratorToList((Iterator)key.getSignatures()).size());
        Assertions.assertFalse((boolean)key.getUserIDs().hasNext());
        Assertions.assertFalse((boolean)key.getUserAttributes().hasNext());
        Assertions.assertNull((Object)key.getTrustData());
        PGPPublicKeyRing originalCert = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        PGPPublicKeyRing mergedCert = PGPainless.mergeCertificate((PGPPublicKeyRing)originalCert, (PGPPublicKeyRing)minimalRevocationCert);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)mergedCert).getRevocationState().isSoftRevocation());
    }

    @Test
    public void createMinimalRevocationCertificate_wrongReason() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createMinimalRevocationCertificate(SecretKeyRingProtector.unprotectedKeys(), RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID).withoutDescription()));
    }
}

