/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.ArmoredInputStreamFactory;
import org.pgpainless.util.CRCingArmoredInputStreamWrapper;

public class ArmoredInputStreamFactoryTest {
    String armored = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nowE7LZzEAAIeqTk5+Qrh+UU5KYpcAA==\n=g3nV\n-----END PGP MESSAGE-----";

    @Test
    public void testGet() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.armored.getBytes());
        ArmoredInputStream armorIn = ArmoredInputStreamFactory.get((InputStream)inputStream);
        Assertions.assertNotNull((Object)armorIn);
    }

    @Test
    public void testGet_willWrapArmoredInputStreamWithCRC() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.armored.getBytes());
        ArmoredInputStream plainArmor = new ArmoredInputStream((InputStream)inputStream);
        ArmoredInputStream armor = ArmoredInputStreamFactory.get((InputStream)plainArmor);
        Assertions.assertTrue((boolean)(armor instanceof CRCingArmoredInputStreamWrapper));
    }

    @Test
    public void testGet_onCRCinArmoredInputStream() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.armored.getBytes());
        CRCingArmoredInputStreamWrapper crc = new CRCingArmoredInputStreamWrapper(new ArmoredInputStream((InputStream)inputStream));
        ArmoredInputStream armor = ArmoredInputStreamFactory.get((InputStream)crc);
        Assertions.assertSame((Object)crc, (Object)armor);
    }
}

