/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

public class CertificateAuthenticity {
    private final String userId;
    private final PGPPublicKeyRing certificate;
    private final Map<CertificationChain, Integer> certificationChains = new HashMap<CertificationChain, Integer>();
    private final int targetAmount;

    public CertificateAuthenticity(@Nonnull PGPPublicKeyRing certificate, @Nonnull String userId, @Nonnull Map<CertificationChain, Integer> certificationChains, int targetAmount) {
        this.userId = userId;
        this.certificate = certificate;
        this.certificationChains.putAll(certificationChains);
        this.targetAmount = targetAmount;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    @Nonnull
    public PGPPublicKeyRing getCertificate() {
        return this.certificate;
    }

    public int getTotalTrustAmount() {
        int total = 0;
        for (int v : this.certificationChains.values()) {
            total += v;
        }
        return total;
    }

    public int getAuthenticityPercentage() {
        return this.targetAmount * 100 / this.getTotalTrustAmount();
    }

    public boolean isAuthenticated() {
        return this.targetAmount <= this.getTotalTrustAmount();
    }

    @Nonnull
    public Map<CertificationChain, Integer> getCertificationChains() {
        return Collections.unmodifiableMap(this.certificationChains);
    }

    public static class ChainLink {
        private final PGPPublicKeyRing certificate;

        public ChainLink(@Nonnull PGPPublicKeyRing certificate) {
            this.certificate = certificate;
        }

        @Nonnull
        public PGPPublicKeyRing getCertificate() {
            return this.certificate;
        }
    }

    public static class CertificationChain {
        private final int trustAmount;
        private final List<ChainLink> chainLinks = new ArrayList<ChainLink>();

        public CertificationChain(int trustAmount, @Nonnull List<ChainLink> chainLinks) {
            this.trustAmount = trustAmount;
            this.chainLinks.addAll(chainLinks);
        }

        public int getTrustAmount() {
            return this.trustAmount;
        }

        @Nonnull
        public List<ChainLink> getChainLinks() {
            return Collections.unmodifiableList(this.chainLinks);
        }
    }
}

