/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.SessionKey;

public class MessageMetadata {
    protected Message message;

    public MessageMetadata(@Nonnull Message message) {
        this.message = message;
    }

    @Nonnull
    public OpenPgpMetadata toLegacyMetadata() {
        OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
        resultBuilder.setCompressionAlgorithm(this.getCompressionAlgorithm());
        resultBuilder.setModificationDate(this.getModificationDate());
        resultBuilder.setFileName(this.getFilename());
        resultBuilder.setFileEncoding(this.getLiteralDataEncoding());
        resultBuilder.setSessionKey(this.getSessionKey());
        resultBuilder.setDecryptionKey(this.getDecryptionKey());
        for (SignatureVerification accepted : this.getVerifiedDetachedSignatures()) {
            resultBuilder.addVerifiedDetachedSignature(accepted);
        }
        for (SignatureVerification.Failure rejected : this.getRejectedDetachedSignatures()) {
            resultBuilder.addInvalidDetachedSignature(rejected.getSignatureVerification(), rejected.getValidationException());
        }
        for (SignatureVerification accepted : this.getVerifiedInlineSignatures()) {
            resultBuilder.addVerifiedInbandSignature(accepted);
        }
        for (SignatureVerification.Failure rejected : this.getRejectedInlineSignatures()) {
            resultBuilder.addInvalidInbandSignature(rejected.getSignatureVerification(), rejected.getValidationException());
        }
        if (this.message.isCleartextSigned()) {
            resultBuilder.setCleartextSigned();
        }
        return resultBuilder.build();
    }

    public boolean isUsingCleartextSignatureFramework() {
        return this.message.isCleartextSigned();
    }

    public boolean isEncrypted() {
        SymmetricKeyAlgorithm algorithm = this.getEncryptionAlgorithm();
        return algorithm != null && algorithm != SymmetricKeyAlgorithm.NULL;
    }

    public boolean isEncryptedFor(@Nonnull PGPKeyRing keys) {
        Iterator<EncryptedData> encryptionLayers = this.getEncryptionLayers();
        while (encryptionLayers.hasNext()) {
            EncryptedData encryptedData = encryptionLayers.next();
            for (long recipient : encryptedData.getRecipients()) {
                PGPPublicKey key = keys.getPublicKey(recipient);
                if (key == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAuthenticatablySignedBy(String userId, boolean email, CertificateAuthority certificateAuthority) {
        return this.isAuthenticatablySignedBy(userId, email, certificateAuthority, 120);
    }

    public boolean isAuthenticatablySignedBy(String userId, boolean email, CertificateAuthority certificateAuthority, int targetAmount) {
        for (SignatureVerification verification : this.getVerifiedSignatures()) {
            CertificateAuthenticity authenticity = certificateAuthority.authenticateBinding(verification.getSigningKey().getFingerprint(), userId, email, verification.getSignature().getCreationTime(), targetAmount);
            if (!authenticity.isAuthenticated()) continue;
            return true;
        }
        return false;
    }

    public List<Long> getRecipientKeyIds() {
        ArrayList<Long> keyIds = new ArrayList<Long>();
        Iterator<EncryptedData> encLayers = this.getEncryptionLayers();
        while (encLayers.hasNext()) {
            EncryptedData layer = encLayers.next();
            keyIds.addAll(layer.getRecipients());
        }
        return keyIds;
    }

    @Nonnull
    public Iterator<EncryptedData> getEncryptionLayers() {
        return new LayerIterator<EncryptedData>(this.message){

            @Override
            public boolean matches(Packet layer) {
                return layer instanceof EncryptedData;
            }

            @Override
            public EncryptedData getProperty(Layer last) {
                return (EncryptedData)last;
            }
        };
    }

    @Nullable
    public SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return MessageMetadata.firstOrNull(this.getEncryptionAlgorithms());
    }

    @Nonnull
    public Iterator<SymmetricKeyAlgorithm> getEncryptionAlgorithms() {
        return MessageMetadata.map(this.getEncryptionLayers(), encryptedData -> encryptedData.algorithm);
    }

    @Nonnull
    public Iterator<CompressedData> getCompressionLayers() {
        return new LayerIterator<CompressedData>(this.message){

            @Override
            boolean matches(Packet layer) {
                return layer instanceof CompressedData;
            }

            @Override
            CompressedData getProperty(Layer last) {
                return (CompressedData)last;
            }
        };
    }

    @Nullable
    public CompressionAlgorithm getCompressionAlgorithm() {
        return MessageMetadata.firstOrNull(this.getCompressionAlgorithms());
    }

    @Nonnull
    public Iterator<CompressionAlgorithm> getCompressionAlgorithms() {
        return MessageMetadata.map(this.getCompressionLayers(), compressionLayer -> compressionLayer.algorithm);
    }

    @Nullable
    public SessionKey getSessionKey() {
        return MessageMetadata.firstOrNull(this.getSessionKeys());
    }

    @Nonnull
    public Iterator<SessionKey> getSessionKeys() {
        return MessageMetadata.map(this.getEncryptionLayers(), encryptedData -> encryptedData.sessionKey);
    }

    public boolean isVerifiedSignedBy(@Nonnull PGPKeyRing keys) {
        return this.isVerifiedInlineSignedBy(keys) || this.isVerifiedDetachedSignedBy(keys);
    }

    public List<SignatureVerification> getVerifiedSignatures() {
        List<SignatureVerification> allVerifiedSignatures = this.getVerifiedInlineSignatures();
        allVerifiedSignatures.addAll(this.getVerifiedDetachedSignatures());
        return allVerifiedSignatures;
    }

    public boolean isVerifiedDetachedSignedBy(@Nonnull PGPKeyRing keys) {
        return MessageMetadata.containsSignatureBy(this.getVerifiedDetachedSignatures(), keys);
    }

    @Nonnull
    public List<SignatureVerification> getVerifiedDetachedSignatures() {
        return this.message.getVerifiedDetachedSignatures();
    }

    @Nonnull
    public List<SignatureVerification.Failure> getRejectedDetachedSignatures() {
        return this.message.getRejectedDetachedSignatures();
    }

    public boolean isVerifiedInlineSignedBy(@Nonnull PGPKeyRing keys) {
        return MessageMetadata.containsSignatureBy(this.getVerifiedInlineSignatures(), keys);
    }

    @Nonnull
    public List<SignatureVerification> getVerifiedInlineSignatures() {
        ArrayList<SignatureVerification> verifications = new ArrayList<SignatureVerification>();
        Iterator<List<SignatureVerification>> verificationsByLayer = this.getVerifiedInlineSignaturesByLayer();
        while (verificationsByLayer.hasNext()) {
            verifications.addAll((Collection<SignatureVerification>)verificationsByLayer.next());
        }
        return verifications;
    }

    @Nonnull
    public Iterator<List<SignatureVerification>> getVerifiedInlineSignaturesByLayer() {
        return new LayerIterator<List<SignatureVerification>>(this.message){

            @Override
            boolean matches(Packet layer) {
                return layer instanceof Layer;
            }

            @Override
            List<SignatureVerification> getProperty(Layer last) {
                ArrayList<SignatureVerification> list = new ArrayList<SignatureVerification>();
                list.addAll(last.getVerifiedOnePassSignatures());
                list.addAll(last.getVerifiedPrependedSignatures());
                return list;
            }
        };
    }

    @Nonnull
    public List<SignatureVerification.Failure> getRejectedInlineSignatures() {
        ArrayList<SignatureVerification.Failure> rejected = new ArrayList<SignatureVerification.Failure>();
        Iterator<List<SignatureVerification.Failure>> rejectedByLayer = this.getRejectedInlineSignaturesByLayer();
        while (rejectedByLayer.hasNext()) {
            rejected.addAll((Collection<SignatureVerification.Failure>)rejectedByLayer.next());
        }
        return rejected;
    }

    @Nonnull
    public Iterator<List<SignatureVerification.Failure>> getRejectedInlineSignaturesByLayer() {
        return new LayerIterator<List<SignatureVerification.Failure>>(this.message){

            @Override
            boolean matches(Packet layer) {
                return layer instanceof Layer;
            }

            @Override
            List<SignatureVerification.Failure> getProperty(Layer last) {
                ArrayList<SignatureVerification.Failure> list = new ArrayList<SignatureVerification.Failure>();
                list.addAll(last.getRejectedOnePassSignatures());
                list.addAll(last.getRejectedPrependedSignatures());
                return list;
            }
        };
    }

    private static boolean containsSignatureBy(@Nonnull List<SignatureVerification> verifications, @Nonnull PGPKeyRing keys) {
        for (SignatureVerification verification : verifications) {
            SubkeyIdentifier issuer = verification.getSigningKey();
            if (issuer == null || keys.getPublicKey().getKeyID() != issuer.getPrimaryKeyId() || keys.getPublicKey(issuer.getSubkeyId()) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getFilename() {
        LiteralData literalData = this.findLiteralData();
        if (literalData == null) {
            return null;
        }
        return literalData.getFileName();
    }

    public boolean isForYourEyesOnly() {
        return "_CONSOLE".equals(this.getFilename());
    }

    @Nullable
    public Date getModificationDate() {
        LiteralData literalData = this.findLiteralData();
        if (literalData == null) {
            return null;
        }
        return literalData.getModificationDate();
    }

    @Nullable
    public StreamEncoding getLiteralDataEncoding() {
        LiteralData literalData = this.findLiteralData();
        if (literalData == null) {
            return null;
        }
        return literalData.getFormat();
    }

    @Nullable
    private LiteralData findLiteralData() {
        Nested nested = this.message.getChild();
        if (nested == null) {
            return null;
        }
        while (nested != null && nested.hasNestedChild()) {
            Layer layer = (Layer)((Object)nested);
            nested = layer.getChild();
        }
        return (LiteralData)nested;
    }

    public SubkeyIdentifier getDecryptionKey() {
        return MessageMetadata.firstOrNull(MessageMetadata.map(this.getEncryptionLayers(), encryptedData -> encryptedData.decryptionKey));
    }

    public boolean isVerifiedSigned() {
        return !this.getVerifiedSignatures().isEmpty();
    }

    private static <A, B> Iterator<B> map(final Iterator<A> from, final Function<A, B> mapping) {
        return new Iterator<B>(){

            @Override
            public boolean hasNext() {
                return from.hasNext();
            }

            @Override
            public B next() {
                return mapping.apply(from.next());
            }
        };
    }

    @Nullable
    private static <A> A firstOrNull(Iterator<A> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    private static <A> A firstOr(Iterator<A> iterator, A item) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return item;
    }

    public static interface Function<A, B> {
        public B apply(A var1);
    }

    private static abstract class LayerIterator<O>
    implements Iterator<O> {
        private Nested current;
        Layer last = null;
        Message parent;

        LayerIterator(@Nonnull Message message) {
            this.parent = message;
            this.current = message.getChild();
            if (this.matches(this.current)) {
                this.last = (Layer)((Object)this.current);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.parent != null && this.matches(this.parent)) {
                return true;
            }
            if (this.last == null) {
                this.findNext();
            }
            return this.last != null;
        }

        @Override
        public O next() {
            if (this.parent != null && this.matches(this.parent)) {
                O property = this.getProperty(this.parent);
                this.parent = null;
                return property;
            }
            if (this.last == null) {
                this.findNext();
            }
            if (this.last != null) {
                O property = this.getProperty(this.last);
                this.last = null;
                return property;
            }
            throw new NoSuchElementException();
        }

        private void findNext() {
            while (this.current != null && this.current instanceof Layer) {
                this.current = ((Layer)((Object)this.current)).getChild();
                if (!this.matches(this.current)) continue;
                this.last = (Layer)((Object)this.current);
                break;
            }
        }

        abstract boolean matches(Packet var1);

        abstract O getProperty(Layer var1);
    }

    public static class EncryptedData
    extends Layer
    implements Nested {
        protected final SymmetricKeyAlgorithm algorithm;
        protected SubkeyIdentifier decryptionKey;
        protected SessionKey sessionKey;
        protected List<Long> recipients;

        public EncryptedData(@Nonnull SymmetricKeyAlgorithm algorithm, int depth) {
            super(depth);
            this.algorithm = algorithm;
        }

        @Nonnull
        public SymmetricKeyAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        @Nonnull
        public SessionKey getSessionKey() {
            return this.sessionKey;
        }

        @Nonnull
        public List<Long> getRecipients() {
            if (this.recipients == null) {
                return new ArrayList<Long>();
            }
            return new ArrayList<Long>(this.recipients);
        }

        @Override
        public boolean hasNestedChild() {
            return true;
        }
    }

    public static class CompressedData
    extends Layer
    implements Nested {
        protected final CompressionAlgorithm algorithm;

        public CompressedData(@Nonnull CompressionAlgorithm zip, int depth) {
            super(depth);
            this.algorithm = zip;
        }

        @Nonnull
        public CompressionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public boolean hasNestedChild() {
            return true;
        }
    }

    public static class LiteralData
    implements Nested {
        protected String fileName;
        protected Date modificationDate;
        protected StreamEncoding format;

        public LiteralData() {
            this("", new Date(0L), StreamEncoding.BINARY);
        }

        public LiteralData(@Nonnull String fileName, @Nonnull Date modificationDate, @Nonnull StreamEncoding format) {
            this.fileName = fileName;
            this.modificationDate = modificationDate;
            this.format = format;
        }

        @Nonnull
        public String getFileName() {
            return this.fileName;
        }

        @Nonnull
        public Date getModificationDate() {
            return this.modificationDate;
        }

        @Nonnull
        public StreamEncoding getFormat() {
            return this.format;
        }

        @Override
        public boolean hasNestedChild() {
            return false;
        }
    }

    public static class Message
    extends Layer {
        protected boolean cleartextSigned;

        public Message() {
            super(0);
        }

        public boolean isCleartextSigned() {
            return this.cleartextSigned;
        }
    }

    public static interface Nested
    extends Packet {
        public boolean hasNestedChild();
    }

    public static abstract class Layer
    implements Packet {
        public static final int MAX_LAYER_DEPTH = 16;
        protected final int depth;
        protected final List<SignatureVerification> verifiedDetachedSignatures = new ArrayList<SignatureVerification>();
        protected final List<SignatureVerification.Failure> rejectedDetachedSignatures = new ArrayList<SignatureVerification.Failure>();
        protected final List<SignatureVerification> verifiedOnePassSignatures = new ArrayList<SignatureVerification>();
        protected final List<SignatureVerification.Failure> rejectedOnePassSignatures = new ArrayList<SignatureVerification.Failure>();
        protected final List<SignatureVerification> verifiedPrependedSignatures = new ArrayList<SignatureVerification>();
        protected final List<SignatureVerification.Failure> rejectedPrependedSignatures = new ArrayList<SignatureVerification.Failure>();
        protected Nested child;

        public Layer(int depth) {
            this.depth = depth;
            if (depth > 16) {
                throw new MalformedOpenPgpMessageException("Maximum packet nesting depth (16) exceeded.");
            }
        }

        @Nullable
        public Nested getChild() {
            return this.child;
        }

        void setChild(Nested child) {
            this.child = child;
        }

        public List<SignatureVerification> getVerifiedDetachedSignatures() {
            return new ArrayList<SignatureVerification>(this.verifiedDetachedSignatures);
        }

        public List<SignatureVerification.Failure> getRejectedDetachedSignatures() {
            return new ArrayList<SignatureVerification.Failure>(this.rejectedDetachedSignatures);
        }

        void addVerifiedDetachedSignature(SignatureVerification signatureVerification) {
            this.verifiedDetachedSignatures.add(signatureVerification);
        }

        void addRejectedDetachedSignature(SignatureVerification.Failure failure) {
            this.rejectedDetachedSignatures.add(failure);
        }

        public List<SignatureVerification> getVerifiedOnePassSignatures() {
            return new ArrayList<SignatureVerification>(this.verifiedOnePassSignatures);
        }

        public List<SignatureVerification.Failure> getRejectedOnePassSignatures() {
            return new ArrayList<SignatureVerification.Failure>(this.rejectedOnePassSignatures);
        }

        void addVerifiedOnePassSignature(SignatureVerification verifiedOnePassSignature) {
            this.verifiedOnePassSignatures.add(verifiedOnePassSignature);
        }

        void addRejectedOnePassSignature(SignatureVerification.Failure rejected) {
            this.rejectedOnePassSignatures.add(rejected);
        }

        public List<SignatureVerification> getVerifiedPrependedSignatures() {
            return new ArrayList<SignatureVerification>(this.verifiedPrependedSignatures);
        }

        public List<SignatureVerification.Failure> getRejectedPrependedSignatures() {
            return new ArrayList<SignatureVerification.Failure>(this.rejectedPrependedSignatures);
        }

        void addVerifiedPrependedSignature(SignatureVerification verified) {
            this.verifiedPrependedSignatures.add(verified);
        }

        void addRejectedPrependedSignature(SignatureVerification.Failure rejected) {
            this.rejectedPrependedSignatures.add(rejected);
        }
    }

    public static interface Packet {
    }
}

