/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.RevocationState;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.key.util.KeyIdUtil;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.consumer.SignaturePicker;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.CollectionUtils;
import org.pgpainless.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRingInfo {
    private static final Pattern PATTERN_EMAIL_FROM_USERID = Pattern.compile("<([a-zA-Z0-9_!#$%&'*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+)>");
    private static final Pattern PATTERN_EMAIL_EXPLICIT = Pattern.compile("^([a-zA-Z0-9_!#$%&'*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+)$");
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyRingInfo.class);
    private final PGPKeyRing keys;
    private final Signatures signatures;
    private final Date referenceDate;
    private final String primaryUserId;
    private final RevocationState revocationState;

    @Nonnull
    public static KeyRingInfo evaluateForSignature(@Nonnull PGPKeyRing keyRing, @Nonnull PGPSignature signature) {
        return new KeyRingInfo(keyRing, signature.getCreationTime());
    }

    public KeyRingInfo(@Nonnull PGPKeyRing keys) {
        this(keys, new Date());
    }

    public KeyRingInfo(@Nonnull PGPKeyRing keys, @Nonnull Date referenceDate) {
        this(keys, PGPainless.getPolicy(), referenceDate);
    }

    public KeyRingInfo(@Nonnull PGPKeyRing keys, @Nonnull Policy policy, @Nonnull Date referenceDate) {
        this.referenceDate = referenceDate;
        this.keys = keys;
        this.signatures = new Signatures(keys, this.referenceDate, policy);
        this.primaryUserId = this.findPrimaryUserId();
        this.revocationState = this.findRevocationState();
    }

    public PGPKeyRing getKeys() {
        return this.keys;
    }

    public List<PGPPublicKey> getValidSubkeys() {
        ArrayList<PGPPublicKey> subkeys = new ArrayList<PGPPublicKey>();
        Iterator iterator = this.getKeys().getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)iterator.next();
            if (!this.isKeyValidlyBound(key.getKeyID())) continue;
            subkeys.add(key);
        }
        return subkeys;
    }

    @Nonnull
    private RevocationState findRevocationState() {
        PGPSignature revocation = this.signatures.primaryKeyRevocation;
        if (revocation != null) {
            return SignatureUtils.isHardRevocation(revocation) ? RevocationState.hardRevoked() : RevocationState.softRevoked(revocation.getCreationTime());
        }
        return RevocationState.notRevoked();
    }

    @Nonnull
    public PGPPublicKey getPublicKey() {
        return this.keys.getPublicKey();
    }

    @Nullable
    public PGPPublicKey getPublicKey(@Nonnull OpenPgpFingerprint fingerprint) {
        return this.getPublicKey(fingerprint.getKeyId());
    }

    @Nullable
    public PGPPublicKey getPublicKey(long keyId) {
        return KeyRingInfo.getPublicKey(this.keys, keyId);
    }

    @Nullable
    public static PGPPublicKey getPublicKey(@Nonnull PGPKeyRing keyRing, long keyId) {
        return keyRing.getPublicKey(keyId);
    }

    public boolean isKeyValidlyBound(long keyId) {
        PGPPublicKey publicKey = this.keys.getPublicKey(keyId);
        if (publicKey == null) {
            return false;
        }
        if (publicKey == this.getPublicKey()) {
            if (this.signatures.primaryKeyRevocation != null && SignatureUtils.isHardRevocation(this.signatures.primaryKeyRevocation)) {
                return false;
            }
            return this.signatures.primaryKeyRevocation == null;
        }
        PGPSignature binding = (PGPSignature)this.signatures.subkeyBindings.get(keyId);
        PGPSignature revocation = (PGPSignature)this.signatures.subkeyRevocations.get(keyId);
        if (binding == null || SignatureUtils.isSignatureExpired(binding)) {
            return false;
        }
        if (revocation != null) {
            if (SignatureUtils.isHardRevocation(revocation)) {
                return false;
            }
            return SignatureUtils.isSignatureExpired(revocation) || !revocation.getCreationTime().after(binding.getCreationTime());
        }
        return true;
    }

    @Nonnull
    public List<PGPPublicKey> getPublicKeys() {
        Iterator iterator = this.keys.getPublicKeys();
        List list = CollectionUtils.iteratorToList(iterator);
        return Collections.unmodifiableList(list);
    }

    @Nullable
    public PGPSecretKey getSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            return secretKeys.getSecretKey();
        }
        return null;
    }

    @Nullable
    public PGPSecretKey getSecretKey(@Nonnull OpenPgpFingerprint fingerprint) {
        return this.getSecretKey(fingerprint.getKeyId());
    }

    @Nullable
    public PGPSecretKey getSecretKey(long keyId) {
        if (this.keys instanceof PGPSecretKeyRing) {
            return ((PGPSecretKeyRing)this.keys).getSecretKey(keyId);
        }
        return null;
    }

    @Nonnull
    public List<PGPSecretKey> getSecretKeys() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            Iterator iterator = secretKeys.getSecretKeys();
            return Collections.unmodifiableList(CollectionUtils.iteratorToList(iterator));
        }
        return Collections.emptyList();
    }

    public long getKeyId() {
        return this.getPublicKey().getKeyID();
    }

    @Nonnull
    public OpenPgpFingerprint getFingerprint() {
        return OpenPgpFingerprint.of(this.getPublicKey());
    }

    @Nullable
    public String getPrimaryUserId() {
        return this.primaryUserId;
    }

    @Nullable
    private String findPrimaryUserId() {
        String primaryUserId = null;
        Date currentModificationDate = null;
        List<String> userIds = this.getUserIds();
        if (userIds.isEmpty()) {
            return null;
        }
        String firstUserId = null;
        for (String userId : userIds) {
            PGPSignature certification = (PGPSignature)this.signatures.userIdCertifications.get(userId);
            if (certification == null) continue;
            if (firstUserId == null) {
                firstUserId = userId;
            }
            Date creationTime = certification.getCreationTime();
            if (!certification.getHashedSubPackets().isPrimaryUserID() || currentModificationDate != null && !creationTime.after(currentModificationDate)) continue;
            primaryUserId = userId;
            currentModificationDate = creationTime;
        }
        if (primaryUserId != null) {
            return primaryUserId;
        }
        return firstUserId;
    }

    @Nonnull
    public List<String> getUserIds() {
        return KeyRingUtils.getUserIdsIgnoringInvalidUTF8(this.keys.getPublicKey());
    }

    @Nonnull
    public List<String> getValidUserIds() {
        ArrayList<String> valid = new ArrayList<String>();
        List<String> userIds = this.getUserIds();
        for (String userId : userIds) {
            if (!this.isUserIdBound(userId)) continue;
            valid.add(userId);
        }
        return valid;
    }

    @Nonnull
    public List<String> getValidAndExpiredUserIds() {
        ArrayList<String> probablyExpired = new ArrayList<String>();
        List<String> userIds = this.getUserIds();
        for (String userId : userIds) {
            PGPSignature certification = (PGPSignature)this.signatures.userIdCertifications.get(userId);
            PGPSignature revocation = (PGPSignature)this.signatures.userIdRevocations.get(userId);
            if (certification == null) continue;
            if (revocation == null) {
                probablyExpired.add(userId);
                continue;
            }
            if (SignatureUtils.isHardRevocation(revocation) || !certification.getCreationTime().after(revocation.getCreationTime())) continue;
            probablyExpired.add(userId);
        }
        return probablyExpired;
    }

    public boolean isUserIdValid(@Nonnull CharSequence userId) {
        if (this.primaryUserId == null) {
            return false;
        }
        if (!userId.equals(this.primaryUserId) && !this.isUserIdBound(this.primaryUserId)) {
            return false;
        }
        return this.isUserIdBound(userId);
    }

    private boolean isUserIdBound(@Nonnull CharSequence userId) {
        Date keyExpiration;
        String userIdString = userId.toString();
        PGPSignature certification = (PGPSignature)this.signatures.userIdCertifications.get(userIdString);
        PGPSignature revocation = (PGPSignature)this.signatures.userIdRevocations.get(userIdString);
        if (certification == null) {
            return false;
        }
        if (SignatureUtils.isSignatureExpired(certification)) {
            return false;
        }
        if (certification.getHashedSubPackets().isPrimaryUserID() && (keyExpiration = SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(certification, this.keys.getPublicKey())) != null && this.referenceDate.after(keyExpiration)) {
            return false;
        }
        if (revocation == null) {
            return true;
        }
        if (SignatureUtils.isHardRevocation(revocation)) {
            return false;
        }
        return certification.getCreationTime().after(revocation.getCreationTime());
    }

    @Nonnull
    public List<String> getEmailAddresses() {
        List<String> userIds = this.getUserIds();
        ArrayList<String> emails = new ArrayList<String>();
        for (String userId : userIds) {
            Matcher matcher = PATTERN_EMAIL_FROM_USERID.matcher(userId);
            if (matcher.find()) {
                emails.add(matcher.group(1));
                continue;
            }
            matcher = PATTERN_EMAIL_EXPLICIT.matcher(userId);
            if (!matcher.find()) continue;
            emails.add(matcher.group(1));
        }
        return emails;
    }

    @Nullable
    public PGPSignature getLatestDirectKeySelfSignature() {
        return this.signatures.primaryKeySelfSignature;
    }

    @Nullable
    public PGPSignature getRevocationSelfSignature() {
        return this.signatures.primaryKeyRevocation;
    }

    @Nullable
    public PGPSignature getLatestUserIdCertification(@Nonnull CharSequence userId) {
        return (PGPSignature)this.signatures.userIdCertifications.get(userId.toString());
    }

    @Nullable
    public PGPSignature getUserIdRevocation(@Nonnull CharSequence userId) {
        return (PGPSignature)this.signatures.userIdRevocations.get(userId.toString());
    }

    @Nullable
    public PGPSignature getCurrentSubkeyBindingSignature(long keyId) {
        return (PGPSignature)this.signatures.subkeyBindings.get(keyId);
    }

    @Nullable
    public PGPSignature getSubkeyRevocationSignature(long keyId) {
        return (PGPSignature)this.signatures.subkeyRevocations.get(keyId);
    }

    @Nonnull
    public List<KeyFlag> getKeyFlagsOf(long keyId) {
        if (this.getPublicKey().getKeyID() == keyId) {
            PGPSignature userIdSignature;
            List<KeyFlag> keyFlags;
            List<KeyFlag> keyFlags2;
            PGPSignature directKeySignature = this.getLatestDirectKeySelfSignature();
            if (directKeySignature != null && (keyFlags2 = SignatureSubpacketsUtil.parseKeyFlags(directKeySignature)) != null) {
                return keyFlags2;
            }
            String primaryUserId = this.getPrimaryUserId();
            if (primaryUserId != null && (keyFlags = SignatureSubpacketsUtil.parseKeyFlags(userIdSignature = this.getLatestUserIdCertification(primaryUserId))) != null) {
                return keyFlags;
            }
        } else {
            List<KeyFlag> keyFlags;
            PGPSignature bindingSignature = this.getCurrentSubkeyBindingSignature(keyId);
            if (bindingSignature != null && (keyFlags = SignatureSubpacketsUtil.parseKeyFlags(bindingSignature)) != null) {
                return keyFlags;
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<KeyFlag> getKeyFlagsOf(String userId) {
        if (!this.isUserIdValid(userId)) {
            return Collections.emptyList();
        }
        PGPSignature userIdCertification = this.getLatestUserIdCertification(userId);
        if (userIdCertification == null) {
            throw new AssertionError((Object)("While user-id '" + userId + "' was reported as valid, there appears to be no certification for it."));
        }
        List<KeyFlag> keyFlags = SignatureSubpacketsUtil.parseKeyFlags(userIdCertification);
        if (keyFlags != null) {
            return keyFlags;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.requireFromId(this.getPublicKey().getAlgorithm());
    }

    @Nonnull
    public Date getCreationDate() {
        return this.getPublicKey().getCreationTime();
    }

    @Nonnull
    public Date getLastModified() {
        PGPSignature mostRecent = this.getMostRecentSignature();
        if (mostRecent == null) {
            return this.getLatestKeyCreationDate();
        }
        return mostRecent.getCreationTime();
    }

    @Nonnull
    public Date getLatestKeyCreationDate() {
        Date latestCreation = null;
        for (PGPPublicKey key : this.getPublicKeys()) {
            if (!this.isKeyValidlyBound(key.getKeyID())) continue;
            Date keyCreation = key.getCreationTime();
            if (latestCreation != null && !latestCreation.before(keyCreation)) continue;
            latestCreation = keyCreation;
        }
        if (latestCreation == null) {
            throw new AssertionError((Object)"Apparently there is no validly bound key in this key ring.");
        }
        return latestCreation;
    }

    @Nullable
    private PGPSignature getMostRecentSignature() {
        HashSet<Object> allSignatures = new HashSet<Object>();
        PGPSignature mostRecentSelfSignature = this.getLatestDirectKeySelfSignature();
        PGPSignature revocationSelfSignature = this.getRevocationSelfSignature();
        if (mostRecentSelfSignature != null) {
            allSignatures.add(mostRecentSelfSignature);
        }
        if (revocationSelfSignature != null) {
            allSignatures.add(revocationSelfSignature);
        }
        allSignatures.addAll(this.signatures.userIdCertifications.values());
        allSignatures.addAll(this.signatures.userIdRevocations.values());
        allSignatures.addAll(this.signatures.subkeyBindings.values());
        allSignatures.addAll(this.signatures.subkeyRevocations.values());
        PGPSignature mostRecent = null;
        for (PGPSignature pGPSignature : allSignatures) {
            if (mostRecent != null && !pGPSignature.getCreationTime().after(mostRecent.getCreationTime())) continue;
            mostRecent = pGPSignature;
        }
        return mostRecent;
    }

    @Nonnull
    public RevocationState getRevocationState() {
        return this.revocationState;
    }

    @Nullable
    public Date getRevocationDate() {
        return this.getRevocationState().isSoftRevocation() ? this.getRevocationState().getDate() : null;
    }

    @Nullable
    public Date getPrimaryKeyExpirationDate() {
        PGPSignature directKeySig = this.getLatestDirectKeySelfSignature();
        Date directKeyExpirationDate = null;
        if (directKeySig != null) {
            directKeyExpirationDate = SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(directKeySig, this.getPublicKey());
        }
        PGPSignature primaryUserIdCertification = null;
        Date userIdExpirationDate = null;
        String possiblyExpiredPrimaryUserId = this.getPossiblyExpiredPrimaryUserId();
        if (possiblyExpiredPrimaryUserId != null && (primaryUserIdCertification = this.getLatestUserIdCertification(possiblyExpiredPrimaryUserId)) != null) {
            userIdExpirationDate = SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(primaryUserIdCertification, this.getPublicKey());
        }
        if (directKeySig == null && primaryUserIdCertification == null) {
            throw new NoSuchElementException("No direct-key signature and no user-id signature found.");
        }
        if (directKeyExpirationDate != null && userIdExpirationDate == null) {
            return directKeyExpirationDate;
        }
        if (directKeyExpirationDate == null) {
            return userIdExpirationDate;
        }
        if (directKeyExpirationDate.before(userIdExpirationDate)) {
            return directKeyExpirationDate;
        }
        return userIdExpirationDate;
    }

    @Nullable
    public String getPossiblyExpiredPrimaryUserId() {
        String validPrimaryUserId = this.getPrimaryUserId();
        if (validPrimaryUserId != null) {
            return validPrimaryUserId;
        }
        Date latestCreationTime = null;
        String primaryUserId = null;
        boolean foundPrimary = false;
        for (String userId : this.getUserIds()) {
            PGPSignature signature = this.getLatestUserIdCertification(userId);
            if (signature == null) continue;
            boolean isPrimary = signature.getHashedSubPackets().isPrimaryUserID();
            if (foundPrimary && !isPrimary) continue;
            Date creationTime = signature.getCreationTime();
            if (latestCreationTime == null || creationTime.after(latestCreationTime) || isPrimary && !foundPrimary) {
                latestCreationTime = creationTime;
                primaryUserId = userId;
            }
            foundPrimary |= isPrimary;
        }
        return primaryUserId;
    }

    @Nullable
    public Date getSubkeyExpirationDate(OpenPgpFingerprint fingerprint) {
        if (this.getPublicKey().getKeyID() == fingerprint.getKeyId()) {
            return this.getPrimaryKeyExpirationDate();
        }
        PGPPublicKey subkey = this.getPublicKey(fingerprint.getKeyId());
        if (subkey == null) {
            throw new NoSuchElementException("No subkey with fingerprint " + fingerprint + " found.");
        }
        PGPSignature bindingSig = this.getCurrentSubkeyBindingSignature(fingerprint.getKeyId());
        if (bindingSig == null) {
            throw new AssertionError((Object)"Subkey has no valid binding signature.");
        }
        return SignatureUtils.getKeyExpirationDate(subkey.getCreationTime(), bindingSig);
    }

    @Nullable
    public Date getExpirationDateForUse(KeyFlag use) {
        if (use == KeyFlag.SPLIT || use == KeyFlag.SHARED) {
            throw new IllegalArgumentException("SPLIT and SHARED are not uses, but properties.");
        }
        Date primaryExpiration = this.getPrimaryKeyExpirationDate();
        ArrayList<PGPPublicKey> nonExpiringSubkeys = new ArrayList<PGPPublicKey>();
        Date latestSubkeyExpirationDate = null;
        List<PGPPublicKey> keysWithFlag = this.getKeysWithKeyFlag(use);
        if (keysWithFlag.isEmpty()) {
            throw new NoSuchElementException("No key with the required key flag found.");
        }
        for (PGPPublicKey key : keysWithFlag) {
            Date subkeyExpirationDate = this.getSubkeyExpirationDate(OpenPgpFingerprint.of(key));
            if (subkeyExpirationDate == null) {
                nonExpiringSubkeys.add(key);
                continue;
            }
            if (latestSubkeyExpirationDate != null && !subkeyExpirationDate.after(latestSubkeyExpirationDate)) continue;
            latestSubkeyExpirationDate = subkeyExpirationDate;
        }
        if (nonExpiringSubkeys.isEmpty()) {
            if (primaryExpiration == null) {
                return latestSubkeyExpirationDate;
            }
            if (latestSubkeyExpirationDate.before(primaryExpiration)) {
                return latestSubkeyExpirationDate;
            }
        }
        return primaryExpiration;
    }

    public boolean isHardRevoked(@Nonnull CharSequence userId) {
        PGPSignature revocation = (PGPSignature)this.signatures.userIdRevocations.get(userId.toString());
        if (revocation == null) {
            return false;
        }
        RevocationReason revocationReason = revocation.getHashedSubPackets().getRevocationReason();
        return revocationReason == null || RevocationAttributes.Reason.isHardRevocation(revocationReason.getRevocationReason());
    }

    public boolean isSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            return true;
        }
        if (this.keys instanceof PGPPublicKeyRing) {
            return false;
        }
        throw new AssertionError((Object)("Expected PGPKeyRing to be either PGPPublicKeyRing or PGPSecretKeyRing, but got " + this.keys.getClass().getName() + " instead."));
    }

    public boolean isFullyDecrypted() {
        if (!this.isSecretKey()) {
            return true;
        }
        for (PGPSecretKey secretKey : this.getSecretKeys()) {
            if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isEncrypted(secretKey)) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyEncrypted() {
        if (!this.isSecretKey()) {
            return false;
        }
        for (PGPSecretKey secretKey : this.getSecretKeys()) {
            if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isDecrypted(secretKey)) continue;
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.keys.getPublicKey().getVersion();
    }

    @Nonnull
    public List<PGPPublicKey> getEncryptionSubkeys(@Nonnull EncryptionPurpose purpose) {
        Date primaryExpiration = this.getPrimaryKeyExpirationDate();
        if (primaryExpiration != null && primaryExpiration.before(this.referenceDate)) {
            LOGGER.debug("Certificate is expired: Primary key is expired on " + DateUtil.formatUTCDate(primaryExpiration));
            return Collections.emptyList();
        }
        Iterator subkeys = this.keys.getPublicKeys();
        ArrayList<PGPPublicKey> encryptionKeys = new ArrayList<PGPPublicKey>();
        while (subkeys.hasNext()) {
            PGPPublicKey subKey = (PGPPublicKey)subkeys.next();
            if (!this.isKeyValidlyBound(subKey.getKeyID())) {
                LOGGER.debug("(Sub?)-Key " + KeyIdUtil.formatKeyId(subKey.getKeyID()) + " is not validly bound.");
                continue;
            }
            Date subkeyExpiration = this.getSubkeyExpirationDate(OpenPgpFingerprint.of(subKey));
            if (subkeyExpiration != null && subkeyExpiration.before(this.referenceDate)) {
                LOGGER.debug("(Sub?)-Key  " + KeyIdUtil.formatKeyId(subKey.getKeyID()) + " is expired on " + DateUtil.formatUTCDate(subkeyExpiration));
                continue;
            }
            if (!subKey.isEncryptionKey()) {
                LOGGER.debug("(Sub?)-Key " + KeyIdUtil.formatKeyId(subKey.getKeyID()) + " algorithm is not capable of encryption.");
                continue;
            }
            List<KeyFlag> keyFlags = this.getKeyFlagsOf(subKey.getKeyID());
            switch (purpose) {
                case COMMUNICATIONS: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_COMMS)) break;
                    encryptionKeys.add(subKey);
                    break;
                }
                case STORAGE: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_STORAGE)) break;
                    encryptionKeys.add(subKey);
                    break;
                }
                case ANY: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_COMMS) && !keyFlags.contains((Object)KeyFlag.ENCRYPT_STORAGE)) break;
                    encryptionKeys.add(subKey);
                }
            }
        }
        return encryptionKeys;
    }

    @Nonnull
    public List<PGPPublicKey> getDecryptionSubkeys() {
        Iterator subkeys = this.keys.getPublicKeys();
        ArrayList<PGPPublicKey> decryptionKeys = new ArrayList<PGPPublicKey>();
        while (subkeys.hasNext()) {
            PGPSignature binding;
            PGPPublicKey subKey = (PGPPublicKey)subkeys.next();
            if (subKey.getKeyID() != this.getKeyId() && (binding = (PGPSignature)this.signatures.subkeyBindings.get(subKey.getKeyID())) == null) {
                LOGGER.debug("Subkey " + KeyIdUtil.formatKeyId(subKey.getKeyID()) + " was never validly bound.");
                continue;
            }
            if (!subKey.isEncryptionKey()) {
                LOGGER.debug("(Sub?)-Key " + KeyIdUtil.formatKeyId(subKey.getKeyID()) + " is not encryption-capable.");
                continue;
            }
            decryptionKeys.add(subKey);
        }
        return decryptionKeys;
    }

    @Nonnull
    public List<PGPPublicKey> getKeysWithKeyFlag(@Nonnull KeyFlag flag) {
        ArrayList<PGPPublicKey> keysWithFlag = new ArrayList<PGPPublicKey>();
        for (PGPPublicKey key : this.getPublicKeys()) {
            List<KeyFlag> keyFlags = this.getKeyFlagsOf(key.getKeyID());
            if (!keyFlags.contains((Object)flag)) continue;
            keysWithFlag.add(key);
        }
        return keysWithFlag;
    }

    @Nonnull
    public List<PGPPublicKey> getEncryptionSubkeys(@Nullable CharSequence userId, @Nonnull EncryptionPurpose purpose) {
        if (userId != null && !this.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.of(this.keys), userId.toString(), this.getLatestUserIdCertification(userId), this.getUserIdRevocation(userId));
        }
        return this.getEncryptionSubkeys(purpose);
    }

    @Nonnull
    public List<PGPPublicKey> getSigningSubkeys() {
        Iterator subkeys = this.keys.getPublicKeys();
        ArrayList<PGPPublicKey> signingKeys = new ArrayList<PGPPublicKey>();
        while (subkeys.hasNext()) {
            List<KeyFlag> keyFlags;
            PGPPublicKey subKey = (PGPPublicKey)subkeys.next();
            if (!this.isKeyValidlyBound(subKey.getKeyID()) || !(keyFlags = this.getKeyFlagsOf(subKey.getKeyID())).contains((Object)KeyFlag.SIGN_DATA)) continue;
            signingKeys.add(subKey);
        }
        return signingKeys;
    }

    @Nonnull
    public Set<HashAlgorithm> getPreferredHashAlgorithms() {
        return this.getPreferredHashAlgorithms(this.getPrimaryUserId());
    }

    @Nonnull
    public Set<HashAlgorithm> getPreferredHashAlgorithms(@Nullable CharSequence userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredHashAlgorithms();
    }

    @Nonnull
    public Set<HashAlgorithm> getPreferredHashAlgorithms(long keyId) {
        return new KeyAccessor.SubKey(this, new SubkeyIdentifier(this.keys, keyId)).getPreferredHashAlgorithms();
    }

    @Nonnull
    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms() {
        return this.getPreferredSymmetricKeyAlgorithms(this.getPrimaryUserId());
    }

    @Nonnull
    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms(@Nullable CharSequence userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredSymmetricKeyAlgorithms();
    }

    @Nonnull
    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms(long keyId) {
        return new KeyAccessor.SubKey(this, new SubkeyIdentifier(this.keys, keyId)).getPreferredSymmetricKeyAlgorithms();
    }

    @Nonnull
    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms() {
        return this.getPreferredCompressionAlgorithms(this.getPrimaryUserId());
    }

    @Nonnull
    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms(@Nullable CharSequence userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredCompressionAlgorithms();
    }

    @Nonnull
    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms(long keyId) {
        return new KeyAccessor.SubKey(this, new SubkeyIdentifier(this.keys, keyId)).getPreferredCompressionAlgorithms();
    }

    public boolean isUsableForEncryption() {
        return this.isUsableForEncryption(EncryptionPurpose.ANY);
    }

    public boolean isUsableForEncryption(@Nonnull EncryptionPurpose purpose) {
        return this.isKeyValidlyBound(this.getKeyId()) && !this.getEncryptionSubkeys(purpose).isEmpty();
    }

    public boolean isSigningCapable() {
        if (!this.isKeyValidlyBound(this.getKeyId())) {
            return false;
        }
        return !this.getSigningSubkeys().isEmpty();
    }

    public boolean isUsableForSigning() {
        if (!this.isSigningCapable()) {
            return false;
        }
        List<PGPPublicKey> signingKeys = this.getSigningSubkeys();
        Iterator<PGPPublicKey> iterator = signingKeys.iterator();
        if (iterator.hasNext()) {
            PGPPublicKey pk = iterator.next();
            return this.isSecretKeyAvailable(pk.getKeyID());
        }
        return false;
    }

    public boolean isSecretKeyAvailable(long keyId) {
        PGPSecretKey sk = this.getSecretKey(keyId);
        if (sk == null) {
            return false;
        }
        S2K s2K = sk.getS2K();
        if (s2K == null) {
            return true;
        }
        int s2kType = s2K.getType();
        return s2kType < 100 || s2kType > 110;
    }

    private KeyAccessor getKeyAccessor(@Nullable CharSequence userId, long keyID) {
        if (this.getPublicKey(keyID) == null) {
            throw new NoSuchElementException("No subkey with key id " + Long.toHexString(keyID) + " found on this key.");
        }
        if (userId != null && !this.getUserIds().contains(userId.toString())) {
            throw new NoSuchElementException("No user-id '" + userId + "' found on this key.");
        }
        if (userId != null) {
            return new KeyAccessor.ViaUserId(this, new SubkeyIdentifier(this.keys, keyID), userId.toString());
        }
        return new KeyAccessor.ViaKeyId(this, new SubkeyIdentifier(this.keys, keyID));
    }

    public static class Signatures {
        private final PGPSignature primaryKeyRevocation;
        private final PGPSignature primaryKeySelfSignature;
        private final Map<String, PGPSignature> userIdRevocations;
        private final Map<String, PGPSignature> userIdCertifications;
        private final Map<Long, PGPSignature> subkeyRevocations;
        private final Map<Long, PGPSignature> subkeyBindings;

        public Signatures(@Nonnull PGPKeyRing keyRing, @Nonnull Date referenceDate, @Nonnull Policy policy) {
            this.primaryKeyRevocation = SignaturePicker.pickCurrentRevocationSelfSignature(keyRing, policy, referenceDate);
            this.primaryKeySelfSignature = SignaturePicker.pickLatestDirectKeySignature(keyRing, policy, referenceDate);
            this.userIdRevocations = new HashMap<String, PGPSignature>();
            this.userIdCertifications = new HashMap<String, PGPSignature>();
            this.subkeyRevocations = new HashMap<Long, PGPSignature>();
            this.subkeyBindings = new HashMap<Long, PGPSignature>();
            List<String> userIds = KeyRingUtils.getUserIdsIgnoringInvalidUTF8(keyRing.getPublicKey());
            for (String userId : userIds) {
                PGPSignature certification;
                PGPSignature revocation = SignaturePicker.pickCurrentUserIdRevocationSignature(keyRing, userId, policy, referenceDate);
                if (revocation != null) {
                    this.userIdRevocations.put(userId, revocation);
                }
                if ((certification = SignaturePicker.pickLatestUserIdCertificationSignature(keyRing, userId, policy, referenceDate)) == null) continue;
                this.userIdCertifications.put(userId, certification);
            }
            Iterator keys = keyRing.getPublicKeys();
            keys.next();
            while (keys.hasNext()) {
                PGPSignature subkeyBinding;
                PGPPublicKey subkey = (PGPPublicKey)keys.next();
                PGPSignature subkeyRevocation = SignaturePicker.pickCurrentSubkeyBindingRevocationSignature(keyRing, subkey, policy, referenceDate);
                if (subkeyRevocation != null) {
                    this.subkeyRevocations.put(subkey.getKeyID(), subkeyRevocation);
                }
                if ((subkeyBinding = SignaturePicker.pickLatestSubkeyBindingSignature(keyRing, subkey, policy, referenceDate)) == null) continue;
                this.subkeyBindings.put(subkey.getKeyID(), subkeyBinding);
            }
        }
    }
}

