/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public final class DateUtil {
    private DateUtil() {
    }

    @Nonnull
    public static SimpleDateFormat getParser() {
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        return parser;
    }

    @Nonnull
    public static Date parseUTCDate(@Nonnull String dateString) {
        try {
            return DateUtil.getParser().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Malformed UTC timestamp: " + dateString, e);
        }
    }

    @Nonnull
    public static String formatUTCDate(Date date) {
        return DateUtil.getParser().format(date);
    }

    @Nonnull
    public static Date toSecondsPrecision(@Nonnull Date date) {
        long millis = date.getTime();
        long seconds = millis / 1000L;
        long floored = seconds * 1000L;
        return new Date(floored);
    }

    @Nonnull
    public static Date now() {
        return DateUtil.toSecondsPrecision(new Date());
    }
}

