/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.certification;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CertificationType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.Trustworthiness;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.builder.ThirdPartyCertificationSignatureBuilder;
import org.pgpainless.signature.builder.ThirdPartyDirectKeySignatureBuilder;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.util.DateUtil;

public class CertifyCertificate {
    public CertificationOnUserId userIdOnCertificate(@Nonnull String userId, @Nonnull PGPPublicKeyRing certificate) {
        return this.userIdOnCertificate(userId, certificate, CertificationType.GENERIC);
    }

    public CertificationOnUserId userIdOnCertificate(@Nonnull String userid, @Nonnull PGPPublicKeyRing certificate, @Nonnull CertificationType certificationType) {
        return new CertificationOnUserId(userid, certificate, certificationType);
    }

    public DelegationOnCertificate certificate(@Nonnull PGPPublicKeyRing certificate) {
        return this.certificate(certificate, null);
    }

    public DelegationOnCertificate certificate(@Nonnull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness) {
        return new DelegationOnCertificate(certificate, trustworthiness);
    }

    private static PGPSecretKey getCertifyingSecretKey(PGPSecretKeyRing certificationKey) {
        Date now = DateUtil.now();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)certificationKey, now);
        OpenPgpFingerprint fingerprint = info.getFingerprint();
        PGPPublicKey certificationPubKey = info.getPublicKey(fingerprint);
        assert (certificationPubKey != null);
        if (!info.isKeyValidlyBound(certificationPubKey.getKeyID())) {
            throw new KeyException.RevokedKeyException(fingerprint);
        }
        Date expirationDate = info.getExpirationDateForUse(KeyFlag.CERTIFY_OTHER);
        if (expirationDate != null && expirationDate.before(now)) {
            throw new KeyException.ExpiredKeyException(fingerprint, expirationDate);
        }
        PGPSecretKey secretKey = certificationKey.getSecretKey(certificationPubKey.getKeyID());
        if (secretKey == null) {
            throw new KeyException.MissingSecretKeyException(fingerprint, certificationPubKey.getKeyID());
        }
        return secretKey;
    }

    public static class CertificationResult {
        private final PGPPublicKeyRing certificate;
        private final PGPSignature certification;

        CertificationResult(@Nonnull PGPPublicKeyRing certificate, @Nonnull PGPSignature certification) {
            this.certificate = certificate;
            this.certification = certification;
        }

        @Nonnull
        public PGPSignature getCertification() {
            return this.certification;
        }

        @Nonnull
        public PGPPublicKeyRing getCertifiedCertificate() {
            return this.certificate;
        }
    }

    public static class DelegationOnCertificateWithSubpackets {
        private final PGPPublicKeyRing certificate;
        private final ThirdPartyDirectKeySignatureBuilder sigBuilder;

        DelegationOnCertificateWithSubpackets(@Nonnull PGPPublicKeyRing certificate, @Nonnull ThirdPartyDirectKeySignatureBuilder sigBuilder) {
            this.certificate = certificate;
            this.sigBuilder = sigBuilder;
        }

        public CertificationResult buildWithSubpackets(@Nonnull CertificationSubpackets.Callback subpacketsCallback) throws PGPException {
            this.sigBuilder.applyCallback(subpacketsCallback);
            return this.build();
        }

        public CertificationResult build() throws PGPException {
            PGPPublicKey delegatedKey = this.certificate.getPublicKey();
            PGPSignature delegation = this.sigBuilder.build(delegatedKey);
            PGPPublicKeyRing delegatedCertificate = KeyRingUtils.injectCertification(this.certificate, delegatedKey, delegation);
            return new CertificationResult(delegatedCertificate, delegation);
        }
    }

    public static class DelegationOnCertificate {
        private final PGPPublicKeyRing certificate;
        private final Trustworthiness trustworthiness;

        DelegationOnCertificate(@Nonnull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness) {
            this.certificate = certificate;
            this.trustworthiness = trustworthiness;
        }

        public DelegationOnCertificateWithSubpackets withKey(@Nonnull PGPSecretKeyRing certificationKey, @Nonnull SecretKeyRingProtector protector) throws PGPException {
            PGPSecretKey secretKey = CertifyCertificate.getCertifyingSecretKey(certificationKey);
            ThirdPartyDirectKeySignatureBuilder sigBuilder = new ThirdPartyDirectKeySignatureBuilder(secretKey, protector);
            if (this.trustworthiness != null) {
                sigBuilder.getHashedSubpackets().setTrust(true, this.trustworthiness.getDepth(), this.trustworthiness.getAmount());
            }
            return new DelegationOnCertificateWithSubpackets(this.certificate, sigBuilder);
        }
    }

    public static class CertificationOnUserIdWithSubpackets {
        private final PGPPublicKeyRing certificate;
        private final String userId;
        private final ThirdPartyCertificationSignatureBuilder sigBuilder;

        CertificationOnUserIdWithSubpackets(@Nonnull PGPPublicKeyRing certificate, @Nonnull String userId, @Nonnull ThirdPartyCertificationSignatureBuilder sigBuilder) {
            this.certificate = certificate;
            this.userId = userId;
            this.sigBuilder = sigBuilder;
        }

        public CertificationResult buildWithSubpackets(@Nonnull CertificationSubpackets.Callback subpacketCallback) throws PGPException {
            this.sigBuilder.applyCallback(subpacketCallback);
            return this.build();
        }

        public CertificationResult build() throws PGPException {
            PGPSignature signature = this.sigBuilder.build(this.certificate, this.userId);
            PGPPublicKeyRing certifiedCertificate = KeyRingUtils.injectCertification(this.certificate, this.userId, signature);
            return new CertificationResult(certifiedCertificate, signature);
        }
    }

    public static class CertificationOnUserId {
        private final PGPPublicKeyRing certificate;
        private final String userId;
        private final CertificationType certificationType;

        CertificationOnUserId(@Nonnull String userId, @Nonnull PGPPublicKeyRing certificate, @Nonnull CertificationType certificationType) {
            this.userId = userId;
            this.certificate = certificate;
            this.certificationType = certificationType;
        }

        public CertificationOnUserIdWithSubpackets withKey(@Nonnull PGPSecretKeyRing certificationKey, @Nonnull SecretKeyRingProtector protector) throws PGPException {
            PGPSecretKey secretKey = CertifyCertificate.getCertifyingSecretKey(certificationKey);
            ThirdPartyCertificationSignatureBuilder sigBuilder = new ThirdPartyCertificationSignatureBuilder(this.certificationType.asSignatureType(), secretKey, protector);
            return new CertificationOnUserIdWithSubpackets(this.certificate, this.userId, sigBuilder);
        }
    }
}

