/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.pgpainless.encryption_signing.ProducerOptions;

public final class ArmoredOutputStreamFactory {
    public static final String PGPAINLESS = "PGPainless";
    private static String version = "PGPainless";
    private static String[] comment = new String[0];

    private ArmoredOutputStreamFactory() {
    }

    private static ArmoredOutputStream.Builder getBuilder() {
        ArmoredOutputStream.Builder builder = ArmoredOutputStream.builder();
        builder.clearHeaders();
        if (version != null && !version.isEmpty()) {
            builder.setVersion(version);
        }
        for (String comment : ArmoredOutputStreamFactory.comment) {
            builder.addComment(comment);
        }
        return builder;
    }

    @Nonnull
    public static ArmoredOutputStream get(@Nonnull OutputStream outputStream) {
        return ArmoredOutputStreamFactory.getBuilder().build(outputStream);
    }

    @Nonnull
    public static ArmoredOutputStream get(@Nonnull OutputStream outputStream, @Nonnull ProducerOptions options) {
        ArmoredOutputStream.Builder builder = ArmoredOutputStreamFactory.getBuilder();
        if (options.isHideArmorHeaders()) {
            builder.clearHeaders();
        }
        if (options.hasVersion()) {
            builder.setVersion(options.getVersion());
        }
        if (options.hasComment()) {
            builder.setComment(options.getComment());
        }
        return builder.build(outputStream);
    }

    public static void setVersionInfo(@Nullable String versionString) {
        if (versionString == null) {
            version = null;
            return;
        }
        String trimmed = versionString.trim();
        version = trimmed.isEmpty() ? null : trimmed;
    }

    public static void resetVersionInfo() {
        version = PGPAINLESS;
    }

    public static void setComment(@Nullable String commentString) {
        if (commentString == null) {
            throw new IllegalArgumentException("Comment cannot be null.");
        }
        String trimmed = commentString.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Comment cannot be empty.");
        }
        String[] lines = commentString.split("\n");
        comment = lines;
    }

    public static void resetComment() {
        comment = new String[0];
    }
}

