/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.CachingBcPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;

public class CachingBcPublicKeyDataDecryptorFactoryTest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: C8AE 4279 5958 5F46 86A9  8B5F EC69 7C29 2BE4 44E0\nComment: Alice\n\nlFgEY1vEcxYJKwYBBAHaRw8BAQdAXOUK1uc1iBeM+mMt2nLCukXWoJd/SodrtN9S\nU/zzwu0AAP9eePPw91KLuq6PF9jQoTRz/cW4CyiALNJpsOJIZ1rp3xOBtAVBbGlj\nZYiPBBMWCgBBBQJjW8RzCRDsaXwpK+RE4BYhBMiuQnlZWF9GhqmLX+xpfCkr5ETg\nAp4BApsBBRYCAwEABAsJCAcFFQoJCAsCmQEAAGqWAQC8oz7l8izjUis5ji+sgI+q\ngML22VNybqmLBpzZwnNU5wEApe9fNTRbK5yAITGBscxH7o74Qe+CLI6Ni5MwzKxr\n5AucXQRjW8RzEgorBgEEAZdVAQUBAQdAm8xk0QSvpp2ZU1KQ31E7eEZYLKpbW4JE\nopmtMQx6AlIDAQgHAAD/XTb/qSosfkNvli3BQiUzVRAqKaU4PKAq7at6afxoYSgN\n4Yh1BBgWCgAdBQJjW8RzAp4BApsMBRYCAwEABAsJCAcFFQoJCAsACgkQ7Gl8KSvk\nROB38QEA0MvDt0bjEXwFoM0E34z0MtPcG3VBYcQ+iFRIqFfEl5UA/2yZxFjoZqrs\nAQE8TaVpXYfbc2p/GEKA9LGd9l/g0QQLnFgEY1vEcxYJKwYBBAHaRw8BAQdAyCOv\n6hGUvHcCBSDKP3fRz+scyJ9zwMt7nFXK5A/k2YgAAQCn3Es+IhvePn3eBlcYMMr0\nxcktrY1NJAIZPfjlUJ0J1g6LiNUEGBYKAH0FAmNbxHMCngECmwIFFgIDAQAECwkI\nBwUVCgkIC18gBBkWCgAGBQJjW8RzAAoJECxLf7KoUc8wD18BANNpIr4E+RRVVztR\nOVwdxSe0SRWGjkW8nHrRyghHKTuMAP9p4ZKicOYA1uZbiNNjyuJuS8xBH6Hihurb\ngDypVgxdBQAKCRDsaXwpK+RE4EQjAP9ARZEPxKNLFkrvjoZ8nrts3qhv3VtMrU+9\nhuZnYLe1FQEAtgO6V7wutHvVARHXqPJ6lcv+SueIu+BjLFYEKuBwggs=\n=ShJd\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String MSG = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4DJmQMTBqw3G8SAQdALkHpO0UkS/CqkwxUz74MJU3PV72ZrIL8ZcrO8ofhblkw\niDIhSwwGTG3tj+sG+ZVWKsmONKi7Om5seJDHQtQ8MfdCELAgwYHSt6MrgDBhuDIH\n0kABZhq2/8qk3EGXPpc+xxs4r4g8SgHOiiHSim5NGtounXXIaF6T/hUmlorkeYf/\na9pCC0QXRUAr8NOcdsfbvb5V\n=dQa8\n-----END PGP MESSAGE-----";

    @Test
    public void test() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        SubkeyIdentifier decryptionKey = new SubkeyIdentifier((PGPKeyRing)secretKeys, ((PGPPublicKey)info.getEncryptionSubkeys(EncryptionPurpose.ANY).get(0)).getKeyID());
        PGPSecretKey secretKey = secretKeys.getSecretKey(decryptionKey.getSubkeyId());
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)protector);
        CachingBcPublicKeyDataDecryptorFactory cachingFactory = new CachingBcPublicKeyDataDecryptorFactory(privateKey, decryptionKey);
        ByteArrayInputStream ciphertextIn = new ByteArrayInputStream(MSG.getBytes());
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)ciphertextIn).withOptions(ConsumerOptions.get().addCustomDecryptorFactory((CustomPublicKeyDataDecryptorFactory)cachingFactory));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertEquals((Object)"Hello, World!\n", (Object)out.toString());
        ciphertextIn = new ByteArrayInputStream(MSG.getBytes());
        decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)ciphertextIn).withOptions(ConsumerOptions.get().addCustomDecryptorFactory((CustomPublicKeyDataDecryptorFactory)cachingFactory));
        out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertEquals((Object)"Hello, World!\n", (Object)out.toString());
        cachingFactory.clear();
    }
}

