/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.Trustworthiness;

public class TrustworthinessTest {
    @Test
    public void fullyTrustedIntroducer() {
        Trustworthiness it = Trustworthiness.fullyTrusted().introducer();
        Assertions.assertTrue((boolean)it.isFullyTrusted());
        Assertions.assertFalse((boolean)it.isNotTrusted());
        Assertions.assertTrue((boolean)it.isIntroducer());
        Assertions.assertFalse((boolean)it.canIntroduce(it));
    }

    @Test
    public void marginallyTrustedIntroducer() {
        Trustworthiness it = Trustworthiness.marginallyTrusted().introducer();
        Assertions.assertFalse((boolean)it.isFullyTrusted());
        Assertions.assertTrue((boolean)it.isMarginallyTrusted());
        Assertions.assertFalse((boolean)it.isNotTrusted());
        Assertions.assertTrue((boolean)it.isIntroducer());
        Assertions.assertFalse((boolean)it.canIntroduce(2));
    }

    @Test
    public void nonTrustedIntroducer() {
        Trustworthiness it = Trustworthiness.untrusted().introducer();
        Assertions.assertTrue((boolean)it.isNotTrusted());
        Assertions.assertFalse((boolean)it.isMarginallyTrusted());
        Assertions.assertFalse((boolean)it.isFullyTrusted());
        Assertions.assertTrue((boolean)it.isIntroducer());
    }

    @Test
    public void trustedMetaIntroducer() {
        Trustworthiness it = Trustworthiness.fullyTrusted().metaIntroducer();
        Assertions.assertTrue((boolean)it.isFullyTrusted());
        Assertions.assertTrue((boolean)it.isIntroducer());
        Trustworthiness that = Trustworthiness.fullyTrusted().introducer();
        Assertions.assertTrue((boolean)it.canIntroduce(that));
        Assertions.assertFalse((boolean)that.canIntroduce(it));
    }

    @Test
    public void invalidArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Trustworthiness(300, 1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Trustworthiness(60, 300));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Trustworthiness(-4, 1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Trustworthiness(120, -1));
    }

    @Test
    public void inBetweenValues() {
        Trustworthiness it = new Trustworthiness(30, 1);
        Assertions.assertTrue((boolean)it.isMarginallyTrusted());
        Assertions.assertFalse((boolean)it.isFullyTrusted());
        it = new Trustworthiness(140, 1);
        Assertions.assertTrue((boolean)it.isFullyTrusted());
    }

    @Test
    public void depthHierarchyTest() {
        Trustworthiness l1 = Trustworthiness.fullyTrusted().metaIntroducerOfDepth(1);
        Trustworthiness l2 = Trustworthiness.fullyTrusted().metaIntroducerOfDepth(2);
        Trustworthiness l3 = Trustworthiness.fullyTrusted().metaIntroducerOfDepth(3);
        Assertions.assertTrue((boolean)l3.canIntroduce(l2));
        Assertions.assertTrue((boolean)l3.canIntroduce(l1));
        Assertions.assertTrue((boolean)l2.canIntroduce(l1));
        Assertions.assertFalse((boolean)l1.canIntroduce(l2));
        Assertions.assertFalse((boolean)l1.canIntroduce(l3));
    }
}

