/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;

public class AsciiArmorTest {
    @Test
    public void testCustomAsciiArmorComments() throws PGPException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.noEncryptionNoSigning().setAsciiArmor(true).setComment("This is a comment.\nThis is another comment."));
        encryptionStream.write("Hello, World!".getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        String asciiArmored = out.toString();
        Assertions.assertTrue((boolean)asciiArmored.contains("Comment: This is a comment."));
        Assertions.assertTrue((boolean)asciiArmored.contains("Comment: This is another comment."));
    }

    @Test
    public void testCustomAsciiArmorVersion() throws IOException, PGPException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.noEncryptionNoSigning().setAsciiArmor(true).setVersion("Custom-PGP 1.2.3"));
        encryptionStream.write("Hello, World!".getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        String asciiArmored = out.toString();
        Assertions.assertTrue((boolean)asciiArmored.contains("Version: Custom-PGP 1.2.3"));
    }
}

