/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV6Fingerprint;

public class OpenPgpV6FingerprintTest {
    @Test
    public void testFingerprintFormatting() {
        String pretty = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        String fp = pretty.replace(" ", "");
        OpenPgpV6Fingerprint fingerprint = new OpenPgpV6Fingerprint(fp);
        Assertions.assertEquals((Object)fp, (Object)fingerprint.toString());
        Assertions.assertEquals((Object)pretty, (Object)fingerprint.prettyPrint());
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        long id = fingerprint.getKeyId();
        Assertions.assertEquals((Object)"76543210abcdefab", (Object)Long.toHexString(id));
    }

    @Test
    public void testParseFromBinary_leadingZeros() {
        String hex = "000000000000000001AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        byte[] binary = Hex.decode((String)hex);
        OpenPgpV6Fingerprint fingerprint = new OpenPgpV6Fingerprint(binary);
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void testParseFromBinary_trailingZeros() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA100000000000000000";
        byte[] binary = Hex.decode((String)hex);
        OpenPgpV6Fingerprint fingerprint = new OpenPgpV6Fingerprint(binary);
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void testParseFromBinary_wrongLength() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA012345";
        byte[] binary = Hex.decode((String)hex);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new OpenPgpV6Fingerprint(binary));
    }

    @Test
    public void equalsTest() {
        String prettyPrint = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        OpenPgpV6Fingerprint parsed = new OpenPgpV6Fingerprint(prettyPrint);
        Assertions.assertNotEquals((Object)parsed, null);
        Assertions.assertNotEquals((Object)parsed, (Object)new Object());
        Assertions.assertEquals((Object)parsed, (Object)parsed.toString());
        OpenPgpV6Fingerprint parsed2 = new OpenPgpV6Fingerprint(prettyPrint);
        Assertions.assertEquals((int)parsed.hashCode(), (int)parsed2.hashCode());
        Assertions.assertEquals((int)0, (int)parsed.compareTo((Object)parsed2));
    }

    @Test
    public void constructFromMockedPublicKey() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        PGPPublicKey publicKey = this.getMockedPublicKey(hex);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPPublicKey)publicKey);
        Assertions.assertTrue((boolean)(fingerprint instanceof OpenPgpV6Fingerprint));
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void constructFromMockedSecretKey() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        PGPPublicKey publicKey = this.getMockedPublicKey(hex);
        PGPSecretKey secretKey = (PGPSecretKey)Mockito.mock(PGPSecretKey.class);
        Mockito.when((Object)secretKey.getPublicKey()).thenReturn((Object)publicKey);
        OpenPgpV6Fingerprint fingerprint = new OpenPgpV6Fingerprint(secretKey);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void constructFromMockedPublicKeyRing() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        PGPPublicKey publicKey = this.getMockedPublicKey(hex);
        PGPPublicKeyRing publicKeys = (PGPPublicKeyRing)Mockito.mock(PGPPublicKeyRing.class);
        Mockito.when((Object)publicKeys.getPublicKey()).thenReturn((Object)publicKey);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)publicKeys);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
        fingerprint = new OpenPgpV6Fingerprint(publicKeys);
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void constructFromMockedSecretKeyRing() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        PGPPublicKey publicKey = this.getMockedPublicKey(hex);
        PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)Mockito.mock(PGPSecretKeyRing.class);
        Mockito.when((Object)secretKeys.getPublicKey()).thenReturn((Object)publicKey);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)secretKeys);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
        fingerprint = new OpenPgpV6Fingerprint(secretKeys);
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void constructFromMockedKeyRing() {
        String hex = "76543210ABCDEFAB01AB23CD1C0FFEE11EEFF0C1DC32BA10BAFEDCBA01234567";
        PGPPublicKey publicKey = this.getMockedPublicKey(hex);
        PGPKeyRing keys = (PGPKeyRing)Mockito.mock(PGPKeyRing.class);
        Mockito.when((Object)keys.getPublicKey()).thenReturn((Object)publicKey);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)keys);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
        fingerprint = new OpenPgpV6Fingerprint(keys);
        Assertions.assertEquals((Object)hex, (Object)fingerprint.toString());
    }

    @Test
    public void fromSampleV6Certificate() throws IOException {
        String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nxioGY4d/4xsAAAAg+U2nu0jWCmHlZ3BqZYfQMxmZu52JGggkLq2EVD34laPCsQYf\nGwoAAABCBYJjh3/jAwsJBwUVCg4IDAIWAAKbAwIeCSIhBssYbE8GCaaX5NUt+mxy\nKwwfHifBilZwj2Ul7Ce62azJBScJAgcCAAAAAK0oIBA+LX0ifsDm185Ecds2v8lw\ngyU2kCcUmKfvBXbAf6rhRYWzuQOwEn7E/aLwIwRaLsdry0+VcallHhSu4RN6HWaE\nQsiPlR4zxP/TP7mhfVEe7XWPxtnMUMtf15OyA51YBM4qBmOHf+MZAAAAIIaTJINn\n+eUBXbki+PSAld2nhJh/LVmFsS+60WyvXkQ1wpsGGBsKAAAALAWCY4d/4wKbDCIh\nBssYbE8GCaaX5NUt+mxyKwwfHifBilZwj2Ul7Ce62azJAAAAAAQBIKbpGG2dWTX8\nj+VjFM21J0hqWlEg+bdiojWnKfA5AQpWUWtnNwDEM0g12vYxoWM8Y81W+bHBw805\nI8kWVkXU6vFOi+HWvv/ira7ofJu16NnoUkhclkUrk0mXubZvyl4GBg==\n-----END PGP PUBLIC KEY BLOCK-----";
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(CERT);
        Assertions.assertNotNull((Object)cert);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)cert);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"CB186C4F0609A697E4D52DFA6C722B0C1F1E27C18A56708F6525EC27BAD9ACC9", (Object)fingerprint.toString());
        Iterator keys = cert.getPublicKeys();
        fingerprint = OpenPgpFingerprint.of((PGPPublicKey)((PGPPublicKey)keys.next()));
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"CB186C4F0609A697E4D52DFA6C722B0C1F1E27C18A56708F6525EC27BAD9ACC9", (Object)fingerprint.toString());
        fingerprint = OpenPgpFingerprint.of((PGPPublicKey)((PGPPublicKey)keys.next()));
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"12C83F1E706F6308FE151A417743A1F033790E93E9978488D1DB378DA9930885", (Object)fingerprint.toString());
    }

    @Test
    public void fromSampleV6SecretKey() throws IOException {
        String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nxUsGY4d/4xsAAAAg+U2nu0jWCmHlZ3BqZYfQMxmZu52JGggkLq2EVD34laMAGXKB\nexK+cH6NX1hs5hNhIB00TrJmosgv3mg1ditlsLfCsQYfGwoAAABCBYJjh3/jAwsJ\nBwUVCg4IDAIWAAKbAwIeCSIhBssYbE8GCaaX5NUt+mxyKwwfHifBilZwj2Ul7Ce6\n2azJBScJAgcCAAAAAK0oIBA+LX0ifsDm185Ecds2v8lwgyU2kCcUmKfvBXbAf6rh\nRYWzuQOwEn7E/aLwIwRaLsdry0+VcallHhSu4RN6HWaEQsiPlR4zxP/TP7mhfVEe\n7XWPxtnMUMtf15OyA51YBMdLBmOHf+MZAAAAIIaTJINn+eUBXbki+PSAld2nhJh/\nLVmFsS+60WyvXkQ1AE1gCk95TUR3XFeibg/u/tVY6a//1q0NWC1X+yui3O24wpsG\nGBsKAAAALAWCY4d/4wKbDCIhBssYbE8GCaaX5NUt+mxyKwwfHifBilZwj2Ul7Ce6\n2azJAAAAAAQBIKbpGG2dWTX8j+VjFM21J0hqWlEg+bdiojWnKfA5AQpWUWtnNwDE\nM0g12vYxoWM8Y81W+bHBw805I8kWVkXU6vFOi+HWvv/ira7ofJu16NnoUkhclkUr\nk0mXubZvyl4GBg==\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        Assertions.assertNotNull((Object)secretKeys);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)secretKeys);
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"CB186C4F0609A697E4D52DFA6C722B0C1F1E27C18A56708F6525EC27BAD9ACC9", (Object)fingerprint.toString());
        Iterator keys = secretKeys.getSecretKeys();
        fingerprint = OpenPgpFingerprint.of((PGPSecretKey)((PGPSecretKey)keys.next()));
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"CB186C4F0609A697E4D52DFA6C722B0C1F1E27C18A56708F6525EC27BAD9ACC9", (Object)fingerprint.toString());
        fingerprint = OpenPgpFingerprint.of((PGPSecretKey)((PGPSecretKey)keys.next()));
        Assertions.assertEquals((int)6, (int)fingerprint.getVersion());
        Assertions.assertEquals((Object)"12C83F1E706F6308FE151A417743A1F033790E93E9978488D1DB378DA9930885", (Object)fingerprint.toString());
    }

    private PGPPublicKey getMockedPublicKey(String hex) {
        byte[] binary = Hex.decode((String)hex);
        PGPPublicKey mocked = (PGPPublicKey)Mockito.mock(PGPPublicKey.class);
        Mockito.when((Object)mocked.getVersion()).thenReturn((Object)6);
        Mockito.when((Object)mocked.getFingerprint()).thenReturn((Object)binary);
        return mocked;
    }
}

