/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.io.IOException;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.UniversalSignatureBuilder;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

public class UniversalSignatureBuilderTest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 9611 510F 313E DBC2 BBBC  DC24 3BAD F1F8 3E70 DC34\nComment: Signora Universa <signora@pgpainless.org>\n\nlFgEY4DKKRYJKwYBBAHaRw8BAQdA65vJxvvLASI/gczDP8ZKH4C+16MLU7F5iP91\n8WWUqM0AAQCRSTHLLQWT9tuNRgkG3xaIiBGkEGD7Ou/R3oga6tc1MA8UtClTaWdu\nb3JhIFVuaXZlcnNhIDxzaWdub3JhQHBncGFpbmxlc3Mub3JnPoiPBBMWCgBBBQJj\ngMopCRA7rfH4PnDcNBYhBJYRUQ8xPtvCu7zcJDut8fg+cNw0Ap4BApsBBRYCAwEA\nBAsJCAcFFQoJCAsCmQEAAOgMAPwIOXWt3EBBusK5Ps3m7p/5HsecZv3IXtscEQBx\nvKlULwD/YuLP1XJSqcE2cQJRNt6OLi9Nt02MKBYkhWrRCYZAcQicXQRjgMopEgor\nBgEEAZdVAQUBAQdAWTstuhvHwmSXaQ4Vh8yxl0DZcvjrWkZI+n9/uFBxEmoDAQgH\nAAD/eRt6kgOMzWsTuM00am4UhSygxmDt7h6JkBTnpyyhK0gPiYh1BBgWCgAdBQJj\ngMopAp4BApsMBRYCAwEABAsJCAcFFQoJCAsACgkQO63x+D5w3DRnZAEA6GlS9Tw8\n9SJlUvh5aciYSlQUplnEdng+Pvzbj74zcXIA/2OkyMN428ddNhkHWWkZCMOxApum\n/zNDSYMwvByQ2KcFnFgEY4DKKRYJKwYBBAHaRw8BAQdAfhPrtVuG3g/zXF51VrPv\nkpQQk9aqjrkBMI0qlztBpu0AAP9Mw7NCsAVwg9CgmSzG2ATIDp3yf/4BGVYDs7qu\n+sbn7xKIiNUEGBYKAH0FAmOAyikCngECmwIFFgIDAQAECwkIBwUVCgkIC18gBBkW\nCgAGBQJjgMopAAoJENmzwZA/hq5ZCqIBAMYeOnASBd+WWta7Teh3g7Bl7sFY42Qy\n0OnaSGk/pLm9AP4yC62Xpb9DhWeiQIOY7k5n4lhNn173IfzDK6KXzBKkBgAKCRA7\nrfH4PnDcNMInAP4oanG9tbuczBNLN3JY4Hg4AaB+w5kfdOJxKwnAw7U0cgEAtasg\n67qSjHvsEvjNKeXzUm+db7NWP3fpIHxAmjWVjwM=\n=Dqbd\n-----END PGP PRIVATE KEY BLOCK-----";
    private PGPSecretKeyRing secretKeys;
    private final SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();

    @BeforeEach
    public void parseKey() throws IOException {
        this.secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
    }

    @Test
    public void createPetNameSignature() throws PGPException {
        PGPSecretKey signingKey = this.secretKeys.getSecretKey();
        PGPSignature archetype = (PGPSignature)signingKey.getPublicKey().getSignatures().next();
        UniversalSignatureBuilder builder = new UniversalSignatureBuilder(signingKey, this.protector, archetype);
        builder.applyCallback(new SignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setExportable(true, false);
                hashedSubpackets.setPrimaryUserId(new PrimaryUserID(false, false));
            }
        });
        PGPSignatureGenerator generator = builder.getSignatureGenerator();
        String petName = "mykey";
        PGPSignature petNameSig = generator.generateCertification(petName, this.secretKeys.getPublicKey());
        Assertions.assertEquals((int)SignatureType.POSITIVE_CERTIFICATION.getCode(), (int)petNameSig.getSignatureType());
        Assertions.assertEquals((int)4, (int)petNameSig.getVersion());
        Assertions.assertEquals((long)signingKey.getKeyID(), (long)petNameSig.getKeyID());
        Assertions.assertEquals((int)HashAlgorithm.SHA512.getAlgorithmId(), (int)petNameSig.getHashAlgorithm());
        Assertions.assertEquals((int)KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}), (int)petNameSig.getHashedSubPackets().getKeyFlags());
        Assertions.assertFalse((boolean)petNameSig.getHashedSubPackets().isExportable());
        Assertions.assertFalse((boolean)petNameSig.getHashedSubPackets().isPrimaryUserID());
    }
}

