/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingBcPublicKeyDataDecryptorFactory
extends CustomPublicKeyDataDecryptorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingBcPublicKeyDataDecryptorFactory.class);
    private final BcPublicKeyDataDecryptorFactory decryptorFactory;
    private final Map<String, byte[]> cachedSessionKeys = new HashMap<String, byte[]>();
    private final SubkeyIdentifier decryptionKey;

    public CachingBcPublicKeyDataDecryptorFactory(PGPPrivateKey privateKey, SubkeyIdentifier decryptionKey) {
        this.decryptorFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
        this.decryptionKey = decryptionKey;
    }

    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) throws PGPException {
        byte[] sessionKey = this.lookupSessionKeyData(secKeyData);
        if (sessionKey == null) {
            LOGGER.debug("Cache miss for encrypted session key " + Hex.toHexString((byte[])secKeyData[0]));
            sessionKey = this.costlyRecoverSessionData(keyAlgorithm, secKeyData, pkeskVersion);
            this.cacheSessionKeyData(secKeyData, sessionKey);
        } else {
            LOGGER.debug("Cache hit for encrypted session key " + Hex.toHexString((byte[])secKeyData[0]));
        }
        return sessionKey;
    }

    public byte[] costlyRecoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) throws PGPException {
        return this.decryptorFactory.recoverSessionData(keyAlgorithm, secKeyData, pkeskVersion);
    }

    private byte[] lookupSessionKeyData(byte[][] secKeyData) {
        String key = CachingBcPublicKeyDataDecryptorFactory.toKey(secKeyData);
        byte[] sessionKey = this.cachedSessionKeys.get(key);
        return CachingBcPublicKeyDataDecryptorFactory.copy(sessionKey);
    }

    private void cacheSessionKeyData(byte[][] secKeyData, byte[] sessionKey) {
        String key = CachingBcPublicKeyDataDecryptorFactory.toKey(secKeyData);
        this.cachedSessionKeys.put(key, CachingBcPublicKeyDataDecryptorFactory.copy(sessionKey));
    }

    private static String toKey(byte[][] secKeyData) {
        byte[] sk = secKeyData[0];
        String key = Base64.toBase64String((byte[])sk);
        return key;
    }

    private static byte[] copy(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] copy = new byte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, copy.length);
        return copy;
    }

    public void clear() {
        this.cachedSessionKeys.clear();
    }

    @Override
    public SubkeyIdentifier getSubkeyIdentifier() {
        return this.decryptionKey;
    }

    public PGPDataDecryptor createDataDecryptor(boolean b, int i, byte[] bytes) throws PGPException {
        return this.decryptorFactory.createDataDecryptor(b, i, bytes);
    }

    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey pgpSessionKey) throws PGPException {
        return this.decryptorFactory.createDataDecryptor(aeadEncDataPacket, pgpSessionKey);
    }

    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pgpSessionKey) throws PGPException {
        return this.decryptorFactory.createDataDecryptor(symmetricEncIntegrityPacket, pgpSessionKey);
    }
}

