/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/bouncycastle/extensions/PGPKeyRingExtensionsTest;", "", "()V", "public key ring has public key", "", "secret key ring has public key", "test requirePublicKey on public key ring", "test requirePublicKey on secret key ring", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPKeyRingExtensionsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPKeyRingExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPKeyRingExtensionsTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,57:1\n100#2,7:58\n100#2,7:65\n100#2,7:72\n100#2,7:79\n*S KotlinDebug\n*F\n+ 1 PGPKeyRingExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPKeyRingExtensionsTest\n*L\n43#1:58,7\n44#1:65,7\n53#1:72,7\n54#1:79,7\n*E\n"})
public final class PGPKeyRingExtensionsTest {
    @Test
    public final void public key ring has public key() {
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        Assertions.assertTrue((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)((PGPKeyRing)key), (long)-5425419407118114754L));
        PGPKeyRing pGPKeyRing = (PGPKeyRing)key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.JULIET_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"JULIET_FINGERPRINT");
        Assertions.assertTrue((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint)));
        Assertions.assertFalse((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)((PGPKeyRing)key), (long)334147643349279223L));
        PGPKeyRing pGPKeyRing2 = (PGPKeyRing)key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint2 = TestKeys.ROMEO_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint2, (String)"ROMEO_FINGERPRINT");
        Assertions.assertFalse((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)pGPKeyRing2, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint2)));
    }

    @Test
    public final void secret key ring has public key() {
        PGPSecretKeyRing key = TestKeys.getJulietSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        Assertions.assertTrue((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)((PGPKeyRing)key), (long)-5425419407118114754L));
        PGPKeyRing pGPKeyRing = (PGPKeyRing)key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.JULIET_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"JULIET_FINGERPRINT");
        Assertions.assertTrue((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint)));
        Assertions.assertFalse((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)((PGPKeyRing)key), (long)334147643349279223L));
        PGPKeyRing pGPKeyRing2 = (PGPKeyRing)key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint2 = TestKeys.ROMEO_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint2, (String)"ROMEO_FINGERPRINT");
        Assertions.assertFalse((boolean)PGPKeyRingExtensionsKt.hasPublicKey((PGPKeyRing)pGPKeyRing2, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint2)));
    }

    @Test
    public final void test requirePublicKey on secret key ring() {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on secret key ring$52;
        PGPSecretKeyRing key = TestKeys.getJulietSecretKeyRing();
        Assertions.assertDoesNotThrow(() -> PGPKeyRingExtensionsTest.test_requirePublicKey_on_secret_key_ring$lambda$0(key));
        Assertions.assertNotNull((Object)Unit.INSTANCE);
        Assertions.assertDoesNotThrow(() -> PGPKeyRingExtensionsTest.test_requirePublicKey_on_secret_key_ring$lambda$1(key));
        Assertions.assertNotNull((Object)Unit.INSTANCE);
        boolean $i$f$assertThrows = false;
        try {
            boolean $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on secret key ring$52 = false;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)((PGPKeyRing)key), (long)334147643349279223L);
            $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on secret key ring$52 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on secret key ring$52 = caught$iv;
        }
        if (!((throwable3 = $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on secret key ring$52) instanceof Throwable)) {
            throwable3 = null;
        }
        Throwable throwable$iv = throwable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            PGPKeyRing pGPKeyRing = (PGPKeyRing)key;
            OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.ROMEO_FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"ROMEO_FINGERPRINT");
            PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint));
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void test requirePublicKey on public key ring() {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on public key ring$52;
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        Assertions.assertDoesNotThrow(() -> PGPKeyRingExtensionsTest.test_requirePublicKey_on_public_key_ring$lambda$4(key));
        Assertions.assertNotNull((Object)Unit.INSTANCE);
        Assertions.assertDoesNotThrow(() -> PGPKeyRingExtensionsTest.test_requirePublicKey_on_public_key_ring$lambda$5(key));
        Assertions.assertNotNull((Object)Unit.INSTANCE);
        boolean $i$f$assertThrows = false;
        try {
            boolean $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on public key ring$52 = false;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)((PGPKeyRing)key), (long)334147643349279223L);
            $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on public key ring$52 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on public key ring$52 = caught$iv;
        }
        if (!((throwable3 = $i$a$-assertThrows-PGPKeyRingExtensionsTest$test requirePublicKey on public key ring$52) instanceof Throwable)) {
            throwable3 = null;
        }
        Throwable throwable$iv = throwable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            PGPKeyRing pGPKeyRing = (PGPKeyRing)key;
            OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.ROMEO_FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"ROMEO_FINGERPRINT");
            PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint));
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    private static final void test_requirePublicKey_on_secret_key_ring$lambda$0(PGPSecretKeyRing $key) {
        Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
        PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)((PGPKeyRing)$key), (long)-5425419407118114754L);
    }

    private static final void test_requirePublicKey_on_secret_key_ring$lambda$1(PGPSecretKeyRing $key) {
        Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
        PGPKeyRing pGPKeyRing = (PGPKeyRing)$key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.JULIET_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"JULIET_FINGERPRINT");
        PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint));
    }

    private static final void test_requirePublicKey_on_public_key_ring$lambda$4(PGPPublicKeyRing $key) {
        Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
        PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)((PGPKeyRing)$key), (long)-5425419407118114754L);
    }

    private static final void test_requirePublicKey_on_public_key_ring$lambda$5(PGPPublicKeyRing $key) {
        Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
        PGPKeyRing pGPKeyRing = (PGPKeyRing)$key;
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.JULIET_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"JULIET_FINGERPRINT");
        PGPKeyRingExtensionsKt.requirePublicKey((PGPKeyRing)pGPKeyRing, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint));
    }
}

