/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.ArmorUtils;

public class Sign {
    private static PGPSecretKeyRing secretKey;
    private static SecretKeyRingProtector protector;

    @BeforeAll
    public static void prepare() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        secretKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Emilia Example <emilia@example.org>");
        protector = SecretKeyRingProtector.unprotectedKeys();
    }

    @Test
    public void inbandSignedMessage() throws PGPException, IOException {
        String message = "\"Derivative Works\" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.";
        ByteArrayInputStream messageIn = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream signedOut = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signedOut).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addSignature(protector, secretKey)));
        Streams.pipeAll((InputStream)messageIn, (OutputStream)signingStream);
        signingStream.close();
        String signedMessage = signedOut.toString();
        Assertions.assertTrue((boolean)signedMessage.startsWith("-----BEGIN PGP MESSAGE-----"));
        Assertions.assertTrue((boolean)signedMessage.endsWith("-----END PGP MESSAGE-----\n"));
        Assertions.assertFalse((boolean)signedMessage.contains("Derivative Works"));
    }

    @Test
    public void detachedSignedMessage() throws PGPException, IOException {
        String message = "\"Contribution\" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, \"submitted\" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as \"Not a Contribution.\"";
        ByteArrayInputStream messageIn = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream ignoreMe = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ignoreMe).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(protector, secretKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setAsciiArmor(false));
        Streams.pipeAll((InputStream)messageIn, (OutputStream)signingStream);
        signingStream.close();
        EncryptionResult result = signingStream.getResult();
        PGPPublicKey signingKey = (PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKey).getSigningSubkeys().get(0);
        PGPSignature signature = (PGPSignature)result.getDetachedSignatures().get((Object)new SubkeyIdentifier((PGPKeyRing)secretKey, signingKey.getKeyID())).iterator().next();
        String detachedSignature = ArmorUtils.toAsciiArmoredString((byte[])signature.getEncoded());
        Assertions.assertTrue((boolean)detachedSignature.startsWith("-----BEGIN PGP SIGNATURE-----"));
    }

    @Test
    public void cleartextSignedMessage() throws PGPException, IOException {
        String message = "Copyright [yyyy] [name of copyright owner]\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.";
        ByteArrayInputStream messageIn = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream signedOut = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signedOut).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(protector, secretKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setCleartextSigned());
        Streams.pipeAll((InputStream)messageIn, (OutputStream)signingStream);
        signingStream.close();
        String signedMessage = signedOut.toString();
        Assertions.assertTrue((boolean)signedMessage.startsWith("-----BEGIN PGP SIGNED MESSAGE-----"));
        Assertions.assertTrue((boolean)signedMessage.contains("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND"));
        Assertions.assertTrue((boolean)signedMessage.endsWith("-----END PGP SIGNATURE-----\n"));
    }
}

