/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.KeyWithUnknownSecretKeyEncryptionMethodTest;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/pgpainless/key/KeyWithUnknownSecretKeyEncryptionMethodTest;", "", "()V", "KEY", "", "getKEY", "()Ljava/lang/String;", "testExtractCertificate", "", "pgpainless-core"})
public final class KeyWithUnknownSecretKeyEncryptionMethodTest {
    @NotNull
    private final String KEY;

    public KeyWithUnknownSecretKeyEncryptionMethodTest() {
        this.KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nxTQEZgWtcxYJKwYBBAHaRw8BAQdAlLK6UPQsVHR2ETk1SwVIG3tBmpiEtikYYlCy\n1TIiqzb8zR08aGFyZHdhcmUtc2VjcmV0QGV4YW1wbGUub3JnPsKNBBAWCAA1AhkB\nBQJmBa1zAhsDCAsJCAcKDQwLBRUKCQgLAhYCFiEEXlP8Tur0WZR+f0I33/i9Uh4O\nHEkACgkQ3/i9Uh4OHEnryAD8CzH2ajJvASp46ApfI4pLPY57rjBX++d/2FQPRyqG\nHJUA/RLsNNgxiFYmK5cjtQe2/DgzWQ7R6PxPC6oa3XM7xPcCxzkEZgWtcxIKKwYB\nBAGXVQEFAQEHQE1YXOKeaklwG01Yab4xopP9wbu1E+pCrP1xQpiFZW5KAwEIB/zC\neAQYFggAIAUCZgWtcwIbDBYhBF5T/E7q9FmUfn9CN9/4vVIeDhxJAAoJEN/4vVIe\nDhxJVTgA/1WaFrKdP3AgL0Ffdooc5XXbjQsj0uHo6FZSHRI4pchMAQCyJnKQ3RvW\n/0gm41JCqImyg2fxWG4hY0N5Q7Rc6PyzDQ==\n=3w/O\n-----END PGP PRIVATE KEY BLOCK-----";
    }

    @NotNull
    public final String getKEY() {
        return this.KEY;
    }

    @Test
    @Disabled(value="Disabled since BC 1.77 chokes on the test key")
    public final void testExtractCertificate() {
        PGPSecretKeyRing pGPSecretKeyRing = PGPainless.Companion.readKeyRing().secretKeyRing(this.KEY);
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing);
        PGPSecretKeyRing key = pGPSecretKeyRing;
        PGPPublicKeyRing cert = PGPainless.Companion.extractCertificate(key);
        Assertions.assertNotNull((Object)cert);
        Iterator iterator = key.getSecretKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"key.secretKeys");
        Set set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)testExtractCertificate.1.INSTANCE));
        Iterator iterator2 = cert.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"cert.publicKeys");
        Assertions.assertEquals((Object)set, (Object)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator2), (Function1)testExtractCertificate.2.INSTANCE)));
    }
}

