/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.protection.SecretKeyRingProtector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/key/KeyWithoutSelfSigsTest;", "", "()V", "generateKey", "", "signAndVerify", "Companion", "pgpainless-core"})
public final class KeyWithoutSelfSigsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: DA3E CC77 1CD6 46F0 C6C4  4FDA 86A3 7B22 7802 2FC7\n\nlFgEZUuWuhYJKwYBBAHaRw8BAQdAuXfarON/+UG1qwhVy4/VCYuEb9iLFLb8KGQt\nKfX4Se0AAQDgqGHsb2M43F+6wK5Hla+oZzFkTUsBx8HMpRx2yeQT6hFAnFgEZUuW\nuhYJKwYBBAHaRw8BAQdAx0OHISLtekltdUVGGrG/Gs3asc/jG/nqCkBEZ5uyELwA\nAP0faf8bprP3fj248/NacfynKEVnjzc1gocfhGiWrnVgAxC1iNUEGBYKAH0FAmVL\nlroCngECmwIFFgIDAQAECwkIBwUVCgkIC18gBBkWCgAGBQJlS5a6AAoJED9gFx9r\nB25syqoA/0JR3Zcs6fHQ0jW7+u6330SD5h8WvG78IKsE6AfChBLXAP4hlXGidztq\n5sOHEQvXD2KPCHEJ6MuQ+rbNSSf0fQhgDwAKCRCGo3sieAIvxzmIAP9+9vRoevUM\nluQhZzQ7DgYqTCyNkeq2cpVgOfa0lyVDgwEApwrd5DlU3GorGHAQHFS6jhw1IOoG\nFGQ3zpWaOXd7XwKcXQRlS5a6EgorBgEEAZdVAQUBAQdAZIY7ISyNzp0oMoK0dgb8\ndX6t/i4Uh+l0jnxM0Z1dEB8DAQgHAAD/fhL5dzdJQ7hFhr78AmDEZKFE4txZFPvd\nZVFvIWTthFgQ5Ih1BBgWCgAdBQJlS5a6Ap4BApsMBRYCAwEABAsJCAcFFQoJCAsA\nCgkQhqN7IngCL8cIGgEAzydjTfKvdrTvzXXu97j8TAoOxk89QnLqsM6BU0VsVmkA\n/1IzH+PXgPPW9ff+elxTi2NWmK+P033P6i5b5Jdf41YD\n=GBVS\n-----END PGP PRIVATE KEY BLOCK-----";

    @Test
    public final void signAndVerify() {
        PGPSecretKeyRing key;
        PGPSecretKeyRing pGPSecretKeyRing = key = PGPainless.Companion.readKeyRing().secretKeyRing(KEY);
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing);
        PGPPublicKeyRing cert = PGPainless.Companion.extractCertificate(pGPSecretKeyRing);
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.Companion.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.Companion.signAndEncrypt(EncryptionOptions.Companion.encryptCommunications().addRecipient(cert), SigningOptions.Companion.get().addSignature((SecretKeyRingProtector)SecretKeyRingProtector.Companion.unprotectedKeys(), key)));
        String string = "Hello, World!\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        encryptionStream.write(byArray);
        encryptionStream.close();
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        DecryptionBuilder decryptionBuilder = PGPainless.Companion.decryptAndOrVerify();
        byte[] byArray2 = ciphertextOut.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"ciphertextOut.toByteArray()");
        byte[] byArray3 = byArray2;
        DecryptionStream decryptionStream = decryptionBuilder.onInputStream((InputStream)new ByteArrayInputStream(byArray3)).withOptions(ConsumerOptions.Companion.get().addVerificationCert(cert).addDecryptionKey(key, (SecretKeyRingProtector)SecretKeyRingProtector.Companion.unprotectedKeys()));
        Streams.pipeAll((InputStream)((InputStream)decryptionStream), (OutputStream)plaintextOut);
        decryptionStream.close();
    }

    public final void generateKey() {
        List list;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.SIGN_DATA};
        KeyRingBuilder keyRingBuilder = (KeyRingBuilder)((KeyRingBuilder)PGPainless.Companion.buildKeyRing().setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), new KeyFlag[0]))).addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS};
        PGPSecretKeyRing it = ((KeyRingBuilder)keyRingBuilder.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519), keyFlagArray))).build();
        boolean bl = false;
        PGPPublicKeyRing cert = null;
        cert = PGPainless.Companion.extractCertificate(it);
        List $this$generateKey_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        Iterator iterator = cert.getPublicKeys();
        PGPPublicKey primaryKey = (PGPPublicKey)iterator.next();
        $this$generateKey_u24lambda_u241_u24lambda_u240.add(PGPPublicKey.removeCertification((PGPPublicKey)primaryKey, (PGPSignature)((PGPSignature)primaryKey.getSignatures().next())));
        while (iterator.hasNext()) {
            $this$generateKey_u24lambda_u241_u24lambda_u240.add(iterator.next());
        }
        List list2 = CollectionsKt.build((List)list);
        cert = new PGPPublicKeyRing(list2);
        PGPSecretKeyRing key = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)it, (PGPPublicKeyRing)cert);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        System.out.println((Object)PGPainless.Companion.asciiArmor((PGPKeyRing)key));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/key/KeyWithoutSelfSigsTest$Companion;", "", "()V", "KEY", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

