/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.TestUtils;

public class TestKeysTest {
    private final PGPSecretKeyRing julietSecRing = TestKeys.getJulietSecretKeyRing();
    private final PGPSecretKeyRing romeoSecRing = TestKeys.getRomeoSecretKeyRing();
    private final PGPSecretKeyRing emilSecRing = TestKeys.getEmilSecretKeyRing();
    private final PGPPublicKeyRing julietPubRing = TestKeys.getJulietPublicKeyRing();
    private final PGPPublicKeyRing romeoPubRing = TestKeys.getRomeoPublicKeyRing();
    private final PGPPublicKeyRing emilPubRing = TestKeys.getEmilPublicKeyRing();

    @Test
    public void assertJulietsPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assertions.assertArrayEquals((byte[])this.julietSecRing.getPublicKey().getEncoded(), (byte[])this.julietPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertJulietsKeysIdEquals() {
        Assertions.assertEquals((long)-5425419407118114754L, (long)this.julietSecRing.getSecretKey().getKeyID());
        Assertions.assertEquals((long)-5425419407118114754L, (long)this.julietSecRing.getPublicKey().getKeyID());
        Assertions.assertEquals((long)-5425419407118114754L, (long)this.julietPubRing.getPublicKey().getKeyID());
    }

    @Test
    public void assertJulietsKeyUIDEquals() {
        Assertions.assertEquals((Object)"xmpp:juliet@capulet.lit", this.julietSecRing.getPublicKey().getUserIDs().next());
        Assertions.assertEquals((int)1, (int)TestUtils.getNumberOfItemsInIterator(this.julietSecRing.getPublicKey().getUserIDs()));
    }

    @Test
    public void assertJulietsKeyRingFingerprintMatches() {
        Assertions.assertEquals((Object)TestKeys.JULIET_FINGERPRINT, (Object)new OpenPgpV4Fingerprint((PGPKeyRing)this.julietSecRing));
    }

    @Test
    public void assertJulietsPublicKeyFingerprintMatchesHerSecretKeyFingerprint() {
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint(this.julietSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.julietSecRing.getSecretKey()));
    }

    @Test
    public void assertJulietsFingerprintGetKeyIdMatches() {
        Assertions.assertEquals((long)-5425419407118114754L, (long)TestKeys.JULIET_FINGERPRINT.getKeyId(), (String)"calling getKeyId() on juliet's fingerprint must return her key id.");
    }

    @Test
    public void assertRomeosPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assertions.assertArrayEquals((byte[])this.romeoSecRing.getPublicKey().getEncoded(), (byte[])this.romeoPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertRomeosKeyIdEquals() {
        Assertions.assertEquals((long)334147643349279223L, (long)this.romeoSecRing.getSecretKey().getKeyID(), (String)"Key ID of Romeo's secret key must match his key id.");
    }

    @Test
    public void assertRomeosKeyUIDMatches() {
        Assertions.assertEquals((Object)"xmpp:romeo@montague.lit", this.romeoSecRing.getPublicKey().getUserIDs().next());
    }

    @Test
    public void assertRomeosKeyRingFingerprintMatches() {
        Assertions.assertEquals((Object)TestKeys.ROMEO_FINGERPRINT, (Object)new OpenPgpV4Fingerprint((PGPKeyRing)this.romeoSecRing));
    }

    @Test
    public void assertRomeosPublicKeyFingerprintMatchesHisSecretKeyFingerprint() {
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint(this.romeoSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.romeoSecRing.getSecretKey()));
    }

    @Test
    public void assertRomesKeysFingerprintMatches() {
        Assertions.assertEquals((long)334147643349279223L, (long)TestKeys.ROMEO_FINGERPRINT.getKeyId());
    }

    @Test
    public void assertRomeosSecretKeyRingHasSamePublicKeyId() throws IOException {
        PGPPublicKeyRing julietsPublicKeys = TestKeys.getJulietPublicKeyRing();
        Assertions.assertEquals((long)this.julietSecRing.getPublicKey().getKeyID(), (long)julietsPublicKeys.getPublicKey().getKeyID());
    }

    @Test
    public void assertEmilsPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assertions.assertArrayEquals((byte[])this.emilSecRing.getPublicKey().getEncoded(), (byte[])this.emilPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertEmilsKeysIdEquals() {
        Assertions.assertEquals((long)6284463849526474508L, (long)this.emilSecRing.getSecretKey().getKeyID());
        Assertions.assertEquals((long)6284463849526474508L, (long)this.emilSecRing.getPublicKey().getKeyID());
        Assertions.assertEquals((long)6284463849526474508L, (long)this.emilPubRing.getPublicKey().getKeyID());
    }

    @Test
    public void assertEmilsKeyUIDEquals() {
        Assertions.assertEquals((Object)"<emil@email.user>", this.emilSecRing.getPublicKey().getUserIDs().next());
        Assertions.assertEquals((int)1, (int)TestUtils.getNumberOfItemsInIterator(this.emilSecRing.getPublicKey().getUserIDs()));
    }

    @Test
    public void assertEmilsKeyRingFingerprintMatches() {
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)new OpenPgpV4Fingerprint((PGPKeyRing)this.emilSecRing));
    }

    @Test
    public void assertEmilsPublicKeyFingerprintMatchesHerSecretKeyFingerprint() {
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint(this.emilSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.emilSecRing.getSecretKey()));
    }

    @Test
    public void assertEmilsFingerprintGetKeyIdMatches() {
        Assertions.assertEquals((long)6284463849526474508L, (long)TestKeys.EMIL_FINGERPRINT.getKeyId(), (String)"calling getKeyId() on emil's fingerprint must return her key id.");
    }
}

