/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.UserId;
import org.pgpainless.timeframe.TestTimeFrameProvider;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.TestAllImplementations;

public class GenerateKeyWithAdditionalUserIdTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        Date now = DateUtil.now();
        Date expiration = TestTimeFrameProvider.defaultExpirationForCreationDate(now);
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS}).setKeyCreationDate(now))).addUserId((CharSequence)UserId.onlyEmail((String)"primary@user.id")).addUserId((CharSequence)UserId.onlyEmail((String)"additional@user.id")).addUserId((CharSequence)UserId.onlyEmail((String)"additional2@user.id")).addUserId((CharSequence)"\ttrimThis@user.id     ").setExpirationDate(expiration).build();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        JUtils.assertDateEquals(expiration, PGPainless.inspectKeyRing((PGPKeyRing)publicKeys).getPrimaryKeyExpirationDate());
        Iterator userIds = publicKeys.getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"<primary@user.id>", userIds.next());
        Assertions.assertEquals((Object)"<additional@user.id>", userIds.next());
        Assertions.assertEquals((Object)"<additional2@user.id>", userIds.next());
        Assertions.assertEquals((Object)"trimThis@user.id", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
    }
}

