/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.policy.Policy;

public class GeneratingWeakKeyThrowsTest {
    @Test
    public void refuseToGenerateWeakPrimaryKeyTest() {
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._1024), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA})));
    }

    @Test
    public void refuseToAddWeakSubkeyDuringGenerationTest() {
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
        KeyRingBuilder kb = (KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> kb.addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._1024), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS})));
    }

    @Test
    public void allowToAddWeakKeysWithWeakPolicy() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        HashMap<PublicKeyAlgorithm, Integer> bitStrengths = new HashMap<PublicKeyAlgorithm, Integer>();
        bitStrengths.put(PublicKeyAlgorithm.RSA_GENERAL, 512);
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(new Policy.PublicKeyAlgorithmPolicy(bitStrengths));
        ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._1024), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)"Henry").build();
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
    }
}

