/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.util.Passphrase;

public class KeyGenerationSubpacketsTest {
    @Test
    public void verifyDefaultSubpacketsForUserIdSignatures() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        PGPSignature userIdSig = info.getLatestUserIdCertification((CharSequence)"Alice");
        Assertions.assertNotNull((Object)userIdSig);
        int keyFlags = userIdSig.getHashedSubPackets().getKeyFlags();
        int[] preferredHashAlgorithms = userIdSig.getHashedSubPackets().getPreferredHashAlgorithms();
        int[] preferredSymmetricAlgorithms = userIdSig.getHashedSubPackets().getPreferredSymmetricAlgorithms();
        int[] preferredCompressionAlgorithms = userIdSig.getHashedSubPackets().getPreferredCompressionAlgorithms();
        this.assureSignatureHasDefaultSubpackets(userIdSig, secretKeys, KeyFlag.CERTIFY_OTHER);
        Assertions.assertTrue((boolean)userIdSig.getHashedSubPackets().isPrimaryUserID());
        Assertions.assertEquals((Object)"Alice", (Object)info.getPrimaryUserId());
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Bob", new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setPrimaryUserId();
            }
        }, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"Alice", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        userIdSig = info.getLatestUserIdCertification((CharSequence)"Alice");
        Assertions.assertNotNull((Object)userIdSig);
        this.assureSignatureHasDefaultSubpackets(userIdSig, secretKeys, KeyFlag.CERTIFY_OTHER);
        Assertions.assertFalse((boolean)userIdSig.getHashedSubPackets().isPrimaryUserID());
        Assertions.assertEquals((int)keyFlags, (int)userIdSig.getHashedSubPackets().getKeyFlags());
        Assertions.assertArrayEquals((int[])preferredHashAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredHashAlgorithms());
        Assertions.assertArrayEquals((int[])preferredSymmetricAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredSymmetricAlgorithms());
        Assertions.assertArrayEquals((int[])preferredCompressionAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredCompressionAlgorithms());
        userIdSig = info.getLatestUserIdCertification((CharSequence)"Bob");
        Assertions.assertNotNull((Object)userIdSig);
        this.assureSignatureHasDefaultSubpackets(userIdSig, secretKeys, KeyFlag.CERTIFY_OTHER);
        Assertions.assertTrue((boolean)userIdSig.getHashedSubPackets().isPrimaryUserID());
        Assertions.assertArrayEquals((int[])preferredHashAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredHashAlgorithms());
        Assertions.assertArrayEquals((int[])preferredSymmetricAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredSymmetricAlgorithms());
        Assertions.assertArrayEquals((int[])preferredCompressionAlgorithms, (int[])userIdSig.getHashedSubPackets().getPreferredCompressionAlgorithms());
        Assertions.assertEquals((Object)"Bob", (Object)info.getPrimaryUserId());
        Date now = new Date();
        Date t1 = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t1).addUserId((CharSequence)"Alice", new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setPrimaryUserId();
                hashedSubpackets.setPreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.SHA1});
            }
        }, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t1);
        Assertions.assertEquals((Object)"Alice", (Object)info.getPrimaryUserId());
        Assertions.assertEquals(Collections.singleton(HashAlgorithm.SHA1), (Object)info.getPreferredHashAlgorithms((CharSequence)"Alice"));
    }

    @Test
    public void verifyDefaultSubpacketsForSubkeyBindingSignatures() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        List keysBefore = info.getPublicKeys();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addSubKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).build(), Passphrase.emptyPassphrase(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ArrayList keysAfter = new ArrayList(info.getPublicKeys());
        keysAfter.removeAll(keysBefore);
        Assertions.assertEquals((int)1, (int)keysAfter.size());
        PGPPublicKey newSigningKey = (PGPPublicKey)keysAfter.get(0);
        PGPSignature bindingSig = info.getCurrentSubkeyBindingSignature(newSigningKey.getKeyID());
        Assertions.assertNotNull((Object)bindingSig);
        this.assureSignatureHasDefaultSubpackets(bindingSig, secretKeys, KeyFlag.SIGN_DATA);
        Assertions.assertNotNull((Object)bindingSig.getHashedSubPackets().getEmbeddedSignatures().get(0));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addSubKey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).build(), Passphrase.emptyPassphrase(), new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setIssuerFingerprint((IssuerFingerprint)null);
            }
        }, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        keysAfter = new ArrayList(info.getPublicKeys());
        keysAfter.removeAll(keysBefore);
        keysAfter.remove(newSigningKey);
        Assertions.assertEquals((int)1, (int)keysAfter.size());
        PGPPublicKey newEncryptionKey = (PGPPublicKey)keysAfter.get(0);
        bindingSig = info.getCurrentSubkeyBindingSignature(newEncryptionKey.getKeyID());
        Assertions.assertNotNull((Object)bindingSig);
        Assertions.assertNull((Object)bindingSig.getHashedSubPackets().getIssuerFingerprint());
        Assertions.assertEquals((int)KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}), (int)bindingSig.getHashedSubPackets().getKeyFlags());
    }

    private void assureSignatureHasDefaultSubpackets(PGPSignature signature, PGPSecretKeyRing secretKeys, KeyFlag ... keyFlags) {
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        Assertions.assertNotNull((Object)hashedSubpackets.getIssuerFingerprint());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)hashedSubpackets.getIssuerKeyID());
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])hashedSubpackets.getIssuerFingerprint().getFingerprint());
        Assertions.assertEquals((int)hashedSubpackets.getKeyFlags(), (int)KeyFlag.toBitmask((KeyFlag[])keyFlags));
    }
}

