/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class UnlockSecretKeyTest {
    @Test
    public void testUnlockSecretKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeyRing = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"alice@wonderland.lit", "heureka!");
        PGPSecretKey secretKey = secretKeyRing.getSecretKey();
        SecretKeyRingProtector correctPassphrase = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"heureka!"));
        SecretKeyRingProtector incorrectPassphrase = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"bazinga!"));
        SecretKeyRingProtector emptyPassphrase = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.emptyPassphrase());
        Passphrase cleared = Passphrase.fromPassword((CharSequence)"cleared");
        cleared.clear();
        SecretKeyRingProtector invalidPassphrase = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)cleared);
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)correctPassphrase);
        Assertions.assertNotNull((Object)privateKey);
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)incorrectPassphrase));
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)emptyPassphrase));
        Assertions.assertThrows(IllegalStateException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)invalidPassphrase));
    }
}

