/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.provider;

import java.security.Provider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.provider.BouncyCastleProviderFactory;
import org.pgpainless.provider.ProviderFactory;

public class ProviderFactoryTest {
    private final ProviderFactory customProviderFactory = new ProviderFactory(){
        final Provider provider = new Provider("PL", 1.0, "PGPainlessTestProvider"){};

        protected Provider getSecurityProvider() {
            return this.provider;
        }
    };

    @Test
    public void providerFactoryDefaultIsBouncyCastleTest() {
        Assertions.assertEquals((Object)"BC", (Object)ProviderFactory.getProviderName());
    }

    @Test
    public void setCustomProviderTest() {
        ProviderFactory.setFactory((ProviderFactory)this.customProviderFactory);
        Assertions.assertEquals((Object)"PL", (Object)ProviderFactory.getProviderName());
    }

    @AfterEach
    public void resetToDefault() {
        ProviderFactory.setFactory((ProviderFactory)new BouncyCastleProviderFactory());
    }
}

