/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.CollectionUtils;

public class CollectionUtilsTest {
    @Test
    public void testConcat() {
        String a = "A";
        String[] bc = new String[]{"B", "C"};
        Object[] abc = CollectionUtils.concat(a, bc);
        Assertions.assertArrayEquals((Object[])new String[]{"A", "B", "C"}, (Object[])abc);
    }

    @Test
    public void testConcatWithEmptyArray() {
        String a = "A";
        String[] empty = new String[]{};
        Object[] concat = CollectionUtils.concat(a, empty);
        Assertions.assertArrayEquals((Object[])new String[]{"A"}, (Object[])concat);
    }

    @Test
    public void iteratorToListTest() {
        List<String> list = Arrays.asList("A", "B", "C");
        Iterator<String> iterator = list.iterator();
        List<String> listFromIterator = CollectionUtils.iteratorToList(iterator);
        Assertions.assertEquals(list, listFromIterator);
    }

    @Test
    public void iteratorToList_emptyIteratorTest() {
        Iterator iterator = Collections.emptyIterator();
        List listFromIterator = CollectionUtils.iteratorToList(iterator);
        Assertions.assertTrue((boolean)listFromIterator.isEmpty());
    }

    @Test
    public void containsTest() {
        String[] abc = new String[]{"A", "B", "C"};
        Assertions.assertTrue((boolean)CollectionUtils.contains(abc, "A"));
        Assertions.assertTrue((boolean)CollectionUtils.contains(abc, "B"));
        Assertions.assertTrue((boolean)CollectionUtils.contains(abc, "C"));
        Assertions.assertFalse((boolean)CollectionUtils.contains(abc, "D"));
    }

    @Test
    public void contains_emptyTest() {
        String[] empty = new String[]{};
        Assertions.assertFalse((boolean)CollectionUtils.contains(empty, "A"));
    }

    @Test
    public void addAllTest() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        ArrayList<String> other = new ArrayList<String>();
        other.add("C");
        other.add("D");
        Iterator iterator = other.iterator();
        CollectionUtils.addAll(iterator, list);
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), list);
    }

    @Test
    public void addAllEmptyListTest() {
        ArrayList empty = new ArrayList();
        List<String> other = Arrays.asList("A", "B", "C");
        Iterator<String> iterator = other.iterator();
        CollectionUtils.addAll(iterator, empty);
        Assertions.assertEquals(Arrays.asList("A", "B", "C"), empty);
    }

    @Test
    public void addAllEmptyIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        Iterator iterator = Collections.emptyIterator();
        CollectionUtils.addAll(iterator, list);
        Assertions.assertEquals(Arrays.asList("A", "B"), list);
    }
}

