/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.util.Date;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.DateExtensionsKt;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.RevocationState;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0011\u001a\u0014\u0010\u001a\u001a\u00020\u0006*\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u0011\u001a\u0012\u0010\u001c\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u001a\f\u0010\u001f\u001a\u00020 *\u0004\u0018\u00010\u0002\u001a\u0014\u0010!\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\"H\u0007\u001a\u0012\u0010!\u001a\u00020\u0006*\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010!\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "Lorg/bouncycastle/openpgp/PGPSignature;", "getFingerprint", "(Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/pgpainless/key/OpenPgpFingerprint;", "isHardRevocation", "", "(Lorg/bouncycastle/openpgp/PGPSignature;)Z", "issuerKeyId", "", "getIssuerKeyId", "(Lorg/bouncycastle/openpgp/PGPSignature;)J", "publicKeyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getPublicKeyAlgorithm", "(Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "signatureExpirationDate", "Ljava/util/Date;", "getSignatureExpirationDate", "(Lorg/bouncycastle/openpgp/PGPSignature;)Ljava/util/Date;", "signatureHashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "getSignatureHashAlgorithm", "(Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/pgpainless/algorithm/HashAlgorithm;", "getKeyExpirationDate", "keyCreationDate", "isExpired", "referenceTime", "isOfType", "type", "Lorg/pgpainless/algorithm/SignatureType;", "toRevocationState", "Lorg/pgpainless/algorithm/RevocationState;", "wasIssuedBy", "", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPSignatureExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPSignatureExtensions.kt\norg/pgpainless/bouncycastle/extensions/PGPSignatureExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class PGPSignatureExtensionsKt {
    @Nullable
    public static final Date getKeyExpirationDate(@NotNull PGPSignature $this$getKeyExpirationDate, @NotNull Date keyCreationDate) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$getKeyExpirationDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyCreationDate, (String)"keyCreationDate");
        KeyExpirationTime keyExpirationTime = SignatureSubpacketsUtil.Companion.getKeyExpirationTime($this$getKeyExpirationDate);
        if (keyExpirationTime != null) {
            KeyExpirationTime it = keyExpirationTime;
            boolean bl = false;
            date = DateExtensionsKt.plusSeconds(keyCreationDate, it.getTime());
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date getSignatureExpirationDate(@NotNull PGPSignature $this$signatureExpirationDate) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$signatureExpirationDate, (String)"<this>");
        SignatureExpirationTime signatureExpirationTime = SignatureSubpacketsUtil.Companion.getSignatureExpirationTime($this$signatureExpirationDate);
        if (signatureExpirationTime != null) {
            SignatureExpirationTime it = signatureExpirationTime;
            boolean bl = false;
            Date date2 = $this$signatureExpirationDate.getCreationTime();
            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"this.creationTime");
            date = DateExtensionsKt.plusSeconds(date2, it.getTime());
        } else {
            date = null;
        }
        return date;
    }

    public static final boolean isExpired(@NotNull PGPSignature $this$isExpired, @NotNull Date referenceTime) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isExpired, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        Date date = PGPSignatureExtensionsKt.getSignatureExpirationDate($this$isExpired);
        if (date != null) {
            Date it = date;
            boolean bl2 = false;
            bl = referenceTime.compareTo(it) >= 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean isExpired$default(PGPSignature pGPSignature, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return PGPSignatureExtensionsKt.isExpired(pGPSignature, date);
    }

    public static final long getIssuerKeyId(@NotNull PGPSignature $this$issuerKeyId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$issuerKeyId, (String)"<this>");
        switch ($this$issuerKeyId.getVersion()) {
            case 2: 
            case 3: {
                l = $this$issuerKeyId.getKeyID();
                break;
            }
            default: {
                Long l2 = SignatureSubpacketsUtil.Companion.getIssuerKeyIdAsLong($this$issuerKeyId);
                if (l2 != null) {
                    long it = ((Number)l2).longValue();
                    boolean bl = false;
                    Long l3 = it != 0L ? Long.valueOf(it) : null;
                    l2 = l3;
                    if (l3 != null) {
                        l = l2;
                        break;
                    }
                }
                OpenPgpFingerprint openPgpFingerprint = PGPSignatureExtensionsKt.getFingerprint($this$issuerKeyId);
                if (openPgpFingerprint != null) {
                    l = openPgpFingerprint.getKeyId();
                    break;
                }
                l = 0L;
            }
        }
        return l;
    }

    public static final boolean wasIssuedBy(@NotNull PGPSignature $this$wasIssuedBy, @NotNull OpenPgpFingerprint fingerprint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$wasIssuedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        OpenPgpFingerprint openPgpFingerprint = PGPSignatureExtensionsKt.getFingerprint($this$wasIssuedBy);
        if (openPgpFingerprint != null) {
            OpenPgpFingerprint it = openPgpFingerprint;
            boolean bl2 = false;
            bl = it.getKeyId() == fingerprint.getKeyId();
        } else {
            bl = $this$wasIssuedBy.getKeyID() == fingerprint.getKeyId();
        }
        return bl;
    }

    @Deprecated(message="Discouraged in favor of method taking an OpenPgpFingerprint.")
    public static final boolean wasIssuedBy(@NotNull PGPSignature $this$wasIssuedBy, @NotNull byte[] fingerprint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$wasIssuedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        try {
            bl = PGPSignatureExtensionsKt.wasIssuedBy($this$wasIssuedBy, OpenPgpFingerprint.Companion.parseFromBinary(fingerprint));
        }
        catch (IllegalArgumentException e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean wasIssuedBy(@NotNull PGPSignature $this$wasIssuedBy, @NotNull PGPPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$wasIssuedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return PGPSignatureExtensionsKt.wasIssuedBy($this$wasIssuedBy, OpenPgpFingerprint.Companion.of(key));
    }

    public static final boolean isHardRevocation(@NotNull PGPSignature $this$isHardRevocation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isHardRevocation, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[SignatureType.Companion.requireFromCode($this$isHardRevocation.getSignatureType()).ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                RevocationReason revocationReason = SignatureSubpacketsUtil.Companion.getRevocationReason($this$isHardRevocation);
                if (revocationReason != null) {
                    RevocationReason it = revocationReason;
                    boolean bl2 = false;
                    bl = RevocationAttributes.Reason.Companion.isHardRevocation(it.getRevocationReason());
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final RevocationState toRevocationState(@Nullable PGPSignature $this$toRevocationState) {
        RevocationState revocationState;
        if ($this$toRevocationState == null) {
            revocationState = RevocationState.Companion.notRevoked();
        } else if (PGPSignatureExtensionsKt.isHardRevocation($this$toRevocationState)) {
            revocationState = RevocationState.Companion.hardRevoked();
        } else {
            Date date = $this$toRevocationState.getCreationTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"creationTime");
            revocationState = RevocationState.Companion.softRevoked(date);
        }
        return revocationState;
    }

    @Nullable
    public static final OpenPgpFingerprint getFingerprint(@NotNull PGPSignature $this$fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$fingerprint, (String)"<this>");
        return SignatureSubpacketsUtil.Companion.getIssuerFingerprintAsOpenPgpFingerprint($this$fingerprint);
    }

    @NotNull
    public static final PublicKeyAlgorithm getPublicKeyAlgorithm(@NotNull PGPSignature $this$publicKeyAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$publicKeyAlgorithm, (String)"<this>");
        return PublicKeyAlgorithm.Companion.requireFromId($this$publicKeyAlgorithm.getKeyAlgorithm());
    }

    @NotNull
    public static final HashAlgorithm getSignatureHashAlgorithm(@NotNull PGPSignature $this$signatureHashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$signatureHashAlgorithm, (String)"<this>");
        return HashAlgorithm.Companion.requireFromId($this$signatureHashAlgorithm.getHashAlgorithm());
    }

    public static final boolean isOfType(@NotNull PGPSignature $this$isOfType, @NotNull SignatureType type) {
        Intrinsics.checkNotNullParameter((Object)$this$isOfType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return SignatureType.Companion.requireFromCode($this$isOfType.getSignatureType()) == type;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignatureType.values().length];
            try {
                nArray[SignatureType.KEY_REVOCATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignatureType.SUBKEY_REVOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignatureType.CERTIFICATION_REVOCATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

