/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.key.SubkeyIdentifier;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J%\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ%\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u001c\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/pgpainless/decryption_verification/CachingBcPublicKeyDataDecryptorFactory;", "Lorg/bouncycastle/openpgp/operator/bc/BcPublicKeyDataDecryptorFactory;", "Lorg/pgpainless/decryption_verification/CustomPublicKeyDataDecryptorFactory;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "subkeyIdentifier", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/bouncycastle/openpgp/PGPPrivateKey;Lorg/pgpainless/key/SubkeyIdentifier;)V", "cachedSessions", "", "", "", "getSubkeyIdentifier", "()Lorg/pgpainless/key/SubkeyIdentifier;", "cacheSessionKeyData", "", "secKeyData", "", "sessionKey", "([[B[B)V", "clear", "costlyRecoverSessionData", "keyAlgorithm", "", "(I[[B)[B", "lookupSessionKeyData", "([[B)[B", "recoverSessionData", "toKey", "([[B)Ljava/lang/String;", "pgpainless-core"})
public final class CachingBcPublicKeyDataDecryptorFactory
extends BcPublicKeyDataDecryptorFactory
implements CustomPublicKeyDataDecryptorFactory {
    @NotNull
    private final SubkeyIdentifier subkeyIdentifier;
    @NotNull
    private final Map<String, byte[]> cachedSessions;

    public CachingBcPublicKeyDataDecryptorFactory(@NotNull PGPPrivateKey privateKey, @NotNull SubkeyIdentifier subkeyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)subkeyIdentifier, (String)"subkeyIdentifier");
        super(privateKey);
        this.subkeyIdentifier = subkeyIdentifier;
        this.cachedSessions = new LinkedHashMap();
    }

    @Override
    @NotNull
    public SubkeyIdentifier getSubkeyIdentifier() {
        return this.subkeyIdentifier;
    }

    @NotNull
    public byte[] recoverSessionData(int keyAlgorithm, @NotNull byte[][] secKeyData) {
        Intrinsics.checkNotNullParameter((Object)secKeyData, (String)"secKeyData");
        byte[] byArray = this.lookupSessionKeyData(secKeyData);
        if (byArray == null) {
            byte[] byArray2;
            byte[] it = byArray2 = this.costlyRecoverSessionData(keyAlgorithm, secKeyData);
            boolean bl = false;
            this.cacheSessionKeyData(secKeyData, it);
            byArray = byArray2;
        }
        return byArray;
    }

    private final byte[] lookupSessionKeyData(byte[][] secKeyData) {
        byte[] byArray = this.cachedSessions.get(this.toKey(secKeyData));
        return (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    private final byte[] costlyRecoverSessionData(int keyAlgorithm, byte[][] secKeyData) {
        byte[] byArray = super.recoverSessionData(keyAlgorithm, secKeyData);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"super.recoverSessionData(keyAlgorithm, secKeyData)");
        return byArray;
    }

    private final void cacheSessionKeyData(byte[][] secKeyData, byte[] sessionKey) {
        this.cachedSessions.put(this.toKey(secKeyData), (byte[])sessionKey.clone());
    }

    private final String toKey(byte[][] secKeyData) {
        String string = Base64.toBase64String((byte[])secKeyData[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toBase64String(secKeyData[0])");
        return string;
    }

    public final void clear() {
        this.cachedSessions.clear();
    }
}

