/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0017\u0018\u0000 U2\u00020\u0001:\u0002TUB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u001a\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\n2\b\b\u0002\u0010(\u001a\u00020\u000bH\u0007J\u001a\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010(\u001a\u00020\u000bH\u0007J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000eH\u0007J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0010J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u0014\u00107\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100:J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0004J\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0?J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000e0?J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00100:J\b\u0010B\u001a\u0004\u0018\u00010\u0019J\u0006\u0010C\u001a\u00020\u001bJ\u0006\u0010D\u001a\u00020\u001dJ\u0010\u0010E\u001a\u0004\u0018\u00010\u000b2\u0006\u0010F\u001a\u00020\nJ\b\u0010G\u001a\u0004\u0018\u00010\u001fJ\b\u0010H\u001a\u0004\u0018\u00010!J\b\u0010I\u001a\u0004\u0018\u00010!J\u0006\u0010J\u001a\u00020\u0012J\u0006\u0010K\u001a\u00020\u0012J\u0010\u0010L\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0019J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u001bJ\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00002\b\u0010S\u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u00002\b\u0010S\u001a\u0004\u0018\u00010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions;", "", "()V", "certificates", "Lorg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource;", "customDecryptorFactories", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "decryptionKeys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "decryptionPassphrases", "", "Lorg/pgpainless/util/Passphrase;", "detachedSignatures", "Lorg/bouncycastle/openpgp/PGPSignature;", "forceNonOpenPgpData", "", "ignoreMDCErrors", "isDisableAsciiArmorCRC", "()Z", "setDisableAsciiArmorCRC", "(Z)V", "missingCertificateCallback", "Lorg/pgpainless/decryption_verification/MissingPublicKeyCallback;", "missingKeyPassphraseStrategy", "Lorg/pgpainless/decryption_verification/MissingKeyPassphraseStrategy;", "multiPassStrategy", "Lorg/pgpainless/decryption_verification/cleartext_signatures/MultiPassStrategy;", "sessionKey", "Lorg/pgpainless/util/SessionKey;", "verifyNotAfter", "Ljava/util/Date;", "verifyNotBefore", "addCustomDecryptorFactory", "factory", "Lorg/pgpainless/decryption_verification/CustomPublicKeyDataDecryptorFactory;", "addDecryptionKey", "key", "protector", "addDecryptionKeys", "keys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "addDecryptionPassphrase", "passphrase", "addMessagePassphrase", "addVerificationCert", "verificationCert", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "addVerificationCerts", "verificationCerts", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "addVerificationOfDetachedSignature", "detachedSignature", "addVerificationOfDetachedSignatures", "signatureInputStream", "Ljava/io/InputStream;", "", "getCertificateSource", "getCustomDecryptorFactories", "", "getDecryptionKeys", "", "getDecryptionPassphrases", "getDetachedSignatures", "getMissingCertificateCallback", "getMissingKeyPassphraseStrategy", "getMultiPassStrategy", "getSecretKeyProtector", "decryptionKeyRing", "getSessionKey", "getVerifyNotAfter", "getVerifyNotBefore", "isForceNonOpenPgpData", "isIgnoreMDCErrors", "setIgnoreMDCErrors", "setMissingCertificateCallback", "callback", "setMissingKeyPassphraseStrategy", "strategy", "setMultiPassStrategy", "setSessionKey", "timestamp", "CertificateSource", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nConsumerOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n1#2:422\n*E\n"})
public final class ConsumerOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean ignoreMDCErrors;
    private boolean isDisableAsciiArmorCRC;
    private boolean forceNonOpenPgpData;
    @Nullable
    private Date verifyNotBefore;
    @Nullable
    private Date verifyNotAfter = new Date();
    @NotNull
    private final CertificateSource certificates = new CertificateSource();
    @NotNull
    private final Set<PGPSignature> detachedSignatures = new LinkedHashSet();
    @Nullable
    private MissingPublicKeyCallback missingCertificateCallback;
    @Nullable
    private SessionKey sessionKey;
    @NotNull
    private final Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> customDecryptorFactories = new LinkedHashMap();
    @NotNull
    private final Map<PGPSecretKeyRing, SecretKeyRingProtector> decryptionKeys = new LinkedHashMap();
    @NotNull
    private final Set<Passphrase> decryptionPassphrases = new LinkedHashSet();
    @NotNull
    private MissingKeyPassphraseStrategy missingKeyPassphraseStrategy = MissingKeyPassphraseStrategy.INTERACTIVE;
    @NotNull
    private MultiPassStrategy multiPassStrategy = new InMemoryMultiPassStrategy();

    public final boolean isDisableAsciiArmorCRC() {
        return this.isDisableAsciiArmorCRC;
    }

    public final void setDisableAsciiArmorCRC(boolean bl) {
        this.isDisableAsciiArmorCRC = bl;
    }

    @NotNull
    public final ConsumerOptions verifyNotBefore(@Nullable Date timestamp) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$verifyNotBefore_u24lambda_u240 = consumerOptions = this;
        boolean bl = false;
        $this$verifyNotBefore_u24lambda_u240.verifyNotBefore = timestamp;
        return consumerOptions;
    }

    @Nullable
    public final Date getVerifyNotBefore() {
        return this.verifyNotBefore;
    }

    @NotNull
    public final ConsumerOptions verifyNotAfter(@Nullable Date timestamp) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$verifyNotAfter_u24lambda_u241 = consumerOptions = this;
        boolean bl = false;
        $this$verifyNotAfter_u24lambda_u241.verifyNotAfter = timestamp;
        return consumerOptions;
    }

    @Nullable
    public final Date getVerifyNotAfter() {
        return this.verifyNotAfter;
    }

    @NotNull
    public final ConsumerOptions addVerificationCert(@NotNull PGPPublicKeyRing verificationCert) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)verificationCert, (String)"verificationCert");
        ConsumerOptions $this$addVerificationCert_u24lambda_u242 = consumerOptions = this;
        boolean bl = false;
        $this$addVerificationCert_u24lambda_u242.certificates.addCertificate(verificationCert);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationCerts(@NotNull PGPPublicKeyRingCollection verificationCerts) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)verificationCerts, (String)"verificationCerts");
        ConsumerOptions $this$addVerificationCerts_u24lambda_u243 = consumerOptions = this;
        boolean bl = false;
        for (PGPPublicKeyRing cert : verificationCerts) {
            Intrinsics.checkNotNullExpressionValue((Object)cert, (String)"cert");
            $this$addVerificationCerts_u24lambda_u243.addVerificationCert(cert);
        }
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignatures(@NotNull InputStream signatureInputStream) throws IOException, PGPException {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)signatureInputStream, (String)"signatureInputStream");
        ConsumerOptions $this$addVerificationOfDetachedSignatures_u24lambda_u244 = consumerOptions = this;
        boolean bl = false;
        List<PGPSignature> signatures = SignatureUtils.Companion.readSignatures(signatureInputStream);
        $this$addVerificationOfDetachedSignatures_u24lambda_u244.addVerificationOfDetachedSignatures(signatures);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignatures(@NotNull List<? extends PGPSignature> detachedSignatures) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter(detachedSignatures, (String)"detachedSignatures");
        ConsumerOptions $this$addVerificationOfDetachedSignatures_u24lambda_u245 = consumerOptions = this;
        boolean bl = false;
        for (PGPSignature pGPSignature : detachedSignatures) {
            $this$addVerificationOfDetachedSignatures_u24lambda_u245.addVerificationOfDetachedSignature(pGPSignature);
        }
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignature(@NotNull PGPSignature detachedSignature) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)detachedSignature, (String)"detachedSignature");
        ConsumerOptions $this$addVerificationOfDetachedSignature_u24lambda_u246 = consumerOptions = this;
        boolean bl = false;
        $this$addVerificationOfDetachedSignature_u24lambda_u246.detachedSignatures.add(detachedSignature);
        return consumerOptions;
    }

    @NotNull
    public final List<PGPSignature> getDetachedSignatures() {
        return CollectionsKt.toList((Iterable)this.detachedSignatures);
    }

    @NotNull
    public final ConsumerOptions setMissingCertificateCallback(@NotNull MissingPublicKeyCallback callback2) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ConsumerOptions $this$setMissingCertificateCallback_u24lambda_u247 = consumerOptions = this;
        boolean bl = false;
        $this$setMissingCertificateCallback_u24lambda_u247.missingCertificateCallback = callback2;
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions setSessionKey(@NotNull SessionKey sessionKey) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        ConsumerOptions $this$setSessionKey_u24lambda_u248 = consumerOptions = this;
        boolean bl = false;
        $this$setSessionKey_u24lambda_u248.sessionKey = sessionKey;
        return consumerOptions;
    }

    @Nullable
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull PGPSecretKeyRing key, @NotNull SecretKeyRingProtector protector) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        ConsumerOptions $this$addDecryptionKey_u24lambda_u249 = consumerOptions = this;
        boolean bl = false;
        $this$addDecryptionKey_u24lambda_u249.decryptionKeys.put(key, protector);
        return consumerOptions;
    }

    public static /* synthetic */ ConsumerOptions addDecryptionKey$default(ConsumerOptions consumerOptions, PGPSecretKeyRing pGPSecretKeyRing, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) {
        if ((n & 2) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return consumerOptions.addDecryptionKey(pGPSecretKeyRing, secretKeyRingProtector);
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKeys(@NotNull PGPSecretKeyRingCollection keys, @NotNull SecretKeyRingProtector protector) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        ConsumerOptions $this$addDecryptionKeys_u24lambda_u2410 = consumerOptions = this;
        boolean bl = false;
        for (PGPSecretKeyRing key : keys) {
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            $this$addDecryptionKeys_u24lambda_u2410.addDecryptionKey(key, protector);
        }
        return consumerOptions;
    }

    public static /* synthetic */ ConsumerOptions addDecryptionKeys$default(ConsumerOptions consumerOptions, PGPSecretKeyRingCollection pGPSecretKeyRingCollection, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) {
        if ((n & 2) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return consumerOptions.addDecryptionKeys(pGPSecretKeyRingCollection, secretKeyRingProtector);
    }

    @Deprecated(message="Deprecated in favor of addMessagePassphrase", replaceWith=@ReplaceWith(expression="addMessagePassphrase(passphrase)", imports={}))
    @NotNull
    public final ConsumerOptions addDecryptionPassphrase(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.addMessagePassphrase(passphrase);
    }

    @NotNull
    public final ConsumerOptions addMessagePassphrase(@NotNull Passphrase passphrase) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        ConsumerOptions $this$addMessagePassphrase_u24lambda_u2411 = consumerOptions = this;
        boolean bl = false;
        $this$addMessagePassphrase_u24lambda_u2411.decryptionPassphrases.add(passphrase);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addCustomDecryptorFactory(@NotNull CustomPublicKeyDataDecryptorFactory factory) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        ConsumerOptions $this$addCustomDecryptorFactory_u24lambda_u2412 = consumerOptions = this;
        boolean bl = false;
        $this$addCustomDecryptorFactory_u24lambda_u2412.customDecryptorFactories.put(factory.getSubkeyIdentifier(), factory);
        return consumerOptions;
    }

    @NotNull
    public final Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> getCustomDecryptorFactories() {
        return MapsKt.toMap(this.customDecryptorFactories);
    }

    @NotNull
    public final Set<PGPSecretKeyRing> getDecryptionKeys() {
        return CollectionsKt.toSet((Iterable)this.decryptionKeys.keySet());
    }

    @NotNull
    public final Set<Passphrase> getDecryptionPassphrases() {
        return CollectionsKt.toSet((Iterable)this.decryptionPassphrases);
    }

    @NotNull
    public final CertificateSource getCertificateSource() {
        return this.certificates;
    }

    @Nullable
    public final MissingPublicKeyCallback getMissingCertificateCallback() {
        return this.missingCertificateCallback;
    }

    @Nullable
    public final SecretKeyRingProtector getSecretKeyProtector(@NotNull PGPSecretKeyRing decryptionKeyRing) {
        Intrinsics.checkNotNullParameter((Object)decryptionKeyRing, (String)"decryptionKeyRing");
        return this.decryptionKeys.get(decryptionKeyRing);
    }

    @Deprecated(message="Ignoring non-integrity-protected packets is discouraged.")
    @NotNull
    public final ConsumerOptions setIgnoreMDCErrors(boolean ignoreMDCErrors) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$setIgnoreMDCErrors_u24lambda_u2413 = consumerOptions = this;
        boolean bl = false;
        $this$setIgnoreMDCErrors_u24lambda_u2413.ignoreMDCErrors = ignoreMDCErrors;
        return consumerOptions;
    }

    public final boolean isIgnoreMDCErrors() {
        return this.ignoreMDCErrors;
    }

    @NotNull
    public final ConsumerOptions forceNonOpenPgpData() {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$forceNonOpenPgpData_u24lambda_u2414 = consumerOptions = this;
        boolean bl = false;
        $this$forceNonOpenPgpData_u24lambda_u2414.forceNonOpenPgpData = true;
        return consumerOptions;
    }

    public final boolean isForceNonOpenPgpData() {
        return this.forceNonOpenPgpData;
    }

    @NotNull
    public final ConsumerOptions setMissingKeyPassphraseStrategy(@NotNull MissingKeyPassphraseStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.missingKeyPassphraseStrategy = strategy;
        return this;
    }

    @NotNull
    public final MissingKeyPassphraseStrategy getMissingKeyPassphraseStrategy() {
        return this.missingKeyPassphraseStrategy;
    }

    @NotNull
    public final ConsumerOptions setMultiPassStrategy(@NotNull MultiPassStrategy multiPassStrategy) {
        Intrinsics.checkNotNullParameter((Object)multiPassStrategy, (String)"multiPassStrategy");
        this.multiPassStrategy = multiPassStrategy;
        return this;
    }

    @NotNull
    public final MultiPassStrategy getMultiPassStrategy() {
        return this.multiPassStrategy;
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull PGPSecretKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ConsumerOptions.addDecryptionKey$default(this, key, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKeys(@NotNull PGPSecretKeyRingCollection keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        return ConsumerOptions.addDecryptionKeys$default(this, keys, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final ConsumerOptions get() {
        return Companion.get();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource;", "", "()V", "explicitCertificates", "", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "addCertificate", "", "certificate", "getCertificate", "keyId", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getExplicitCertificates", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nConsumerOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n288#2,2:422\n288#2,2:424\n*S KotlinDebug\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource\n*L\n410#1:422,2\n414#1:424,2\n*E\n"})
    public static final class CertificateSource {
        @NotNull
        private final Set<PGPPublicKeyRing> explicitCertificates = new LinkedHashSet();

        public final void addCertificate(@NotNull PGPPublicKeyRing certificate) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            this.explicitCertificates.add(certificate);
        }

        @NotNull
        public final Set<PGPPublicKeyRing> getExplicitCertificates() {
            return CollectionsKt.toSet((Iterable)this.explicitCertificates);
        }

        @Nullable
        public final PGPPublicKeyRing getCertificate(long keyId) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.explicitCertificates;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PGPPublicKeyRing it = (PGPPublicKeyRing)element$iv;
                    boolean bl = false;
                    if (!(it.getPublicKey(keyId) != null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final PGPPublicKeyRing getCertificate(@NotNull PGPSignature signature) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                Iterable $this$firstOrNull$iv = this.explicitCertificates;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PGPPublicKeyRing it = (PGPPublicKeyRing)element$iv;
                    boolean bl = false;
                    if (!(PGPKeyRingExtensionsKt.getPublicKeyFor((PGPKeyRing)it, signature) != null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions$Companion;", "", "()V", "get", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConsumerOptions get() {
            return new ConsumerOptions();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

