/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.io.TeeInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.OpenPgpPacket;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyRingExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.IntegrityProtectedInputStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.decryption_verification.TeeBCPGInputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.PDA;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.exception.MessageNotIntegrityProtectedException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.exception.UnacceptableAlgorithmException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.CertificateValidator;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.signature.consumer.SignatureCheck;
import org.pgpainless.signature.consumer.SignatureValidator;
import org.pgpainless.util.ArmoredInputStreamFactory;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 L2\u00020\u0001:\u0004LMNOB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020.H\u0002J(\u0010/\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\"\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020604032\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001052\u0006\u00108\u001a\u000209H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001052\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u000205032\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u0002062\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020\u001cH\u0002J\b\u0010A\u001a\u00020\u0010H\u0002J\b\u0010B\u001a\u00020\u001cH\u0002J\b\u0010C\u001a\u00020\u001cH\u0002J\b\u0010D\u001a\u00020\u001cH\u0002J\b\u0010E\u001a\u00020FH\u0016J \u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020FH\u0016J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020?H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream;", "Lorg/pgpainless/decryption_verification/DecryptionStream;", "inputStream", "Ljava/io/InputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "metadata", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "policy", "Lorg/pgpainless/policy/Policy;", "(Ljava/io/InputStream;Lorg/pgpainless/decryption_verification/ConsumerOptions;Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;Lorg/pgpainless/policy/Policy;)V", "type", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;", "layerMetadata", "(Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;Ljava/io/InputStream;Lorg/pgpainless/decryption_verification/ConsumerOptions;Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;Lorg/pgpainless/policy/Policy;)V", "closed", "", "Lorg/pgpainless/decryption_verification/MessageMetadata;", "getMetadata", "()Lorg/pgpainless/decryption_verification/MessageMetadata;", "nestedInputStream", "packetInputStream", "Lorg/pgpainless/decryption_verification/TeeBCPGInputStream;", "signatures", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Signatures;", "syntaxVerifier", "Lorg/pgpainless/decryption_verification/syntax_check/PDA;", "close", "", "collectMetadata", "consumePackets", "decompress", "compressedData", "Lorg/bouncycastle/openpgp/PGPCompressedData;", "decryptPKESKAndStream", "esks", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$SortedESKs;", "decryptionKeyId", "Lorg/pgpainless/key/SubkeyIdentifier;", "decryptorFactory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "pkesk", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "decryptSKESKAndStream", "skesk", "Lorg/bouncycastle/openpgp/PGPPBEEncryptedData;", "Lorg/bouncycastle/openpgp/operator/PBEDataDecryptorFactory;", "decryptWithPrivateKey", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "findPotentialDecryptionKeys", "", "Lkotlin/Pair;", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "getDecryptionKey", "keyId", "", "getDecryptionKeys", "hasUnsupportedS2KSpecifier", "secretKey", "isAcceptable", "algorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "processCompressedData", "processEncryptedData", "processLiteralData", "processOnePassSignature", "processSignature", "read", "", "b", "", "off", "len", "throwIfUnacceptable", "Companion", "Signatures", "SortedESKs", "Type", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nOpenPgpMessageInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPgpMessageInputStream.kt\norg/pgpainless/decryption_verification/OpenPgpMessageInputStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1106:1\n766#2:1107\n857#2,2:1108\n1855#2,2:1110\n1855#2,2:1112\n1549#2:1114\n1620#2,3:1115\n1549#2:1119\n1620#2,3:1120\n1549#2:1123\n1620#2,3:1124\n288#2:1127\n1747#2,3:1128\n1747#2,3:1131\n289#2:1134\n288#2:1135\n1747#2,3:1136\n289#2:1139\n766#2:1140\n857#2:1141\n1747#2,3:1142\n858#2:1145\n1855#2,2:1146\n1#3:1118\n*S KotlinDebug\n*F\n+ 1 OpenPgpMessageInputStream.kt\norg/pgpainless/decryption_verification/OpenPgpMessageInputStream\n*L\n344#1:1107\n344#1:1108,2\n348#1:1110,2\n406#1:1112,2\n461#1:1114\n461#1:1115,3\n527#1:1119\n527#1:1120,3\n560#1:1123\n560#1:1124,3\n676#1:1127\n677#1:1128,3\n678#1:1131,3\n676#1:1134\n682#1:1135\n684#1:1136,3\n682#1:1139\n693#1:1140\n693#1:1141\n695#1:1142,3\n693#1:1145\n708#1:1146,2\n*E\n"})
public final class OpenPgpMessageInputStream
extends DecryptionStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConsumerOptions options;
    @NotNull
    private final MessageMetadata.Layer layerMetadata;
    @NotNull
    private final Policy policy;
    @NotNull
    private final Signatures signatures;
    @Nullable
    private TeeBCPGInputStream packetInputStream;
    @Nullable
    private InputStream nestedInputStream;
    @NotNull
    private final PDA syntaxVerifier;
    private boolean closed;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenPgpMessageInputStream.class);

    public OpenPgpMessageInputStream(@NotNull Type type, @NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer layerMetadata, @NotNull Policy policy) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)layerMetadata, (String)"layerMetadata");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        this.options = options;
        this.layerMetadata = layerMetadata;
        this.policy = policy;
        this.signatures = new Signatures(this.options);
        this.syntaxVerifier = new PDA();
        if (this.layerMetadata instanceof MessageMetadata.Message) {
            this.signatures.addDetachedSignatures((Collection<? extends PGPSignature>)this.options.getDetachedSignatures());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                BCPGInputStream bCPGInputStream = BCPGInputStream.wrap((InputStream)inputStream);
                Intrinsics.checkNotNullExpressionValue((Object)bCPGInputStream, (String)"wrap(inputStream)");
                this.packetInputStream = new TeeBCPGInputStream(bCPGInputStream, this.signatures);
                this.consumePackets();
                break;
            }
            case 2: {
                MultiPassStrategy multiPassStrategy = this.options.getMultiPassStrategy();
                PGPSignatureList detachedSignatures = ClearsignedMessageUtil.Companion.detachSignaturesFromInbandClearsignedMessage(inputStream, multiPassStrategy.getMessageOutputStream());
                for (PGPSignature signature : detachedSignatures) {
                    Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
                    this.signatures.addDetachedSignature(signature);
                }
                this.options.isForceNonOpenPgpData();
                this.nestedInputStream = (InputStream)new TeeInputStream(multiPassStrategy.getMessageInputStream(), (OutputStream)this.signatures);
                break;
            }
            case 3: {
                this.packetInputStream = null;
                this.nestedInputStream = (InputStream)new TeeInputStream(inputStream, (OutputStream)this.signatures);
            }
        }
    }

    public OpenPgpMessageInputStream(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull Policy policy) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        this(Type.standard, inputStream, options, metadata, policy);
    }

    private final void consumePackets() {
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        if (teeBCPGInputStream == null) {
            return;
        }
        TeeBCPGInputStream pIn = teeBCPGInputStream;
        OpenPgpPacket packet = null;
        block11: while (true) {
            OpenPgpMessageInputStream $this$consumePackets_u24lambda_u240 = this;
            boolean bl = false;
            packet = pIn.nextPacketTag();
            if (packet == null) break;
            OpenPgpPacket openPgpPacket = packet;
            Intrinsics.checkNotNull((Object)((Object)openPgpPacket));
            this.signatures.nextPacket(openPgpPacket);
            OpenPgpPacket openPgpPacket2 = packet;
            switch (WhenMappings.$EnumSwitchMapping$1[openPgpPacket2.ordinal()]) {
                case 1: {
                    this.processLiteralData();
                    break block11;
                }
                case 2: {
                    this.processCompressedData();
                    break block11;
                }
                case 3: {
                    this.processOnePassSignature();
                    continue block11;
                }
                case 4: {
                    this.processSignature();
                    continue block11;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    if (this.processEncryptedData()) break block11;
                    throw new MissingDecryptionMethodException("No working decryption method found.");
                }
                case 10: {
                    LOGGER.debug("Skipping Marker Packet");
                    pIn.readMarker();
                    continue block11;
                }
                case 11: {
                    LOGGER.debug("Skipping Padding Packet");
                    pIn.readPacket();
                    continue block11;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    throw new MalformedOpenPgpMessageException("Illegal Packet in Stream: " + (Object)((Object)packet));
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    throw new MalformedOpenPgpMessageException("Unsupported Packet in Stream: " + (Object)((Object)packet));
                }
                default: {
                    throw new MalformedOpenPgpMessageException("Unexpected Packet in Stream: " + (Object)((Object)packet));
                }
            }
            break;
        }
    }

    private final void processLiteralData() {
        LOGGER.debug("Literal Data Packet at depth " + this.layerMetadata.getDepth() + " encountered.");
        this.syntaxVerifier.next(InputSymbol.LITERAL_DATA);
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPLiteralData literalData = teeBCPGInputStream.readLiteralData();
        String string = literalData.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literalData.fileName");
        Date date = literalData.getModificationTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"literalData.modificationTime");
        this.layerMetadata.setChild(new MessageMetadata.LiteralData(string, date, StreamEncoding.Companion.requireFromCode(literalData.getFormat())));
        this.nestedInputStream = literalData.getInputStream();
    }

    private final void processCompressedData() {
        this.syntaxVerifier.next(InputSymbol.COMPRESSED_DATA);
        this.signatures.enterNesting();
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPCompressedData compressedData = teeBCPGInputStream.readCompressedData();
        MessageMetadata.CompressedData compressionLayer = new MessageMetadata.CompressedData(CompressionAlgorithm.Companion.requireFromId(compressedData.getAlgorithm()), this.layerMetadata.getDepth() + 1);
        LOGGER.debug("Compressed Data Packet (" + (Object)((Object)compressionLayer.getAlgorithm()) + ") at depth " + this.layerMetadata.getDepth() + " encountered.");
        this.nestedInputStream = new OpenPgpMessageInputStream(this.decompress(compressedData), this.options, compressionLayer, this.policy);
    }

    private final InputStream decompress(PGPCompressedData compressedData) {
        InputStream inputStream;
        switch (compressedData.getAlgorithm()) {
            case 1: {
                InputStream inputStream2 = compressedData.getInputStream();
                Inflater inflater = new Inflater(true);
                inputStream = new InflaterInputStream(inputStream2, inflater){
                    private boolean eof;

                    protected void fill() {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZIP input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 0;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                };
                break;
            }
            case 2: {
                InputStream inputStream3 = compressedData.getInputStream();
                inputStream = new InflaterInputStream(inputStream3){
                    private boolean eof;

                    protected void fill() {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZIP input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 0;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                };
                break;
            }
            default: {
                InputStream inputStream4 = compressedData.getDataStream();
                inputStream = inputStream4;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream4, (String)"compressedData.dataStream");
            }
        }
        return inputStream;
    }

    private final void processOnePassSignature() {
        PGPOnePassSignature pGPOnePassSignature;
        this.syntaxVerifier.next(InputSymbol.ONE_PASS_SIGNATURE);
        try {
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            pGPOnePassSignature = teeBCPGInputStream.readOnePassSignature();
        }
        catch (UnsupportedPacketVersionException e) {
            LOGGER.debug("Unsupported One-Pass-Signature packet version encountered.", (Throwable)e);
            return;
        }
        PGPOnePassSignature ops = pGPOnePassSignature;
        this.signatures.addOnePassSignature(ops);
    }

    private final void processSignature() {
        PGPSignature pGPSignature;
        boolean isSigForOps = this.syntaxVerifier.peekStack() == StackSymbol.OPS;
        this.syntaxVerifier.next(InputSymbol.SIGNATURE);
        try {
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            pGPSignature = teeBCPGInputStream.readSignature();
        }
        catch (UnsupportedPacketVersionException e) {
            LOGGER.debug("Unsupported Signature at depth " + this.layerMetadata.getDepth() + " encountered.", (Throwable)e);
            return;
        }
        PGPSignature signature = pGPSignature;
        long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
        if (isSigForOps) {
            LOGGER.debug("Signature Packet corresponding to One-Pass-Signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " at depth " + this.layerMetadata.getDepth() + " encountered.");
            this.signatures.leaveNesting();
            this.signatures.addCorrespondingOnePassSignature(signature, this.layerMetadata, this.policy);
        } else {
            LOGGER.debug("Prepended Signature Packet by key " + LongExtensionsKt.openPgpKeyId(keyId) + " at depth " + this.layerMetadata.getDepth() + " encountered.");
            this.signatures.addPrependedSignature(signature);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processEncryptedData() {
        LOGGER.debug("Symmetrically Encrypted Data Packet at depth " + this.layerMetadata.getDepth() + " encountered.");
        this.syntaxVerifier.next(InputSymbol.ENCRYPTED_DATA);
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPEncryptedDataList encDataList = teeBCPGInputStream.readEncryptedDataList();
        if (!encDataList.isIntegrityProtected() && !encDataList.get(0).isAEAD()) {
            LOGGER.warn("Symmetrically Encrypted Data Packet is not integrity-protected.");
            if (!this.options.isIgnoreMDCErrors()) {
                throw new MessageNotIntegrityProtectedException();
            }
        }
        SortedESKs esks = new SortedESKs(encDataList);
        LOGGER.debug("Symmetrically Encrypted Integrity-Protected Data has " + esks.getSkesks().size() + " SKESK(s) and " + (esks.getPkesks().size() + esks.getAnonPkesks().size()) + " PKESK(s) from which " + esks.getAnonPkesks().size() + " PKESK(s) have an anonymous recipient.");
        for (Map.Entry<SubkeyIdentifier, PublicKeyDataDecryptorFactory> object : this.options.getCustomDecryptorFactories().entrySet()) {
            Iterator $this$filterTo$iv$iv;
            SubkeyIdentifier key = object.getKey();
            PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = object.getValue();
            LOGGER.debug("Attempt decryption with custom decryptor factory with key " + key + '.');
            Iterable iterable = esks.getPkesks();
            boolean $i$f$filter = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                PGPPublicKeyEncryptedData it = (PGPPublicKeyEncryptedData)element$iv$iv;
                boolean bl = false;
                if (!(it.getKeyID() == key.getSubkeyId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = iterable3.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                PGPPublicKeyEncryptedData it = (PGPPublicKeyEncryptedData)element$iv;
                boolean bl = false;
                if (!this.decryptPKESKAndStream(esks, key, publicKeyDataDecryptorFactory, it)) continue;
                return true;
            }
        }
        if (this.options.getSessionKey() != null) {
            SessionKey sessionKey = this.options.getSessionKey();
            Intrinsics.checkNotNull((Object)sessionKey);
            SessionKey sk = sessionKey;
            LOGGER.debug("Attempt decryption with provided session key.");
            this.throwIfUnacceptable(sk.getAlgorithm());
            SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = ImplementationFactory.Companion.getInstance().getSessionKeyDataDecryptorFactory(sk);
            MessageMetadata.EncryptedData layer = new MessageMetadata.EncryptedData(sk.getAlgorithm(), this.layerMetadata.getDepth() + 1);
            PGPSessionKeyEncryptedData pGPSessionKeyEncryptedData = encDataList.extractSessionKeyEncryptedData();
            try {
                InputStream inputStream = pGPSessionKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
                layer.setSessionKey(sk);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"decrypted");
                Intrinsics.checkNotNullExpressionValue((Object)pGPSessionKeyEncryptedData, (String)"skEncData");
                IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(inputStream, (PGPEncryptedData)pGPSessionKeyEncryptedData, this.options);
                this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, layer, this.policy);
                LOGGER.debug("Successfully decrypted data using provided session key");
                return true;
            }
            catch (PGPException pGPException) {
                LOGGER.debug("Decryption using provided session key failed. Mismatched session key and message?", (Throwable)pGPException);
            }
        }
        for (Passphrase passphrase : this.options.getDecryptionPassphrases()) {
            for (PGPPBEEncryptedData pGPPBEEncryptedData : esks.getSkesks()) {
                LOGGER.debug("Attempt decryption with provided passphrase");
                SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.Companion.requireFromId(pGPPBEEncryptedData.getAlgorithm());
                if (!this.isAcceptable(symmetricKeyAlgorithm)) {
                    LOGGER.debug("Skipping SKESK with unacceptable encapsulation algorithm " + (Object)((Object)symmetricKeyAlgorithm));
                    continue;
                }
                PBEDataDecryptorFactory decryptorFactory = ImplementationFactory.Companion.getInstance().getPBEDataDecryptorFactory(passphrase);
                if (!this.decryptSKESKAndStream(esks, pGPPBEEncryptedData, decryptorFactory)) continue;
                return true;
            }
        }
        List postponedDueToMissingPassphrase = new ArrayList();
        Iterable iterable = esks.getPkesks();
        boolean $i$f$forEach = false;
        for (Object t : iterable) {
            PGPPublicKeyEncryptedData pkesk = (PGPPublicKeyEncryptedData)t;
            boolean bl = false;
            LOGGER.debug("Encountered PKESK for recipient " + LongExtensionsKt.openPgpKeyId(pkesk.getKeyID()));
            List<PGPSecretKeyRing> decryptionKeyCandidates = this.getDecryptionKeys(pkesk);
            for (PGPSecretKeyRing decryptionKeys : decryptionKeyCandidates) {
                SecretKeyRingProtector protector;
                PGPSecretKey secretKey;
                Intrinsics.checkNotNull((Object)PGPSecretKeyRingExtensionsKt.getSecretKeyFor(decryptionKeys, pkesk));
                SubkeyIdentifier decryptionKeyId = new SubkeyIdentifier((PGPKeyRing)decryptionKeys, secretKey.getKeyID());
                if (this.hasUnsupportedS2KSpecifier(secretKey, decryptionKeyId)) continue;
                LOGGER.debug("Attempt decryption using secret key " + decryptionKeyId);
                if (this.options.getSecretKeyProtector(decryptionKeys) == null) continue;
                if (!protector.hasPassphraseFor(secretKey.getKeyID())) {
                    LOGGER.debug("Missing passphrase for key " + decryptionKeyId + ". Postponing decryption until all other keys were tried.");
                    postponedDueToMissingPassphrase.add(TuplesKt.to((Object)secretKey, (Object)pkesk));
                    continue;
                }
                PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(secretKey, protector);
                if (!this.decryptWithPrivateKey(esks, privateKey, decryptionKeyId, pkesk)) continue;
                return true;
            }
        }
        for (PGPPublicKeyEncryptedData pkesk : esks.getAnonPkesks()) {
            for (Pair<PGPSecretKeyRing, PGPSecretKey> pair : this.findPotentialDecryptionKeys(pkesk)) {
                SecretKeyRingProtector protector;
                SubkeyIdentifier decryptionKeyId;
                PGPSecretKeyRing decryptionKeys = (PGPSecretKeyRing)pair.component1();
                PGPSecretKey secretKey = (PGPSecretKey)pair.component2();
                if (this.hasUnsupportedS2KSpecifier(secretKey, decryptionKeyId = new SubkeyIdentifier((PGPKeyRing)decryptionKeys, secretKey.getKeyID()))) continue;
                LOGGER.debug("Attempt decryption of anonymous PKESK with key " + decryptionKeyId + '.');
                if (this.options.getSecretKeyProtector(decryptionKeys) == null) continue;
                if (!protector.hasPassphraseFor(secretKey.getKeyID())) {
                    LOGGER.debug("Missing passphrase for key " + decryptionKeyId + ". Postponing decryption until all other keys were tried.");
                    postponedDueToMissingPassphrase.add(TuplesKt.to((Object)secretKey, (Object)pkesk));
                    continue;
                }
                PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(secretKey, protector);
                if (!this.decryptWithPrivateKey(esks, privateKey, decryptionKeyId, pkesk)) continue;
                return true;
            }
        }
        if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.THROW_EXCEPTION) {
            List list;
            Iterable iterable4 = postponedDueToMissingPassphrase;
            boolean $i$f$map = false;
            Iterable iterable5 = iterable4;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable5) {
                void it;
                Pair protector = (Pair)item$iv$iv;
                Collection collection2 = collection;
                boolean bl = false;
                PGPSecretKeyRing pGPSecretKeyRing = this.getDecryptionKey(((PGPSecretKey)it.getFirst()).getKeyID());
                Intrinsics.checkNotNull((Object)pGPSecretKeyRing);
                collection2.add(new SubkeyIdentifier((PGPKeyRing)pGPSecretKeyRing, ((PGPSecretKey)it.getFirst()).getKeyID()));
            }
            List it = list = (List)collection;
            boolean bl = false;
            if (!((Collection)it).isEmpty()) {
                throw new MissingPassphraseException(CollectionsKt.toSet((Iterable)it));
            }
        } else if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.INTERACTIVE) {
            for (Pair pair : postponedDueToMissingPassphrase) {
                SecretKeyRingProtector protector;
                PGPPrivateKey privateKey;
                PGPSecretKeyRing decryptionKeys;
                PGPSecretKey pGPSecretKey = (PGPSecretKey)pair.component1();
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pair.component2();
                long keyId = pGPSecretKey.getKeyID();
                Intrinsics.checkNotNull((Object)this.getDecryptionKey(pGPPublicKeyEncryptedData));
                SubkeyIdentifier decryptionKeyId = new SubkeyIdentifier((PGPKeyRing)decryptionKeys, keyId);
                if (this.hasUnsupportedS2KSpecifier(pGPSecretKey, decryptionKeyId)) continue;
                LOGGER.debug("Attempt decryption with key " + decryptionKeyId + " while interactively requesting its passphrase.");
                if (this.options.getSecretKeyProtector(decryptionKeys) == null || !this.decryptWithPrivateKey(esks, privateKey = PGPSecretKeyExtensionsKt.unlock(pGPSecretKey, protector), decryptionKeyId, pGPPublicKeyEncryptedData)) continue;
                return true;
            }
        } else {
            throw new IllegalStateException("Invalid PostponedKeysStrategy set in consumer options.");
        }
        LOGGER.debug("Failed to decrypt encrypted data packet.");
        return false;
    }

    private final boolean decryptWithPrivateKey(SortedESKs esks, PGPPrivateKey privateKey, SubkeyIdentifier decryptionKeyId, PGPPublicKeyEncryptedData pkesk) {
        PublicKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.Companion.getInstance().getPublicKeyDataDecryptorFactory(privateKey);
        return this.decryptPKESKAndStream(esks, decryptionKeyId, decryptorFactory, pkesk);
    }

    private final boolean hasUnsupportedS2KSpecifier(PGPSecretKey secretKey, SubkeyIdentifier decryptionKeyId) {
        S2K s2k = secretKey.getS2K();
        if (s2k != null) {
            int n = s2k.getType();
            boolean bl = 100 <= n ? n < 111 : false;
            if (bl) {
                LOGGER.debug("Skipping PKESK because key " + decryptionKeyId + " has unsupported private S2K specifier " + s2k.getType());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean decryptSKESKAndStream(SortedESKs esks, PGPPBEEncryptedData skesk, PBEDataDecryptorFactory decryptorFactory) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InputStream decrypted = skesk.getDataStream(decryptorFactory);
            PGPSessionKey pGPSessionKey = skesk.getSessionKey(decryptorFactory);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSessionKey, (String)"skesk.getSessionKey(decryptorFactory)");
            SessionKey sessionKey = new SessionKey(pGPSessionKey);
            this.throwIfUnacceptable(sessionKey.getAlgorithm());
            MessageMetadata.EncryptedData encryptedData = new MessageMetadata.EncryptedData(sessionKey.getAlgorithm(), this.layerMetadata.getDepth() + 1);
            encryptedData.setSessionKey(sessionKey);
            Iterable iterable = esks.getPkesks();
            MessageMetadata.EncryptedData encryptedData2 = encryptedData;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyID());
            }
            encryptedData2.addRecipients((List)destination$iv$iv);
            LOGGER.debug("Successfully decrypted data with passphrase");
            Intrinsics.checkNotNullExpressionValue((Object)decrypted, (String)"decrypted");
            IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(decrypted, (PGPEncryptedData)skesk, this.options);
            this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, encryptedData, this.policy);
            return true;
        }
        catch (UnacceptableAlgorithmException e) {
            throw e;
        }
        catch (PGPException e) {
            LOGGER.debug("Decryption of encrypted data packet using password failed. Password mismatch?", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean decryptPKESKAndStream(SortedESKs esks, SubkeyIdentifier decryptionKeyId, PublicKeyDataDecryptorFactory decryptorFactory, PGPPublicKeyEncryptedData pkesk) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InputStream decrypted = pkesk.getDataStream(decryptorFactory);
            PGPSessionKey pGPSessionKey = pkesk.getSessionKey(decryptorFactory);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSessionKey, (String)"pkesk.getSessionKey(decryptorFactory)");
            SessionKey sessionKey = new SessionKey(pGPSessionKey);
            this.throwIfUnacceptable(sessionKey.getAlgorithm());
            MessageMetadata.EncryptedData encryptedData = new MessageMetadata.EncryptedData(SymmetricKeyAlgorithm.Companion.requireFromId(pkesk.getSymmetricAlgorithm(decryptorFactory)), this.layerMetadata.getDepth() + 1);
            encryptedData.setDecryptionKey(decryptionKeyId);
            encryptedData.setSessionKey(sessionKey);
            Iterable iterable = CollectionsKt.plus((Collection)esks.getPkesks(), (Iterable)esks.getAnonPkesks());
            MessageMetadata.EncryptedData encryptedData2 = encryptedData;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyID());
            }
            encryptedData2.addRecipients((List)destination$iv$iv);
            LOGGER.debug("Successfully decrypted data with key " + decryptionKeyId);
            Intrinsics.checkNotNullExpressionValue((Object)decrypted, (String)"decrypted");
            IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(decrypted, (PGPEncryptedData)pkesk, this.options);
            this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, encryptedData, this.policy);
            return true;
        }
        catch (UnacceptableAlgorithmException e) {
            throw e;
        }
        catch (PGPException e) {
            LOGGER.debug("Decryption of encrypted data packet using secret key failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public int read() {
        int n;
        if (this.nestedInputStream == null) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return -1;
        }
        try {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            n = inputStream.read();
        }
        catch (IOException e) {
            n = -1;
        }
        int r = n;
        if (r != -1) {
            this.signatures.updateLiteral((byte)r);
        } else {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            inputStream.close();
            this.collectMetadata();
            this.nestedInputStream = null;
            if (this.packetInputStream != null) {
                try {
                    this.consumePackets();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signatures.finish(this.layerMetadata, this.policy);
        }
        return r;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.nestedInputStream == null) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return -1;
        }
        InputStream inputStream = this.nestedInputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        int r = inputStream.read(b, off, len);
        if (r != -1) {
            this.signatures.updateLiteral(b, off, r);
        } else {
            InputStream inputStream2 = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream2);
            inputStream2.close();
            this.collectMetadata();
            this.nestedInputStream = null;
            if (this.packetInputStream != null) {
                try {
                    this.consumePackets();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signatures.finish(this.layerMetadata, this.policy);
        }
        return r;
    }

    @Override
    public void close() {
        super.close();
        if (this.closed) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return;
        }
        if (this.nestedInputStream != null) {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            inputStream.close();
            this.collectMetadata();
            this.nestedInputStream = null;
        }
        try {
            this.consumePackets();
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        if (this.packetInputStream != null) {
            this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
            this.syntaxVerifier.assertValid();
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            teeBCPGInputStream.close();
        }
        this.closed = true;
    }

    private final void collectMetadata() {
        if (this.nestedInputStream instanceof OpenPgpMessageInputStream) {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.OpenPgpMessageInputStream");
            OpenPgpMessageInputStream child = (OpenPgpMessageInputStream)inputStream;
            MessageMetadata.Layer layer = child.layerMetadata;
            Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Nested");
            this.layerMetadata.setChild((MessageMetadata.Nested)((Object)layer));
        }
    }

    @Override
    @NotNull
    public MessageMetadata getMetadata() {
        if (!this.closed) {
            boolean bl = false;
            String string = "Stream must be closed before access to metadata can be granted.";
            throw new IllegalStateException(string.toString());
        }
        MessageMetadata.Layer layer = this.layerMetadata;
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Message");
        return new MessageMetadata((MessageMetadata.Message)layer);
    }

    private final PGPSecretKeyRing getDecryptionKey(long keyId) {
        Object v2;
        block9: {
            Iterable $this$firstOrNull$iv = this.options.getDecryptionKeys();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                block8: {
                    PGPSecretKey k;
                    boolean bl4;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    PGPSecretKeyRing it;
                    block7: {
                        it = (PGPSecretKeyRing)element$iv;
                        boolean bl5 = false;
                        $this$any$iv = (Iterable)it;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                k = (PGPSecretKey)element$iv2;
                                boolean bl6 = false;
                                if (!(k.getKeyID() == keyId)) continue;
                                bl4 = true;
                                break block7;
                            }
                            bl4 = false;
                        }
                    }
                    $this$any$iv = PGPainless.Companion.inspectKeyRing$default(PGPainless.Companion, (PGPKeyRing)it, null, 2, null).getDecryptionSubkeys();
                    bl3 = bl4;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            k = (PGPPublicKey)element$iv2;
                            boolean bl7 = false;
                            if (!(k.getKeyID() == keyId)) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                if (!(bl3 & (bl = bl2))) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PGPSecretKeyRing getDecryptionKey(PGPPublicKeyEncryptedData pkesk) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = this.options.getDecryptionKeys();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl2 = false;
            if (PGPSecretKeyRingExtensionsKt.getSecretKeyFor(it, pkesk) != null) {
                boolean bl3;
                block7: {
                    Iterable $this$any$iv = PGPainless.Companion.inspectKeyRing$default(PGPainless.Companion, (PGPKeyRing)it, null, 2, null).getDecryptionSubkeys();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            PGPPublicKey subkey = (PGPPublicKey)element$iv2;
                            boolean bl4 = false;
                            if (pkesk.getVersion() != 3) throw new NotImplementedError("Version 6 PKESK not yet supported.");
                            if (!(pkesk.getKeyID() == subkey.getKeyID())) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private final List<PGPSecretKeyRing> getDecryptionKeys(PGPPublicKeyEncryptedData pkesk) {
        $this$filter$iv = this.options.getDecryptionKeys();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block8: {
                it = (PGPSecretKeyRing)element$iv$iv;
                $i$a$-filter-OpenPgpMessageInputStream$getDecryptionKeys$1 = false;
                if (PGPSecretKeyRingExtensionsKt.getSecretKeyFor(it, pkesk) == null) ** GOTO lbl-1000
                $this$any$iv = PGPainless.Companion.inspectKeyRing$default(PGPainless.Companion, (PGPKeyRing)it, null, 2, null).getDecryptionSubkeys();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        subkey = (PGPPublicKey)element$iv;
                        $i$a$-any-OpenPgpMessageInputStream$getDecryptionKeys$1$1 = false;
                        if (pkesk.getVersion() == 3) {
                            v1 = pkesk.getKeyID() == subkey.getKeyID();
                        } else {
                            throw new NotImplementedError("Version 6 PKESK not yet supported.");
                        }
                        if (!v1) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Pair<PGPSecretKeyRing, PGPSecretKey>> findPotentialDecryptionKeys(PGPPublicKeyEncryptedData pkesk) {
        int algorithm = pkesk.getAlgorithm();
        List candidates = new ArrayList();
        Iterable $this$forEach$iv = this.options.getDecryptionKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            KeyRingInfo info = PGPainless.Companion.inspectKeyRing$default(PGPainless.Companion, (PGPKeyRing)it, null, 2, null);
            for (PGPPublicKey key : info.getDecryptionSubkeys()) {
                if (key.getAlgorithm() != algorithm || !info.isSecretKeyAvailable(key.getKeyID())) continue;
                candidates.add(TuplesKt.to((Object)it, (Object)it.getSecretKey(key.getKeyID())));
            }
        }
        return candidates;
    }

    private final boolean isAcceptable(SymmetricKeyAlgorithm algorithm) {
        return this.policy.getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(algorithm);
    }

    private final void throwIfUnacceptable(SymmetricKeyAlgorithm algorithm) {
        if (!this.isAcceptable(algorithm)) {
            throw new UnacceptableAlgorithmException("Symmetric-Key algorithm " + (Object)((Object)algorithm) + " is not acceptable for message decryption.");
        }
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options) {
        return Companion.create(inputStream, options);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull Policy policy) {
        return Companion.create(inputStream, options, policy);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpMessageInputStream create$pgpainless_core(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull Policy policy) {
        return Companion.create$pgpainless_core(inputStream, options, metadata, policy);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$annotations", "create", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream;", "inputStream", "Ljava/io/InputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "metadata", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "policy", "Lorg/pgpainless/policy/Policy;", "create$pgpainless_core", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        @JvmStatic
        @NotNull
        public final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return this.create(inputStream, options, PGPainless.Companion.getPolicy());
        }

        @JvmStatic
        @NotNull
        public final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull Policy policy) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            return this.create$pgpainless_core(inputStream, options, new MessageMetadata.Message(false, 1, null), policy);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpMessageInputStream create$pgpainless_core(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull Policy policy) {
            OpenPgpMessageInputStream openPgpMessageInputStream;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            OpenPgpInputStream openPgpIn = new OpenPgpInputStream(inputStream);
            openPgpIn.reset();
            if (openPgpIn.isNonOpenPgp() || options.isForceNonOpenPgpData()) {
                return new OpenPgpMessageInputStream(Type.non_openpgp, openPgpIn, options, metadata, policy);
            }
            if (openPgpIn.isBinaryOpenPgp()) {
                return new OpenPgpMessageInputStream(Type.standard, openPgpIn, options, metadata, policy);
            }
            if (openPgpIn.isAsciiArmored()) {
                ArmoredInputStream armorIn = ArmoredInputStreamFactory.Companion.get$default(ArmoredInputStreamFactory.Companion, openPgpIn, null, 2, null);
                if (armorIn.isClearText()) {
                    ((MessageMetadata.Message)metadata).setCleartextSigned();
                    openPgpMessageInputStream = new OpenPgpMessageInputStream(Type.cleartext_signed, (InputStream)armorIn, options, metadata, policy);
                } else {
                    openPgpMessageInputStream = new OpenPgpMessageInputStream(Type.standard, (InputStream)armorIn, options, metadata, policy);
                }
            } else {
                throw new AssertionError((Object)"Cannot deduce type of data.");
            }
            return openPgpMessageInputStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000 H2\u00020\u0001:\u0001HB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007J\u0014\u00100\u001a\u00020)2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000702J\u000e\u00103\u001a\u00020)2\u0006\u0010*\u001a\u000204J\u000e\u00105\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007J\u0006\u00106\u001a\u00020)J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010*\u001a\u000204H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0016\u00109\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\u0007J\u0006\u0010;\u001a\u00020)J\u000e\u0010<\u001a\u00020)2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020@J\u001e\u0010>\u001a\u00020)2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DJ\u000e\u0010F\u001a\u00020)2\u0006\u0010?\u001a\u00020@J\u001e\u0010F\u001a\u00020)2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DJ \u0010G\u001a\u00020)2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0016J\u0010\u0010G\u001a\u00020)2\u0006\u0010?\u001a\u00020DH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u001d\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\tR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\t\u00a8\u0006I"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Signatures;", "Ljava/io/OutputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "(Lorg/pgpainless/decryption_verification/ConsumerOptions;)V", "correspondingSignatures", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "getCorrespondingSignatures", "()Ljava/util/List;", "detachedSignatures", "Lorg/pgpainless/signature/consumer/SignatureCheck;", "getDetachedSignatures", "detachedSignaturesWithMissingCert", "Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "getDetachedSignaturesWithMissingCert", "inbandSignaturesWithMissingCert", "getInbandSignaturesWithMissingCert", "isLiteral", "", "()Z", "setLiteral", "(Z)V", "literalOPS", "Lorg/pgpainless/signature/consumer/OnePassSignatureCheck;", "getLiteralOPS", "setLiteralOPS", "(Ljava/util/List;)V", "onePassSignatures", "getOnePassSignatures", "opsUpdateStack", "Lkotlin/collections/ArrayDeque;", "getOpsUpdateStack", "()Lkotlin/collections/ArrayDeque;", "getOptions", "()Lorg/pgpainless/decryption_verification/ConsumerOptions;", "prependedSignatures", "getPrependedSignatures", "prependedSignaturesWithMissingCert", "getPrependedSignaturesWithMissingCert", "addCorrespondingOnePassSignature", "", "signature", "layer", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "policy", "Lorg/pgpainless/policy/Policy;", "addDetachedSignature", "addDetachedSignatures", "signatures", "", "addOnePassSignature", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "addPrependedSignature", "enterNesting", "findCertificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "finish", "initializeSignature", "leaveNesting", "nextPacket", "Lorg/pgpainless/algorithm/OpenPgpPacket;", "updateLiteral", "b", "", "buf", "", "off", "", "len", "updatePacket", "write", "Companion", "pgpainless-core"})
    private static final class Signatures
    extends OutputStream {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ConsumerOptions options;
        @NotNull
        private final List<SignatureCheck> detachedSignatures;
        @NotNull
        private final List<SignatureCheck> prependedSignatures;
        @NotNull
        private final List<OnePassSignatureCheck> onePassSignatures;
        @NotNull
        private final ArrayDeque<List<OnePassSignatureCheck>> opsUpdateStack;
        @NotNull
        private List<OnePassSignatureCheck> literalOPS;
        @NotNull
        private final List<PGPSignature> correspondingSignatures;
        @NotNull
        private final List<SignatureVerification.Failure> prependedSignaturesWithMissingCert;
        @NotNull
        private final List<SignatureVerification.Failure> inbandSignaturesWithMissingCert;
        @NotNull
        private final List<SignatureVerification.Failure> detachedSignaturesWithMissingCert;
        private boolean isLiteral;

        public Signatures(@NotNull ConsumerOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.options = options;
            this.detachedSignatures = new ArrayList();
            this.prependedSignatures = new ArrayList();
            this.onePassSignatures = new ArrayList();
            this.opsUpdateStack = new ArrayDeque();
            this.literalOPS = new ArrayList();
            this.correspondingSignatures = new ArrayList();
            this.prependedSignaturesWithMissingCert = new ArrayList();
            this.inbandSignaturesWithMissingCert = new ArrayList();
            this.detachedSignaturesWithMissingCert = new ArrayList();
            this.isLiteral = true;
        }

        @NotNull
        public final ConsumerOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final List<SignatureCheck> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        @NotNull
        public final List<SignatureCheck> getPrependedSignatures() {
            return this.prependedSignatures;
        }

        @NotNull
        public final List<OnePassSignatureCheck> getOnePassSignatures() {
            return this.onePassSignatures;
        }

        @NotNull
        public final ArrayDeque<List<OnePassSignatureCheck>> getOpsUpdateStack() {
            return this.opsUpdateStack;
        }

        @NotNull
        public final List<OnePassSignatureCheck> getLiteralOPS() {
            return this.literalOPS;
        }

        public final void setLiteralOPS(@NotNull List<OnePassSignatureCheck> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.literalOPS = list;
        }

        @NotNull
        public final List<PGPSignature> getCorrespondingSignatures() {
            return this.correspondingSignatures;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getPrependedSignaturesWithMissingCert() {
            return this.prependedSignaturesWithMissingCert;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getInbandSignaturesWithMissingCert() {
            return this.inbandSignaturesWithMissingCert;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getDetachedSignaturesWithMissingCert() {
            return this.detachedSignaturesWithMissingCert;
        }

        public final boolean isLiteral() {
            return this.isLiteral;
        }

        public final void setLiteral(boolean bl) {
            this.isLiteral = bl;
        }

        public final void addDetachedSignatures(@NotNull Collection<? extends PGPSignature> signatures) {
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            for (PGPSignature pGPSignature : signatures) {
                this.addDetachedSignature(pGPSignature);
            }
        }

        public final void addDetachedSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            SignatureCheck check = this.initializeSignature(signature);
            long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
            if (check != null) {
                this.detachedSignatures.add(check);
            } else {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " found.");
                this.detachedSignaturesWithMissingCert.add(new SignatureVerification.Failure(signature, null, new SignatureValidationException("Missing verification key.")));
            }
        }

        public final void addPrependedSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            SignatureCheck check = this.initializeSignature(signature);
            long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
            if (check != null) {
                this.prependedSignatures.add(check);
            } else {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " found.");
                this.prependedSignaturesWithMissingCert.add(new SignatureVerification.Failure(signature, null, new SignatureValidationException("Missing verification key")));
            }
        }

        @Nullable
        public final SignatureCheck initializeSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            PGPPublicKeyRing pGPPublicKeyRing = this.findCertificate(signature);
            if (pGPPublicKeyRing == null) {
                return null;
            }
            PGPPublicKeyRing certificate = pGPPublicKeyRing;
            PGPPublicKey pGPPublicKey = PGPKeyRingExtensionsKt.getPublicKeyFor((PGPKeyRing)certificate, signature);
            if (pGPPublicKey == null) {
                return null;
            }
            PGPPublicKey publicKey = pGPPublicKey;
            SubkeyIdentifier verifierKey = new SubkeyIdentifier((PGPKeyRing)certificate, publicKey.getKeyID());
            Signatures.Companion.initialize(signature, publicKey);
            return new SignatureCheck(signature, (PGPKeyRing)certificate, verifierKey);
        }

        public final void addOnePassSignature(@NotNull PGPOnePassSignature signature) {
            PGPPublicKey publicKey;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            PGPPublicKeyRing certificate = this.findCertificate(signature);
            if (certificate != null && (publicKey = PGPKeyRingExtensionsKt.getPublicKeyFor((PGPKeyRing)certificate, signature)) != null) {
                OnePassSignatureCheck ops = new OnePassSignatureCheck(signature, certificate, null, 4, null);
                Signatures.Companion.initialize(signature, publicKey);
                this.onePassSignatures.add(ops);
                this.literalOPS.add(ops);
            }
            if (signature.isContaining()) {
                this.enterNesting();
            }
        }

        public final void addCorrespondingOnePassSignature(@NotNull PGPSignature signature, @NotNull MessageMetadata.Layer layer, @NotNull Policy policy) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            boolean found = false;
            long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
            for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)this.onePassSignatures))) {
                int i = indexedValue.component1();
                OnePassSignatureCheck check = (OnePassSignatureCheck)indexedValue.component2();
                if (check.getOnePassSignature().getKeyID() != keyId) continue;
                found = true;
                if (check.getSignature() != null) continue;
                check.setSignature(signature);
                SignatureVerification verification = new SignatureVerification(signature, new SubkeyIdentifier((PGPKeyRing)check.getVerificationKeys(), check.getOnePassSignature().getKeyID()));
                try {
                    SignatureValidator.Companion.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(signature);
                    CertificateValidator.Companion.validateCertificateAndVerifyOnePassSignature(check, policy);
                    LOGGER.debug("Acceptable signature by key " + verification.getSigningKey());
                    layer.addVerifiedOnePassSignature(verification);
                    break;
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejected signature by key " + verification.getSigningKey(), (Throwable)((Object)e));
                    layer.addRejectedOnePassSignature(new SignatureVerification.Failure(verification, e));
                    break;
                }
            }
            if (!found) {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " found.");
                this.inbandSignaturesWithMissingCert.add(new SignatureVerification.Failure(signature, null, new SignatureValidationException("Missing verification key.")));
            }
        }

        public final void enterNesting() {
            this.opsUpdateStack.addFirst(this.literalOPS);
            this.literalOPS = new ArrayList();
        }

        public final void leaveNesting() {
            if (this.opsUpdateStack.isEmpty()) {
                return;
            }
            this.opsUpdateStack.removeFirst();
        }

        private final PGPPublicKeyRing findCertificate(PGPSignature signature) {
            PGPPublicKeyRing cert = this.options.getCertificateSource().getCertificate(signature);
            if (cert != null) {
                return cert;
            }
            if (this.options.getMissingCertificateCallback() != null) {
                MissingPublicKeyCallback missingPublicKeyCallback = this.options.getMissingCertificateCallback();
                Intrinsics.checkNotNull((Object)missingPublicKeyCallback);
                return missingPublicKeyCallback.onMissingPublicKeyEncountered(signature.getKeyID());
            }
            return null;
        }

        private final PGPPublicKeyRing findCertificate(PGPOnePassSignature signature) {
            PGPPublicKeyRing cert = this.options.getCertificateSource().getCertificate(signature.getKeyID());
            if (cert != null) {
                return cert;
            }
            if (this.options.getMissingCertificateCallback() != null) {
                MissingPublicKeyCallback missingPublicKeyCallback = this.options.getMissingCertificateCallback();
                Intrinsics.checkNotNull((Object)missingPublicKeyCallback);
                return missingPublicKeyCallback.onMissingPublicKeyEncountered(signature.getKeyID());
            }
            return null;
        }

        public final void updateLiteral(byte b) {
            for (OnePassSignatureCheck ops : this.literalOPS) {
                ops.getOnePassSignature().update(b);
            }
            for (SignatureCheck detached : this.detachedSignatures) {
                detached.getSignature().update(b);
            }
            for (SignatureCheck prepended : this.prependedSignatures) {
                prepended.getSignature().update(b);
            }
        }

        public final void updateLiteral(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (OnePassSignatureCheck ops : this.literalOPS) {
                ops.getOnePassSignature().update(buf, off, len);
            }
            for (SignatureCheck detached : this.detachedSignatures) {
                detached.getSignature().update(buf, off, len);
            }
            for (SignatureCheck prepended : this.prependedSignatures) {
                prepended.getSignature().update(buf, off, len);
            }
        }

        public final void updatePacket(byte b) {
            for (List nestedOPSs : CollectionsKt.reversed((Iterable)((Iterable)this.opsUpdateStack))) {
                for (OnePassSignatureCheck ops : nestedOPSs) {
                    ops.getOnePassSignature().update(b);
                }
            }
        }

        public final void updatePacket(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (List nestedOPSs : CollectionsKt.reversed((Iterable)((Iterable)this.opsUpdateStack))) {
                for (OnePassSignatureCheck ops : nestedOPSs) {
                    ops.getOnePassSignature().update(buf, off, len);
                }
            }
        }

        public final void finish(@NotNull MessageMetadata.Layer layer, @NotNull Policy policy) {
            SignatureVerification verification;
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            for (SignatureCheck detached : this.detachedSignatures) {
                verification = new SignatureVerification(detached.getSignature(), detached.getSigningKeyIdentifier());
                try {
                    SignatureValidator.Companion.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(detached.getSignature());
                    CertificateValidator.Companion.validateCertificateAndVerifyInitializedSignature(detached.getSignature(), KeyRingUtils.Companion.publicKeys(detached.getSigningKeyRing()), policy);
                    LOGGER.debug("Acceptable signature by key " + verification.getSigningKey());
                    layer.addVerifiedDetachedSignature(verification);
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejected signature by key " + verification.getSigningKey(), (Throwable)((Object)e));
                    layer.addRejectedDetachedSignature(new SignatureVerification.Failure(verification, e));
                }
            }
            for (SignatureCheck prepended : this.prependedSignatures) {
                verification = new SignatureVerification(prepended.getSignature(), prepended.getSigningKeyIdentifier());
                try {
                    SignatureValidator.Companion.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(prepended.getSignature());
                    CertificateValidator.Companion.validateCertificateAndVerifyInitializedSignature(prepended.getSignature(), KeyRingUtils.Companion.publicKeys(prepended.getSigningKeyRing()), policy);
                    LOGGER.debug("Acceptable signature by key " + verification.getSigningKey());
                    layer.addVerifiedPrependedSignature(verification);
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejected signature by key " + verification.getSigningKey(), (Throwable)((Object)e));
                    layer.addRejectedPrependedSignature(new SignatureVerification.Failure(verification, e));
                }
            }
            for (SignatureVerification.Failure rejected : this.inbandSignaturesWithMissingCert) {
                layer.addRejectedOnePassSignature(rejected);
            }
            for (SignatureVerification.Failure rejected : this.prependedSignaturesWithMissingCert) {
                layer.addRejectedPrependedSignature(rejected);
            }
            for (SignatureVerification.Failure rejected : this.detachedSignaturesWithMissingCert) {
                layer.addRejectedDetachedSignature(rejected);
            }
        }

        @Override
        public void write(int b) {
            this.updatePacket((byte)b);
        }

        @Override
        public void write(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.updatePacket(buf, off, len);
        }

        public final void nextPacket(@NotNull OpenPgpPacket nextPacket) {
            Intrinsics.checkNotNullParameter((Object)((Object)nextPacket), (String)"nextPacket");
            if (nextPacket == OpenPgpPacket.LIT) {
                this.isLiteral = true;
                if (this.literalOPS.isEmpty() && !((Collection)this.opsUpdateStack).isEmpty()) {
                    this.literalOPS = (List)this.opsUpdateStack.removeFirst();
                }
            } else {
                this.isLiteral = false;
            }
        }

        @JvmStatic
        private static final void initialize(PGPSignature signature, PGPPublicKey publicKey) {
            Signatures.Companion.initialize(signature, publicKey);
        }

        @JvmStatic
        private static final void initialize(PGPOnePassSignature ops, PGPPublicKey publicKey) {
            Signatures.Companion.initialize(ops, publicKey);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Signatures$Companion;", "", "()V", "initialize", "", "ops", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            private final void initialize(PGPSignature signature, PGPPublicKey publicKey) {
                PGPContentVerifierBuilderProvider verifierProvider = ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider();
                try {
                    signature.init(verifierProvider, publicKey);
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }

            @JvmStatic
            private final void initialize(PGPOnePassSignature ops, PGPPublicKey publicKey) {
                PGPContentVerifierBuilderProvider verifierProvider = ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider();
                try {
                    ops.init(verifierProvider, publicKey);
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$SortedESKs;", "", "esks", "Lorg/bouncycastle/openpgp/PGPEncryptedDataList;", "(Lorg/bouncycastle/openpgp/PGPEncryptedDataList;)V", "all", "", "Lorg/bouncycastle/openpgp/PGPEncryptedData;", "getAll", "()Ljava/util/List;", "anonPkesks", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "getAnonPkesks", "pkesks", "getPkesks", "skesks", "Lorg/bouncycastle/openpgp/PGPPBEEncryptedData;", "getSkesks", "pgpainless-core"})
    private static final class SortedESKs {
        @NotNull
        private final List<PGPPBEEncryptedData> skesks;
        @NotNull
        private final List<PGPPublicKeyEncryptedData> pkesks;
        @NotNull
        private final List<PGPPublicKeyEncryptedData> anonPkesks;

        public SortedESKs(@NotNull PGPEncryptedDataList esks) {
            Intrinsics.checkNotNullParameter((Object)esks, (String)"esks");
            this.skesks = new ArrayList();
            this.pkesks = new ArrayList();
            this.anonPkesks = new ArrayList();
            for (PGPEncryptedData esk : esks) {
                if (esk instanceof PGPPBEEncryptedData) {
                    this.skesks.add((PGPPBEEncryptedData)esk);
                    continue;
                }
                if (esk instanceof PGPPublicKeyEncryptedData) {
                    if (((PGPPublicKeyEncryptedData)esk).getKeyID() != 0L) {
                        this.pkesks.add((PGPPublicKeyEncryptedData)esk);
                        continue;
                    }
                    this.anonPkesks.add((PGPPublicKeyEncryptedData)esk);
                    continue;
                }
                throw new IllegalArgumentException("Unknown ESK class type " + esk.getClass());
            }
        }

        @NotNull
        public final List<PGPPBEEncryptedData> getSkesks() {
            return this.skesks;
        }

        @NotNull
        public final List<PGPPublicKeyEncryptedData> getPkesks() {
            return this.pkesks;
        }

        @NotNull
        public final List<PGPPublicKeyEncryptedData> getAnonPkesks() {
            return this.anonPkesks;
        }

        @NotNull
        public final List<PGPEncryptedData> getAll() {
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.skesks, (Iterable)this.pkesks), (Iterable)this.anonPkesks);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;", "", "(Ljava/lang/String;I)V", "standard", "cleartext_signed", "non_openpgp", "pgpainless-core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type standard = new Type();
        public static final /* enum */ Type cleartext_signed = new Type();
        public static final /* enum */ Type non_openpgp = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.standard, Type.cleartext_signed, Type.non_openpgp};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.standard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.cleartext_signed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.non_openpgp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OpenPgpPacket.values().length];
            try {
                nArray[OpenPgpPacket.LIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.COMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.OPS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PKESK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SKESK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SEIPD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.OED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.MARKER.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PADDING.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SK.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PK.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SSK.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PSK.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.TRUST.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.UID.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.UATTR.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_1.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_2.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_3.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_4.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

