/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArmoredInputStreamOverArmoredDataWithAppendedCleartextTest {
    private static final String ASCII_ARMORED_WITH_APPENDED_GARBAGE = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nyxRiAAAAAABIZWxsbywgV29ybGQhCg==\n=WGju\n-----END PGP MESSAGE-----\nThis is a bunch of crap that we appended.";

    @Test
    public void testArmoredInputStreamCutsOffAnyDataAfterTheAsciiArmor() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ASCII_ARMORED_WITH_APPENDED_GARBAGE.getBytes(StandardCharsets.UTF_8));
        ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)inputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)armorIn, (OutputStream)out);
        armorIn.close();
        Assertions.assertEquals((int)22, (int)out.size(), (String)"ArmoredInputStream cuts off any appended data outside the ASCII armor.");
    }
}

